/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import java.time.format.TextStyle;
import java.util.Locale;

public enum Month {
    JANUARY(0),
    FEBRUARY(1),
    MARCH(2),
    APRIL(3),
    MAY(4),
    JUNE(5),
    JULY(6),
    AUGUST(7),
    SEPTEMBER(8),
    OCTOBER(9),
    NOVEMBER(10),
    DECEMBER(11),
    UNDECIMBER(12);

    private static final String[] ALIASES;
    private static final Month[] ENUMS;
    private final int value;

    /*
     * WARNING - void declaration
     */
    private Month(int value) {
        void var3_3;
        this.value = var3_3;
    }

    public final int getValue() {
        return this.value;
    }

    public final int getValueBaseOne() {
        Assert.isFalse(this == UNDECIMBER, "Unsupported UNDECIMBER Field", new Object[0]);
        return this.getValue() + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getLastDay(boolean isLeapYear) {
        switch (this) {
            case FEBRUARY: {
                void var1_1;
                if (var1_1 != false) {
                    return 29;
                }
                return 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public static Month of(int calendarMonthIntValue) {
        int n;
        if (calendarMonthIntValue >= ENUMS.length || calendarMonthIntValue < 0) {
            return null;
        }
        return ENUMS[n];
    }

    /*
     * WARNING - void declaration
     */
    public static Month of(String name) throws IllegalArgumentException {
        void var1_1;
        Assert.notBlank(name);
        Month of = Month.of(ArrayUtil.indexOfIgnoreCase(ALIASES, name));
        if (of == null) {
            String string;
            of = Month.valueOf(string.toUpperCase());
        }
        return var1_1;
    }

    public static Month of(java.time.Month month) {
        return Month.of(month.ordinal());
    }

    /*
     * WARNING - void declaration
     */
    public static int getLastDay(int month, boolean isLeapYear) {
        void var1_1;
        void var2_2;
        int n;
        Month of = Month.of(month);
        Assert.notNull(of, "Invalid Month base 0: " + n, new Object[0]);
        return var2_2.getLastDay((boolean)var1_1);
    }

    public final java.time.Month toJdkMonth() {
        return java.time.Month.of(this.getValueBaseOne());
    }

    /*
     * WARNING - void declaration
     */
    public final String getDisplayName(TextStyle style) {
        void var1_1;
        return this.getDisplayName((TextStyle)var1_1, Locale.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public final String getDisplayName(TextStyle style, Locale locale) {
        void var2_2;
        void var1_1;
        return this.toJdkMonth().getDisplayName((TextStyle)var1_1, (Locale)var2_2);
    }

    static {
        ALIASES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        ENUMS = Month.values();
    }
}

