/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.date.TemporalUtil;
import cn.hutool.core.date.Week;
import cn.hutool.core.date.format.GlobalCustomFormat;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.TimeZone;

public class LocalDateTimeUtil {
    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime of(Instant instant) {
        return LocalDateTimeUtil.of(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime ofUTC(Instant instant) {
        return LocalDateTimeUtil.of(instant, ZoneId.of("UTC"));
    }

    public static LocalDateTime of(ZonedDateTime zonedDateTime) {
        ZonedDateTime zonedDateTime2;
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime2.toLocalDateTime();
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime of(Instant instant, ZoneId zoneId) {
        void var1_1;
        Instant instant2;
        if (instant == null) {
            return null;
        }
        return LocalDateTime.ofInstant(instant2, ObjectUtil.defaultIfNull(var1_1, ZoneId::systemDefault));
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime of(Instant instant, TimeZone timeZone) {
        void var1_1;
        Instant instant2;
        if (instant == null) {
            return null;
        }
        return LocalDateTimeUtil.of(instant2, ObjectUtil.defaultIfNull(var1_1, TimeZone::getDefault).toZoneId());
    }

    public static LocalDateTime of(long epochMilli) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime ofUTC(long epochMilli) {
        return LocalDateTimeUtil.ofUTC(Instant.ofEpochMilli(epochMilli));
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime of(long epochMilli, ZoneId zoneId) {
        void var2_1;
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli), (ZoneId)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime of(long epochMilli, TimeZone timeZone) {
        void var2_1;
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli), (TimeZone)var2_1);
    }

    public static LocalDateTime of(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            return LocalDateTimeUtil.of(date.toInstant(), ((DateTime)date).getZoneId());
        }
        return LocalDateTimeUtil.of(date2.toInstant());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        if (temporalAccessor instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporalAccessor, ZoneId.systemDefault());
        }
        try {
            return LocalDateTime.from(temporalAccessor);
        }
        catch (Exception exception) {
            try {
                return ZonedDateTime.from(temporalAccessor).toLocalDateTime();
            }
            catch (Exception exception2) {
                try {
                    return LocalDateTime.ofInstant(Instant.from(temporalAccessor), ZoneId.systemDefault());
                }
                catch (Exception exception3) {
                    TemporalAccessor temporalAccessor2;
                    return LocalDateTime.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtil.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtil.get(temporalAccessor2, ChronoField.NANO_OF_SECOND));
                }
            }
        }
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        TemporalAccessor temporalAccessor2;
        if (temporalAccessor == null) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        if (temporalAccessor instanceof Instant) {
            return LocalDateTimeUtil.of(temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor2, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDateTime parse(CharSequence text) {
        return LocalDateTimeUtil.parse(text, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        CharSequence charSequence;
        void var1_1;
        if (StrUtil.isBlank(text)) {
            return null;
        }
        if (formatter == null) {
            return LocalDateTime.parse(text);
        }
        return LocalDateTimeUtil.of(var1_1.parse(charSequence));
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime parse(CharSequence text, String format) {
        void var2_2;
        CharSequence charSequence;
        if (StrUtil.isBlank(text)) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return LocalDateTimeUtil.of(GlobalCustomFormat.parse(text, format));
        }
        DateTimeFormatter formatter = null;
        if (StrUtil.isNotBlank(format)) {
            void var1_1;
            if (StrUtil.startWithIgnoreEquals(format, "yyyyMMddHHmmss")) {
                String fraction = StrUtil.removePrefix(format, "yyyyMMddHHmmss");
                if (ReUtil.isMatch("[S]{1,2}", (CharSequence)fraction)) {
                    text = text + StrUtil.repeat('0', 3 - var1_1.length());
                }
                formatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
            } else {
                formatter = DateTimeFormatter.ofPattern((String)var1_1);
            }
        }
        return LocalDateTimeUtil.parse(charSequence, (DateTimeFormatter)var2_2);
    }

    public static LocalDate parseDate(CharSequence text) {
        return LocalDateTimeUtil.parseDate(text, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDate parseDate(CharSequence text, DateTimeFormatter formatter) {
        CharSequence charSequence;
        void var1_1;
        if (StrUtil.isBlank(text)) {
            return null;
        }
        if (formatter == null) {
            return LocalDate.parse(text);
        }
        return LocalDateTimeUtil.ofDate(var1_1.parse(charSequence));
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDate parseDate(CharSequence text, String format) {
        void var1_1;
        CharSequence charSequence;
        if (text == null) {
            return null;
        }
        return LocalDateTimeUtil.parseDate(charSequence, DateTimeFormatter.ofPattern((String)var1_1));
    }

    public static String formatNormal(LocalDateTime time) {
        return LocalDateTimeUtil.format(time, DatePattern.NORM_DATETIME_FORMATTER);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(LocalDateTime time, DateTimeFormatter formatter) {
        void var1_1;
        return TemporalAccessorUtil.format((TemporalAccessor)time, (DateTimeFormatter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(LocalDateTime time, String format) {
        void var1_1;
        return TemporalAccessorUtil.format((TemporalAccessor)time, (String)var1_1);
    }

    public static String formatNormal(LocalDate date) {
        return LocalDateTimeUtil.format(date, DatePattern.NORM_DATE_FORMATTER);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(LocalDate date, DateTimeFormatter formatter) {
        void var1_1;
        return TemporalAccessorUtil.format((TemporalAccessor)date, (DateTimeFormatter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(LocalDate date, String format) {
        void var1_1;
        LocalDate localDate;
        if (date == null) {
            return null;
        }
        return LocalDateTimeUtil.format(localDate, DateTimeFormatter.ofPattern((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime offset(LocalDateTime time, long number, TemporalUnit field) {
        void var3_2;
        void var1_1;
        return TemporalUtil.offset(time, (long)var1_1, (TemporalUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        void var1_1;
        return TemporalUtil.between(startTimeInclude, (Temporal)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude, ChronoUnit unit) {
        void var2_2;
        void var1_1;
        return TemporalUtil.between(startTimeInclude, (Temporal)var1_1, (ChronoUnit)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Period betweenPeriod(LocalDate startTimeInclude, LocalDate endTimeExclude) {
        void var1_1;
        return Period.between(startTimeInclude, (LocalDate)var1_1);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        return LocalDateTimeUtil.endOfDay(time, false);
    }

    public static LocalDateTime endOfDay(LocalDateTime time, boolean truncateMillisecond) {
        LocalDateTime localDateTime;
        if (truncateMillisecond) {
            return time.with(LocalTime.of(23, 59, 59));
        }
        return localDateTime.with(LocalTime.MAX);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toEpochMilli(temporalAccessor);
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.isWeekend(localDateTime.toLocalDate());
    }

    public static boolean isWeekend(LocalDate localDate) {
        TemporalAccessor temporalAccessor;
        TemporalAccessor dayOfWeek = localDate.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == temporalAccessor;
    }

    public static Week dayOfWeek(LocalDate localDate) {
        return Week.of(localDate.getDayOfWeek());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isOverlap(ChronoLocalDateTime<?> realStartTime, ChronoLocalDateTime<?> realEndTime, ChronoLocalDateTime<?> startTime, ChronoLocalDateTime<?> endTime) {
        void var1_1;
        void var2_2;
        void var3_3;
        return realStartTime.compareTo((ChronoLocalDateTime<?>)var3_3) <= 0 && var2_2.compareTo((ChronoLocalDateTime<?>)var1_1) <= 0;
    }

    public static int weekOfYear(TemporalAccessor date) {
        return TemporalAccessorUtil.get(date, WeekFields.ISO.weekOfYear());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        void var1_1;
        LocalDateTime localDateTime;
        return date1 != null && date2 != null && LocalDateTimeUtil.isSameDay(localDateTime.toLocalDate(), var1_1.toLocalDate());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameDay(LocalDate date1, LocalDate date2) {
        void var1_1;
        LocalDate localDate;
        return date1 != null && date2 != null && localDate.isEqual((ChronoLocalDate)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIn(ChronoLocalDateTime<?> date, ChronoLocalDateTime<?> beginDate, ChronoLocalDateTime<?> endDate) {
        void var2_2;
        void var1_1;
        return TemporalAccessorUtil.isIn(date, (TemporalAccessor)var1_1, (TemporalAccessor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIn(ChronoLocalDateTime<?> date, ChronoLocalDateTime<?> beginDate, ChronoLocalDateTime<?> endDate, boolean includeBegin, boolean includeEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TemporalAccessorUtil.isIn(date, (TemporalAccessor)var1_1, (TemporalAccessor)var2_2, (boolean)var3_3, includeEnd);
    }
}

