/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.Map;

public class GroupTimeInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isNano;
    protected final Map<String, Long> groupMap;

    /*
     * WARNING - void declaration
     */
    public GroupTimeInterval(boolean isNano) {
        void var1_1;
        this.isNano = var1_1;
        this.groupMap = new SafeConcurrentHashMap<String, Long>();
    }

    public GroupTimeInterval clear() {
        this.groupMap.clear();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public long start(String id) {
        void var2_2;
        void var1_1;
        long time = this.getTime();
        this.groupMap.put((String)var1_1, time);
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long intervalRestart(String id) {
        void var2_2;
        void var1_1;
        long now = this.getTime();
        return now - ObjectUtil.defaultIfNull(this.groupMap.put((String)var1_1, now), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public long interval(String id) {
        void var1_1;
        Long lastTime = this.groupMap.get(id);
        if (lastTime == null) {
            return 0L;
        }
        return this.getTime() - var1_1.longValue();
    }

    /*
     * WARNING - void declaration
     */
    public long interval(String id, DateUnit dateUnit) {
        void var2_2;
        void var3_3;
        void var1_1;
        long intervalMs;
        long l = intervalMs = this.isNano ? this.interval(id) / 1000000L : this.interval((String)var1_1);
        if (DateUnit.MS == dateUnit) {
            return intervalMs;
        }
        return (long)(var3_3 / var2_2.getMillis());
    }

    /*
     * WARNING - void declaration
     */
    public long intervalMs(String id) {
        void var1_1;
        return this.interval((String)var1_1, DateUnit.MS);
    }

    /*
     * WARNING - void declaration
     */
    public long intervalSecond(String id) {
        void var1_1;
        return this.interval((String)var1_1, DateUnit.SECOND);
    }

    /*
     * WARNING - void declaration
     */
    public long intervalMinute(String id) {
        void var1_1;
        return this.interval((String)var1_1, DateUnit.MINUTE);
    }

    /*
     * WARNING - void declaration
     */
    public long intervalHour(String id) {
        void var1_1;
        return this.interval((String)var1_1, DateUnit.HOUR);
    }

    /*
     * WARNING - void declaration
     */
    public long intervalDay(String id) {
        void var1_1;
        return this.interval((String)var1_1, DateUnit.DAY);
    }

    /*
     * WARNING - void declaration
     */
    public long intervalWeek(String id) {
        void var1_1;
        return this.interval((String)var1_1, DateUnit.WEEK);
    }

    /*
     * WARNING - void declaration
     */
    public String intervalPretty(String id) {
        void var1_1;
        return DateUtil.formatBetween(this.intervalMs((String)var1_1));
    }

    private long getTime() {
        if (this.isNano) {
            return System.nanoTime();
        }
        return System.currentTimeMillis();
    }
}

