/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.CalendarUtil;
import cn.hutool.core.date.DateBetween;
import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateRange;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.date.Month;
import cn.hutool.core.date.Quarter;
import cn.hutool.core.date.StopWatch;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.date.Week;
import cn.hutool.core.date.Zodiac;
import cn.hutool.core.date.ZoneUtil;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.date.format.GlobalCustomFormat;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DateUtil
extends CalendarUtil {
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime dateSecond() {
        return DateUtil.beginOfSecond(DateUtil.date());
    }

    public static DateTime date(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtil.dateNew(date2);
    }

    public static DateTime dateNew(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        return new DateTime(date2);
    }

    public static DateTime date(long date) {
        long l;
        return new DateTime(l);
    }

    public static DateTime date(Calendar calendar) {
        Calendar calendar2;
        if (calendar == null) {
            return null;
        }
        return new DateTime(calendar2);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        TemporalAccessor temporalAccessor2;
        if (temporalAccessor == null) {
            return null;
        }
        return new DateTime(temporalAccessor2);
    }

    public static long current() {
        return System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfYear(Date date) {
        return DateTime.of(date).dayOfYear();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Week dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static boolean isWeekend(Date date) {
        Object object;
        Object week = DateUtil.dayOfWeekEnum(date);
        return Week.SATURDAY == week || Week.SUNDAY == object;
    }

    /*
     * WARNING - void declaration
     */
    public static int hour(Date date, boolean is24HourClock) {
        void var1_1;
        return DateTime.of(date).hour((boolean)var1_1);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millisecond(Date date) {
        return DateTime.of(date).millisecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.date());
    }

    public static Month thisMonthEnum() {
        return DateUtil.monthEnum(DateUtil.date());
    }

    public static int thisWeekOfYear() {
        return DateUtil.weekOfYear(DateUtil.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtil.weekOfMonth(DateUtil.date());
    }

    public static int thisDayOfMonth() {
        return DateUtil.dayOfMonth(DateUtil.date());
    }

    public static int thisDayOfWeek() {
        return DateUtil.dayOfWeek(DateUtil.date());
    }

    public static Week thisDayOfWeekEnum() {
        return DateUtil.dayOfWeekEnum(DateUtil.date());
    }

    public static int thisHour(boolean is24HourClock) {
        boolean bl;
        return DateUtil.hour(DateUtil.date(), bl);
    }

    public static int thisMinute() {
        return DateUtil.minute(DateUtil.date());
    }

    public static int thisSecond() {
        return DateUtil.second(DateUtil.date());
    }

    public static int thisMillisecond() {
        return DateUtil.millisecond(DateUtil.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtil.yearAndQuarter(DateUtil.calendar(date));
    }

    /*
     * WARNING - void declaration
     */
    public static LinkedHashSet<String> yearAndQuarter(Date startDate, Date endDate) {
        void var1_1;
        Date date;
        if (startDate == null || endDate == null) {
            return new LinkedHashSet<String>(0);
        }
        return DateUtil.yearAndQuarter(date.getTime(), var1_1.getTime());
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.formatNormal(localDateTime);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(LocalDateTime localDateTime, String format) {
        void var1_1;
        return LocalDateTimeUtil.format(localDateTime, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(Date date, String format) {
        void var2_2;
        void var1_1;
        Date date2;
        if (date == null || StrUtil.isBlank(format)) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return GlobalCustomFormat.format(date, (CharSequence)format);
        }
        TimeZone timeZone = null;
        if (date instanceof DateTime) {
            timeZone = ((DateTime)date).getTimeZone();
        }
        return DateUtil.format(date2, DateUtil.newSimpleFormat((String)var1_1, null, (TimeZone)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String format(Date date, DatePrinter format) {
        Date date2;
        void var1_1;
        if (format == null || date == null) {
            return null;
        }
        return var1_1.format(date2);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(Date date, DateFormat format) {
        Date date2;
        void var1_1;
        if (format == null || date == null) {
            return null;
        }
        return var1_1.format(date2);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(Date date, DateTimeFormatter format) {
        void var1_1;
        Date date2;
        if (format == null || date == null) {
            return null;
        }
        return TemporalAccessorUtil.format((TemporalAccessor)date2.toInstant(), (DateTimeFormatter)var1_1);
    }

    public static String formatDateTime(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date2);
    }

    public static String formatDate(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date2);
    }

    public static String formatTime(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        return DatePattern.NORM_TIME_FORMAT.format(date2);
    }

    public static String formatHttpDate(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        return DatePattern.HTTP_DATETIME_FORMAT.format(date2);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatChineseDate(Date date, boolean isUppercase, boolean withTime) {
        void var2_2;
        Date date2;
        void var1_1;
        if (date == null) {
            return null;
        }
        if (var1_1 == false) {
            return (withTime ? DatePattern.CHINESE_DATE_TIME_FORMAT : DatePattern.CHINESE_DATE_FORMAT).format(date);
        }
        return CalendarUtil.formatChineseDate(CalendarUtil.calendar(date2), (boolean)var2_2);
    }

    public static LocalDateTime parseLocalDateTime(CharSequence dateStr) {
        return DateUtil.parseLocalDateTime(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime parseLocalDateTime(CharSequence dateStr, String format) {
        void var1_1;
        return LocalDateTimeUtil.parse(dateStr, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        void var1_1;
        CharSequence charSequence;
        return new DateTime(charSequence, (DateFormat)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(CharSequence dateStr, DateParser parser) {
        void var1_1;
        CharSequence charSequence;
        return new DateTime(charSequence, (DateParser)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(CharSequence dateStr, DateParser parser, boolean lenient) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        return new DateTime(charSequence, (DateParser)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(CharSequence dateStr, DateTimeFormatter formatter) {
        void var1_1;
        CharSequence charSequence;
        return new DateTime(charSequence, (DateTimeFormatter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(CharSequence dateStr, String format) {
        void var1_1;
        CharSequence charSequence;
        return new DateTime(charSequence, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return new DateTime(GlobalCustomFormat.parse(dateStr, format));
        }
        return new DateTime(charSequence, DateUtil.newSimpleFormat((String)var1_1, (Locale)var2_2, null));
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(String str, String ... parsePatterns) throws DateException {
        void var1_1;
        String string;
        return new DateTime(CalendarUtil.parseByPatterns(string, (String[])var1_1));
    }

    public static DateTime parseDateTime(CharSequence dateString) {
        CharSequence charSequence = DateUtil.normalize(dateString);
        return DateUtil.parse(charSequence, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseDate(CharSequence dateString) {
        CharSequence charSequence = DateUtil.normalize(dateString);
        return DateUtil.parse(charSequence, DatePattern.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(CharSequence timeString) {
        CharSequence charSequence = DateUtil.normalize(timeString);
        return DateUtil.parse(charSequence, DatePattern.NORM_TIME_FORMAT);
    }

    public static DateTime parseTimeToday(CharSequence timeString) {
        CharSequence charSequence;
        timeString = StrUtil.replaceChars(timeString, "\u65f6\u5206\u79d2", (CharSequence)":");
        timeString = StrUtil.format("{} {}", DateUtil.today(), timeString);
        if (1 == StrUtil.count(timeString, ':')) {
            return DateUtil.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return DateUtil.parse(charSequence, DatePattern.NORM_DATETIME_FORMAT);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parseUTC(String utcString) {
        String string;
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (StrUtil.contains((CharSequence)utcString, 'Z')) {
            if (length == 24 - 4) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_FORMAT);
            }
            int patternLength = 28;
            if (length <= patternLength && length >= patternLength - 6) {
                return DateUtil.parse((CharSequence)utcString, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            void var1_1;
            if (StrUtil.contains((CharSequence)utcString, '+')) {
                String zoneOffset = StrUtil.subAfter((CharSequence)(utcString = utcString.replace(" +", "+")), '+', true);
                if (StrUtil.isBlank(zoneOffset)) {
                    throw new DateException("Invalid format: [{}]", utcString);
                }
                if (!StrUtil.contains((CharSequence)zoneOffset, ':')) {
                    void var2_3;
                    String pre = StrUtil.subBefore((CharSequence)utcString, '+', true);
                    string = string + "+" + var2_3.substring(0, 2) + ":00";
                }
                if (StrUtil.contains((CharSequence)string, '.')) {
                    string = DateUtil.normalizeMillSeconds(string, ".", "+");
                    return DateUtil.parse((CharSequence)string, DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_WITH_XXX_OFFSET_FORMAT);
            }
            if (ReUtil.contains("-\\d{2}:?00", (CharSequence)string)) {
                String string2 = string = string.replace(" -", "-");
                if (':' != string2.charAt(string2.length() - 3)) {
                    string = string.substring(0, string.length() - 2) + ":00";
                }
                if (StrUtil.contains((CharSequence)string, '.')) {
                    string = DateUtil.normalizeMillSeconds(string, ".", "-");
                    return new DateTime((CharSequence)string, DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)string, DatePattern.UTC_WITH_XXX_OFFSET_FORMAT);
            }
            if (length == 21 - 2) {
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (var1_1 == 21 - 5) {
                return DateUtil.parse((CharSequence)(string + ":00"), DatePattern.UTC_SIMPLE_FORMAT);
            }
            if (StrUtil.contains((CharSequence)string, '.')) {
                string = DateUtil.normalizeMillSeconds(string, ".", null);
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_SIMPLE_MS_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", string);
    }

    @Deprecated
    public static DateTime parseCST(CharSequence cstString) {
        return DateUtil.parseRFC2822(cstString);
    }

    public static DateTime parseRFC2822(CharSequence source) {
        CharSequence charSequence;
        if (source == null) {
            return null;
        }
        if (StrUtil.contains(source, ',')) {
            if (StrUtil.contains(source, "\u661f\u671f")) {
                return DateUtil.parse(source, FastDateFormat.getInstance("EEE, dd MMM yyyy HH:mm:ss z", Locale.CHINA));
            }
            return DateUtil.parse(source, DatePattern.HTTP_DATETIME_FORMAT_Z);
        }
        if (StrUtil.contains(source, "\u661f\u671f")) {
            return DateUtil.parse(source, FastDateFormat.getInstance("EEE MMM dd HH:mm:ss zzz yyyy", Locale.CHINA));
        }
        return DateUtil.parse(charSequence, DatePattern.JDK_DATETIME_FORMAT);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime parse(CharSequence dateCharSequence) {
        CharSequence charSequence;
        if (StrUtil.isBlank(dateCharSequence)) {
            return null;
        }
        dateCharSequence = dateCharSequence.toString();
        CharSequence dateStr = StrUtil.removeAll((CharSequence)((String)dateCharSequence).trim(), '\u65e5', '\u79d2');
        int length = ((String)dateStr).length();
        if (NumberUtil.isNumber(dateStr)) {
            if (length == 14) {
                return DateUtil.parse(dateStr, DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == 17) {
                return DateUtil.parse(dateStr, DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == 8) {
                return DateUtil.parse(dateStr, DatePattern.PURE_DATE_FORMAT);
            }
            if (length == 6) {
                return DateUtil.parse(dateStr, DatePattern.PURE_TIME_FORMAT);
            }
            if (length == 13) {
                return DateUtil.date(NumberUtil.parseLong((String)dateStr));
            }
        } else {
            if (ReUtil.isMatch(PatternPool.TIME, dateStr)) {
                return DateUtil.parseTimeToday(dateStr);
            }
            if (StrUtil.containsAnyIgnoreCase(dateStr, wtb)) {
                return DateUtil.parseRFC2822(dateStr);
            }
            if (StrUtil.contains(dateStr, 'T')) {
                return DateUtil.parseUTC((String)dateStr);
            }
        }
        if (ReUtil.isMatch(DatePattern.REGEX_NORM, dateStr = DateUtil.normalize(dateStr))) {
            length = StrUtil.count(dateStr, ':');
            switch (length) {
                case 0: {
                    return DateUtil.parse(dateStr, DatePattern.NORM_DATE_FORMAT);
                }
                case 1: {
                    return DateUtil.parse(dateStr, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    int indexOfDot = StrUtil.indexOf(dateStr, '.');
                    if (indexOfDot > 0) {
                        int n = ((String)dateStr).length();
                        if (n - indexOfDot > 4) {
                            void var1_1;
                            dateStr = StrUtil.subPre(dateStr, (int)(var1_1 + 4));
                        }
                        return DateUtil.parse(dateStr, DatePattern.NORM_DATETIME_MS_FORMAT);
                    }
                    return DateUtil.parse(dateStr, DatePattern.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new DateException("No format fit for date String [{}] !", charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime truncate(Date date, DateField dateField) {
        void var1_1;
        Date date2;
        return new DateTime(DateUtil.truncate(DateUtil.calendar(date2), (DateField)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime round(Date date, DateField dateField) {
        void var1_1;
        Date date2;
        return new DateTime(DateUtil.round(DateUtil.calendar(date2), (DateField)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime ceiling(Date date, DateField dateField) {
        void var1_1;
        Date date2;
        return new DateTime(DateUtil.ceiling(DateUtil.calendar(date2), (DateField)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime ceiling(Date date, DateField dateField, boolean truncateMillisecond) {
        void var2_2;
        void var1_1;
        Date date2;
        return new DateTime(DateUtil.ceiling(DateUtil.calendar(date2), (DateField)var1_1, (boolean)var2_2));
    }

    public static DateTime beginOfSecond(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfSecond(DateUtil.calendar(date2)));
    }

    public static DateTime endOfSecond(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfSecond(DateUtil.calendar(date2)));
    }

    public static DateTime beginOfHour(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfHour(DateUtil.calendar(date2)));
    }

    public static DateTime endOfHour(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfHour(DateUtil.calendar(date2)));
    }

    public static DateTime beginOfMinute(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfMinute(DateUtil.calendar(date2)));
    }

    public static DateTime endOfMinute(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfMinute(DateUtil.calendar(date2)));
    }

    public static DateTime beginOfDay(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date2)));
    }

    public static DateTime endOfDay(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date2)));
    }

    public static DateTime beginOfWeek(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date2)));
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime beginOfWeek(Date date, boolean isMondayAsFirstDay) {
        void var1_1;
        Date date2;
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date2), (boolean)var1_1));
    }

    public static DateTime endOfWeek(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date2)));
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime endOfWeek(Date date, boolean isSundayAsLastDay) {
        void var1_1;
        Date date2;
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date2), (boolean)var1_1));
    }

    public static DateTime beginOfMonth(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfMonth(DateUtil.calendar(date2)));
    }

    public static DateTime endOfMonth(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfMonth(DateUtil.calendar(date2)));
    }

    public static DateTime beginOfQuarter(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfQuarter(DateUtil.calendar(date2)));
    }

    public static DateTime endOfQuarter(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfQuarter(DateUtil.calendar(date2)));
    }

    public static DateTime beginOfYear(Date date) {
        Date date2;
        return new DateTime(DateUtil.beginOfYear(DateUtil.calendar(date2)));
    }

    public static DateTime endOfYear(Date date) {
        Date date2;
        return new DateTime(DateUtil.endOfYear(DateUtil.calendar(date2)));
    }

    public static DateTime yesterday() {
        return DateUtil.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtil.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtil.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtil.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtil.offsetMonth(new DateTime(), 1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offsetMillisecond(Date date, int offset) {
        void var1_1;
        return DateUtil.offset(date, DateField.MILLISECOND, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offsetSecond(Date date, int offset) {
        void var1_1;
        return DateUtil.offset(date, DateField.SECOND, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offsetMinute(Date date, int offset) {
        void var1_1;
        return DateUtil.offset(date, DateField.MINUTE, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offsetHour(Date date, int offset) {
        void var1_1;
        return DateUtil.offset(date, DateField.HOUR_OF_DAY, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offsetDay(Date date, int offset) {
        void var1_1;
        return DateUtil.offset(date, DateField.DAY_OF_YEAR, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offsetWeek(Date date, int offset) {
        void var1_1;
        return DateUtil.offset(date, DateField.WEEK_OF_YEAR, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offsetMonth(Date date, int offset) {
        void var1_1;
        return DateUtil.offset(date, DateField.MONTH, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime offset(Date date, DateField dateField, int offset) {
        void var2_2;
        void var1_1;
        return DateUtil.dateNew(date).offset((DateField)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        void var2_2;
        void var1_1;
        return DateUtil.between(beginDate, (Date)var1_1, (DateUnit)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        void var2_2;
        void var3_3;
        void var1_1;
        Date date;
        return new DateBetween(date, (Date)var1_1, (boolean)var3_3).between((DateUnit)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long betweenMs(Date beginDate, Date endDate) {
        void var1_1;
        Date date;
        return new DateBetween(date, (Date)var1_1).between(DateUnit.MS);
    }

    /*
     * WARNING - void declaration
     */
    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        void var1_1;
        Date date;
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(date, (Date)var1_1, DateUnit.DAY);
    }

    /*
     * WARNING - void declaration
     */
    public static long betweenWeek(Date beginDate, Date endDate, boolean isReset) {
        void var1_1;
        Date date;
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(date, (Date)var1_1, DateUnit.WEEK);
    }

    /*
     * WARNING - void declaration
     */
    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        void var2_2;
        void var1_1;
        Date date;
        return new DateBetween(date, (Date)var1_1).betweenMonth((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        void var2_2;
        void var1_1;
        Date date;
        return new DateBetween(date, (Date)var1_1).betweenYear((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatBetween(Date beginDate, Date endDate, BetweenFormatter.Level level) {
        void var2_2;
        void var1_1;
        return DateUtil.formatBetween(DateUtil.between(beginDate, (Date)var1_1, DateUnit.MS), (BetweenFormatter.Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatBetween(Date beginDate, Date endDate) {
        void var1_1;
        return DateUtil.formatBetween(DateUtil.between(beginDate, (Date)var1_1, DateUnit.MS));
    }

    /*
     * WARNING - void declaration
     */
    public static String formatBetween(long betweenMs, BetweenFormatter.Level level) {
        void var2_1;
        long l;
        return new BetweenFormatter(l, (BetweenFormatter.Level)var2_1).format();
    }

    public static String formatBetween(long betweenMs) {
        long l;
        return new BetweenFormatter(l, BetweenFormatter.Level.MILLISECOND).format();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        void var2_2;
        void var1_1;
        Date date2;
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date2).isIn((Date)var1_1, (Date)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameTime(Date date1, Date date2) {
        void var1_1;
        return date1.compareTo((Date)var1_1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameDay(Date date1, Date date2) {
        void var1_1;
        Date date;
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameDay(DateUtil.calendar(date), DateUtil.calendar((Date)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameWeek(Date date1, Date date2, boolean isMon) {
        void var2_2;
        void var1_1;
        Date date;
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameWeek(DateUtil.calendar(date), DateUtil.calendar((Date)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameMonth(Date date1, Date date2) {
        void var1_1;
        Date date;
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameMonth(DateUtil.calendar(date), DateUtil.calendar((Date)var1_1));
    }

    public static long spendNt(long preTime) {
        long l;
        return System.nanoTime() - l;
    }

    public static long spendMs(long preTime) {
        long l;
        return System.currentTimeMillis() - l;
    }

    @Deprecated
    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static TimeInterval timer(boolean isNano) {
        boolean bl;
        return new TimeInterval(bl);
    }

    public static StopWatch createStopWatch() {
        return new StopWatch();
    }

    public static StopWatch createStopWatch(String id) {
        String string;
        return new StopWatch(string);
    }

    public static int ageOfNow(String birthDay) {
        return DateUtil.ageOfNow(DateUtil.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtil.age(birthDay, DateUtil.date());
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    /*
     * WARNING - void declaration
     */
    public static int age(Date birthday, Date dateToCompare) {
        void var1_1;
        Date date;
        Assert.notNull(birthday, "Birthday can not be null !", new Object[0]);
        if (dateToCompare == null) {
            dateToCompare = DateUtil.date();
        }
        return DateUtil.age(date.getTime(), var1_1.getTime());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean isExpired(Date startDate, DateField dateField, int timeLength, Date endDate) {
        void var3_3;
        void var2_2;
        void var1_1;
        Date date = DateUtil.offset(startDate, (DateField)var1_1, (int)var2_2);
        return date.after((Date)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean isExpired(Date startDate, Date endDate, Date checkDate) {
        void var1_1;
        Date date;
        void var2_2;
        return DateUtil.betweenMs(startDate, (Date)var2_2) > DateUtil.betweenMs(date, (Date)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int timeToSecond(String timeStr) {
        void var2_2;
        if (StrUtil.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = StrUtil.splitTrim((CharSequence)timeStr, ':', 3);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt((String)hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String secondToTime(int seconds) {
        void var3_3;
        int n;
        void var2_2;
        void var1_1;
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append((int)var1_1);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append((int)var2_2);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(n);
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static DateRange range(Date start, Date end, DateField unit) {
        void var2_2;
        void var1_1;
        Date date;
        return new DateRange(date, (Date)var1_1, (DateField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<DateTime> rangeContains(DateRange start, DateRange end) {
        void var1_1;
        Iterable<DateTime> iterable;
        Iterable<DateTime> startDateTimes = CollUtil.newArrayList(start);
        ArrayList<DateTime> endDateTimes = CollUtil.newArrayList(end);
        return iterable.stream().filter(((List)var1_1)::contains).collect(Collectors.toList());
    }

    public static List<DateTime> rangeNotContains(DateRange start, DateRange end) {
        Iterable<DateTime> iterable;
        ArrayList arrayList;
        Iterable<DateTime> startDateTimes = CollUtil.newArrayList(start);
        arrayList = CollUtil.newArrayList(arrayList);
        return arrayList.stream().filter(arg_0 -> DateUtil.lambda$rangeNotContains$0((List)iterable, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> rangeFunc(Date start, Date end, DateField unit, Function<Date, T> func) {
        void var2_2;
        Object object;
        if (start == null || end == null || start.after(end)) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (DateTime date : DateUtil.range((Date)object, end, (DateField)var2_2)) {
            void var1_1;
            list.add(func.apply((Date)var1_1));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static void rangeConsume(Date start, Date end, DateField unit, Consumer<Date> consumer) {
        void var3_3;
        void var2_2;
        void var1_1;
        Date date;
        if (start == null || end == null || start.after(end)) {
            return;
        }
        DateUtil.range(date, (Date)var1_1, (DateField)var2_2).forEach(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static List<DateTime> rangeToList(Date start, Date end, DateField unit) {
        void var2_2;
        void var1_1;
        return CollUtil.newArrayList(DateUtil.range(start, (Date)var1_1, (DateField)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static List<DateTime> rangeToList(Date start, Date end, DateField unit, int step) {
        void var3_3;
        void var2_2;
        void var1_1;
        Date date;
        return CollUtil.newArrayList(new DateRange(date, (Date)var1_1, (DateField)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static String getZodiac(int month, int day) {
        void var1_1;
        return Zodiac.getZodiac(month, (int)var1_1);
    }

    public static String getChineseZodiac(int year) {
        return Zodiac.getChineseZodiac(year);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(Date date1, Date date2) {
        void var1_1;
        return CompareUtil.compare(date1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(Date date1, Date date2, String format) {
        void var1_1;
        Date date;
        if (format != null) {
            if (date1 != null) {
                date1 = DateUtil.parse((CharSequence)DateUtil.format(date1, format), format);
            }
            if (date2 != null) {
                void var2_2;
                date2 = DateUtil.parse((CharSequence)DateUtil.format(date2, format), (String)var2_2);
            }
        }
        return CompareUtil.compare(date, var1_1);
    }

    public static long nanosToMillis(long duration) {
        long l;
        return TimeUnit.NANOSECONDS.toMillis(l);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(Date date) {
        Date date2;
        if (date == null) {
            return null;
        }
        return date2.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTimeUtil.of(instant);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTimeUtil.of(date);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime convertTimeZone(Date date, ZoneId zoneId) {
        void var1_1;
        Date date2;
        return new DateTime(date2, ZoneUtil.toTimeZone((ZoneId)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime convertTimeZone(Date date, TimeZone timeZone) {
        void var1_1;
        Date date2;
        return new DateTime(date2, (TimeZone)var1_1);
    }

    public static int lengthOfYear(int year) {
        return Year.of(year).length();
    }

    /*
     * WARNING - void declaration
     */
    public static int lengthOfMonth(int month, boolean isLeapYear) {
        void var1_1;
        return java.time.Month.of(month).length((boolean)var1_1);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return DateUtil.newSimpleFormat(pattern, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat;
        void var1_1;
        if (locale == null) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, (Locale)var1_1);
        if (timeZone != null) {
            void var2_2;
            format.setTimeZone((TimeZone)var2_2);
        }
        format.setLenient(false);
        return simpleDateFormat;
    }

    public static String getShotName(TimeUnit unit) {
        TimeUnit timeUnit;
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return timeUnit.name().toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isOverlap(Date realStartTime, Date realEndTime, Date startTime, Date endTime) {
        void var1_1;
        void var2_2;
        void var3_3;
        return realStartTime.compareTo((Date)var3_3) <= 0 && var2_2.compareTo((Date)var1_1) <= 0;
    }

    public static boolean isLastDayOfMonth(Date date) {
        return DateUtil.date(date).isLastDayOfMonth();
    }

    public static int getLastDayOfMonth(Date date) {
        return DateUtil.date(date).getLastDayOfMonth();
    }

    /*
     * WARNING - void declaration
     */
    private static String normalize(CharSequence dateStr) {
        CharSequence charSequence;
        void var2_2;
        if (StrUtil.isBlank(dateStr)) {
            return StrUtil.str(dateStr);
        }
        List<String> dateAndTime = StrUtil.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size <= 0 || size > 2) {
            return StrUtil.str(dateStr);
        }
        CharSequence builder = StrUtil.builder();
        String string = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        String datePart = StrUtil.removeSuffix(string, "\u65e5");
        ((StringBuilder)builder).append(string);
        if (var2_2 == 2) {
            void var1_1;
            ((StringBuilder)builder).append(' ');
            dateAndTime = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            dateAndTime = StrUtil.removeSuffix((CharSequence)((Object)dateAndTime), ":");
            String timePart = ((String)((Object)dateAndTime)).replace(',', '.');
            ((StringBuilder)builder).append((String)var1_1);
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String normalizeMillSeconds(String dateStr, CharSequence before, CharSequence after) {
        void var2_2;
        String string;
        void var3_4;
        void var1_1;
        if (StrUtil.isBlank(after)) {
            String millOrNaco = StrUtil.subPre(StrUtil.subAfter((CharSequence)dateStr, before, true), 3);
            return StrUtil.subBefore((CharSequence)dateStr, before, true) + before + millOrNaco;
        }
        String millOrNaco = StrUtil.subPre(StrUtil.subBetween(dateStr, before, after), 3);
        return StrUtil.subBefore((CharSequence)dateStr, before, true) + var1_1 + (String)var3_4 + after + StrUtil.subAfter((CharSequence)string, (CharSequence)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$rangeNotContains$0(List startDateTimes, DateTime item) {
        void var1_1;
        return !startDateTimes.contains(var1_1);
    }
}

