/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import java.time.temporal.ChronoUnit;

public enum DateUnit {
    MS(1L),
    SECOND(1000L),
    MINUTE(SECOND.getMillis() * 60L),
    HOUR(MINUTE.getMillis() * 60L),
    DAY(HOUR.getMillis() * 24L),
    WEEK(DAY.getMillis() * 7L);

    private final long millis;

    /*
     * WARNING - void declaration
     */
    private DateUnit(long millis) {
        void var3_3;
        this.millis = var3_3;
    }

    public final long getMillis() {
        return this.millis;
    }

    public final ChronoUnit toChronoUnit() {
        return DateUnit.toChronoUnit(this);
    }

    public static DateUnit of(ChronoUnit unit) {
        ChronoUnit chronoUnit;
        switch (chronoUnit) {
            case MICROS: {
                return MS;
            }
            case SECONDS: {
                return SECOND;
            }
            case MINUTES: {
                return MINUTE;
            }
            case HOURS: {
                return HOUR;
            }
            case DAYS: {
                return DAY;
            }
            case WEEKS: {
                return WEEK;
            }
        }
        return null;
    }

    public static ChronoUnit toChronoUnit(DateUnit unit) {
        DateUnit dateUnit;
        switch (dateUnit) {
            case MS: {
                return ChronoUnit.MICROS;
            }
            case SECOND: {
                return ChronoUnit.SECONDS;
            }
            case MINUTE: {
                return ChronoUnit.MINUTES;
            }
            case HOUR: {
                return ChronoUnit.HOURS;
            }
            case DAY: {
                return ChronoUnit.DAYS;
            }
            case WEEK: {
                return ChronoUnit.WEEKS;
            }
        }
        return null;
    }
}

