/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.CalendarUtil;
import cn.hutool.core.date.DateBetween;
import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.date.Month;
import cn.hutool.core.date.Quarter;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.date.Week;
import cn.hutool.core.date.ZoneUtil;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.date.format.GlobalCustomFormat;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.SystemPropsUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime
extends java.util.Date {
    private static final long serialVersionUID = -5395712593979185936L;
    private static boolean useJdkToStringStyle = false;
    private boolean mutable;
    private Week firstDayOfWeek;
    private TimeZone timeZone;
    private int minimalDaysInFirstWeek;

    public static void setUseJdkToStringStyle(boolean customUseJdkToStringStyle) {
        useJdkToStringStyle = customUseJdkToStringStyle;
    }

    public static DateTime of(long timeMillis) {
        long l;
        return new DateTime(l);
    }

    public static DateTime of(java.util.Date date) {
        java.util.Date date2;
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date2);
    }

    public static DateTime of(Calendar calendar) {
        Calendar calendar2;
        return new DateTime(calendar2);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime of(String dateStr, String format) {
        void var1_1;
        String string;
        return new DateTime((CharSequence)string, (String)var1_1);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public DateTime() {
        this(TimeZone.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(TimeZone timeZone) {
        this(System.currentTimeMillis(), (TimeZone)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(java.util.Date date) {
        void var1_1;
        java.util.Date date2 = date;
        this(date2, date2 instanceof DateTime ? ((DateTime)var1_1).timeZone : TimeZone.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(java.util.Date date, TimeZone timeZone) {
        this(ObjectUtil.defaultIfNull(var1_1, new java.util.Date()).getTime(), (TimeZone)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(Calendar calendar) {
        this(calendar.getTime(), calendar.getTimeZone());
        void var1_1;
        this.setFirstDayOfWeek(Week.of(var1_1.getFirstDayOfWeek()));
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(Instant instant) {
        this(var1_1.toEpochMilli());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(Instant instant, ZoneId zoneId) {
        this(var1_1.toEpochMilli(), ZoneUtil.toTimeZone((ZoneId)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(TemporalAccessor temporalAccessor) {
        this(TemporalAccessorUtil.toInstant((TemporalAccessor)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.toInstant(), var1_1.getZone());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(long timeMillis) {
        this((long)var1_1, TimeZone.getDefault());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(long timeMillis, TimeZone timeZone) {
        super((long)var1_1);
        void var3_2;
        void var1_1;
        this.mutable = true;
        this.firstDayOfWeek = Week.MONDAY;
        this.timeZone = ObjectUtil.defaultIfNull(var3_2, TimeZone::getDefault);
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(CharSequence dateStr) {
        this(DateUtil.parse((CharSequence)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(CharSequence dateStr, String format) {
        this(GlobalCustomFormat.isCustomFormat(format) ? GlobalCustomFormat.parse(dateStr, format) : DateTime.parse((CharSequence)var1_1, DateUtil.newSimpleFormat((String)var2_2)));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(CharSequence dateStr, DateFormat dateFormat) {
        this(DateTime.parse((CharSequence)var1_1, dateFormat), var2_2.getTimeZone());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(CharSequence dateStr, DateTimeFormatter formatter) {
        this(TemporalAccessorUtil.toInstant(formatter.parse((CharSequence)var1_1)), var2_2.getZone());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(CharSequence dateStr, DateParser dateParser) {
        this((CharSequence)var1_1, (DateParser)var2_2, SystemPropsUtil.getBoolean(SystemPropsUtil.HUTOOL_DATE_LENIENT, true));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime(CharSequence dateStr, DateParser dateParser, boolean lenient) {
        this(DateTime.parse((CharSequence)var1_1, (DateParser)var2_2, (boolean)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime offset(DateField datePart, int offset) {
        void var3_3;
        void var2_2;
        DateTime dateTime;
        if (DateField.ERA == datePart) {
            throw new IllegalArgumentException("ERA is not support offset!");
        }
        Calendar cal = this.toCalendar();
        cal.add(((DateField)((Object)dateTime)).getValue(), (int)var2_2);
        dateTime = this.mutable ? this : ObjectUtil.clone(this);
        return dateTime.setTimeInternal(var3_3.getTimeInMillis());
    }

    /*
     * WARNING - void declaration
     */
    public DateTime offsetNew(DateField datePart, int offset) {
        void var3_3;
        void var2_2;
        void var1_1;
        Calendar cal = this.toCalendar();
        cal.add(var1_1.getValue(), (int)var2_2);
        return ObjectUtil.clone(this).setTimeInternal(var3_3.getTimeInMillis());
    }

    /*
     * WARNING - void declaration
     */
    public int getField(DateField field) {
        void var1_1;
        return this.getField(var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public int getField(int field) {
        void var1_1;
        return this.toCalendar().get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DateTime setField(DateField field, int value) {
        void var2_2;
        void var1_1;
        return this.setField(var1_1.getValue(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public DateTime setField(int field, int value) {
        void var3_4;
        void var1_2;
        void var2_3;
        Calendar calendar = this.toCalendar();
        calendar.set(field, (int)var2_3);
        DateTime dt = this;
        if (!this.mutable) {
            dt = ObjectUtil.clone(this);
        }
        return super.setTimeInternal(var3_4.getTimeInMillis());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTime(long time) {
        if (this.mutable) {
            void var1_1;
            super.setTime((long)var1_1);
            return;
        }
        throw new DateException("This is not a mutable object !");
    }

    public int year() {
        return this.getField(DateField.YEAR);
    }

    public int quarter() {
        return this.month() / 3 + 1;
    }

    public Quarter quarterEnum() {
        return Quarter.of(this.quarter());
    }

    public int month() {
        return this.getField(DateField.MONTH);
    }

    public int monthBaseOne() {
        return this.month() + 1;
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public Month monthEnum() {
        return Month.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(DateField.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(DateField.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(DateField.DAY_OF_MONTH);
    }

    public int dayOfYear() {
        return this.getField(DateField.DAY_OF_YEAR);
    }

    public int dayOfWeek() {
        return this.getField(DateField.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(DateField.DAY_OF_WEEK_IN_MONTH);
    }

    public Week dayOfWeekEnum() {
        return Week.of(this.dayOfWeek());
    }

    /*
     * WARNING - void declaration
     */
    public int hour(boolean is24HourClock) {
        void var1_1;
        return this.getField(var1_1 != false ? DateField.HOUR_OF_DAY : DateField.HOUR);
    }

    public int minute() {
        return this.getField(DateField.MINUTE);
    }

    public int second() {
        return this.getField(DateField.SECOND);
    }

    public int millisecond() {
        return this.getField(DateField.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(DateField.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(DateField.AM_PM);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isWeekend() {
        void var1_1;
        int dayOfWeek = this.dayOfWeek();
        return 7 == dayOfWeek || true == var1_1;
    }

    public boolean isLeapYear() {
        return DateUtil.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        return this.toCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    /*
     * WARNING - void declaration
     */
    public Calendar toCalendar(Locale locale) {
        void var1_1;
        DateTime dateTime = this;
        return dateTime.toCalendar(dateTime.timeZone, (Locale)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Calendar toCalendar(TimeZone zone) {
        void var1_1;
        return this.toCalendar((TimeZone)var1_1, Locale.getDefault(Locale.Category.FORMAT));
    }

    /*
     * WARNING - void declaration
     */
    public Calendar toCalendar(TimeZone zone, Locale locale) {
        void var1_1;
        void var2_2;
        if (locale == null) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        Calendar cal = zone != null ? Calendar.getInstance(zone, locale) : Calendar.getInstance((Locale)var2_2);
        cal.setFirstDayOfWeek(this.firstDayOfWeek.getValue());
        if (this.minimalDaysInFirstWeek > 0) {
            cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        cal.setTime(this);
        return var1_1;
    }

    public java.util.Date toJdkDate() {
        return new java.util.Date(this.getTime());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Date toSqlDate() {
        return new Date(this.getTime());
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTimeUtil.of(this);
    }

    /*
     * WARNING - void declaration
     */
    public DateBetween between(java.util.Date date) {
        void var1_1;
        return new DateBetween(this, (java.util.Date)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long between(java.util.Date date, DateUnit unit) {
        void var2_2;
        void var1_1;
        return new DateBetween(this, (java.util.Date)var1_1).between((DateUnit)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String between(java.util.Date date, DateUnit unit, BetweenFormatter.Level formatLevel) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DateBetween(this, (java.util.Date)var1_1).toString((DateUnit)var2_2, (BetweenFormatter.Level)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isIn(java.util.Date beginDate, java.util.Date endDate) {
        void var3_3;
        void var2_2;
        long beginMills = beginDate.getTime();
        long endMills = var2_2.getTime();
        long thisMills = this.getTime();
        return thisMills >= Math.min(beginMills, endMills) && thisMills <= Math.max((long)var3_3, endMills);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isBefore(java.util.Date date) {
        void var1_1;
        if (date == null) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo((java.util.Date)var1_1) < 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isBeforeOrEquals(java.util.Date date) {
        void var1_1;
        if (date == null) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo((java.util.Date)var1_1) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAfter(java.util.Date date) {
        void var1_1;
        if (date == null) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo((java.util.Date)var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAfterOrEquals(java.util.Date date) {
        void var1_1;
        if (date == null) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo((java.util.Date)var1_1) >= 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime setMutable(boolean mutable) {
        void var1_1;
        this.mutable = var1_1;
        return this;
    }

    public Week getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime setFirstDayOfWeek(Week firstDayOfWeek) {
        void var1_1;
        this.firstDayOfWeek = var1_1;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ZoneId getZoneId() {
        return this.timeZone.toZoneId();
    }

    /*
     * WARNING - void declaration
     */
    public DateTime setTimeZone(TimeZone timeZone) {
        void var1_1;
        this.timeZone = ObjectUtil.defaultIfNull(var1_1, TimeZone::getDefault);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DateTime setMinimalDaysInFirstWeek(int minimalDaysInFirstWeek) {
        void var1_1;
        this.minimalDaysInFirstWeek = var1_1;
        return this;
    }

    public boolean isLastDayOfMonth() {
        return this.dayOfMonth() == this.getLastDayOfMonth();
    }

    public int getLastDayOfMonth() {
        return this.monthEnum().getLastDay(this.isLeapYear());
    }

    @Override
    public String toString() {
        if (useJdkToStringStyle) {
            return super.toString();
        }
        DateTime dateTime = this;
        return dateTime.toString(dateTime.timeZone);
    }

    public String toStringDefaultTimeZone() {
        return this.toString(TimeZone.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public String toString(TimeZone timeZone) {
        if (timeZone != null) {
            void var1_1;
            return this.toString(DateUtil.newSimpleFormat("yyyy-MM-dd HH:mm:ss", null, (TimeZone)var1_1));
        }
        return this.toString(DatePattern.NORM_DATETIME_FORMAT);
    }

    public String toDateStr() {
        if (this.timeZone != null) {
            return this.toString(DateUtil.newSimpleFormat("yyyy-MM-dd", null, this.timeZone));
        }
        return this.toString(DatePattern.NORM_DATE_FORMAT);
    }

    public String toTimeStr() {
        if (this.timeZone != null) {
            return this.toString(DateUtil.newSimpleFormat("HH:mm:ss", null, this.timeZone));
        }
        return this.toString(DatePattern.NORM_TIME_FORMAT);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(String format) {
        void var1_1;
        if (this.timeZone != null) {
            return this.toString(DateUtil.newSimpleFormat(format, null, this.timeZone));
        }
        return this.toString(FastDateFormat.getInstance((String)var1_1));
    }

    public String toString(DatePrinter format) {
        return format.format(this);
    }

    public String toString(DateFormat format) {
        return format.format(this);
    }

    public String toMsStr() {
        return this.toString(DatePattern.NORM_DATETIME_MS_FORMAT);
    }

    /*
     * WARNING - void declaration
     */
    private static java.util.Date parse(CharSequence dateStr, DateFormat dateFormat) {
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        try {
            return dateFormat.parse(dateStr.toString());
        }
        catch (Exception e) {
            void var2_2;
            void var1_1;
            CharSequence charSequence;
            String pattern;
            pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : pattern.toString();
            throw new DateException(StrUtil.format("Parse [{}] with format [{}] error!", charSequence, var1_1), (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Calendar parse(CharSequence dateStr, DateParser parser, boolean lenient) {
        void var2_3;
        Assert.notNull(parser, "Parser or DateFromat must be not null !", new Object[0]);
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        Calendar calendar = CalendarUtil.parse(dateStr, lenient, parser);
        if (calendar == null) {
            void var1_1;
            CharSequence charSequence;
            throw new DateException("Parse [{}] with format [{}] error!", charSequence, var1_1.getPattern());
        }
        calendar.setFirstDayOfWeek(Week.MONDAY.getValue());
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private DateTime setTimeInternal(long time) {
        void var1_1;
        super.setTime((long)var1_1);
        return this;
    }
}

