/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.CalendarUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class DateBetween
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date begin;
    private final Date end;

    /*
     * WARNING - void declaration
     */
    public static DateBetween create(Date begin, Date end) {
        void var1_1;
        Date date;
        return new DateBetween(date, (Date)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateBetween create(Date begin, Date end, boolean isAbs) {
        void var2_2;
        void var1_1;
        Date date;
        return new DateBetween(date, (Date)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public DateBetween(Date begin, Date end) {
        this((Date)var1_1, (Date)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateBetween(Date begin, Date end, boolean isAbs) {
        void var2_2;
        void var1_1;
        void var3_3;
        Assert.notNull(begin, "Begin date is null !", new Object[0]);
        Assert.notNull(end, "End date is null !", new Object[0]);
        if (var3_3 != false && begin.after(end)) {
            this.begin = end;
            this.end = begin;
            return;
        }
        this.begin = var1_1;
        this.end = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long between(DateUnit unit) {
        void var1_1;
        long l = this.end.getTime() - this.begin.getTime();
        return l / var1_1.getMillis();
    }

    /*
     * WARNING - void declaration
     */
    public long betweenMonth(boolean isReset) {
        void var1_1;
        Calendar beginCal = DateUtil.calendar(this.begin);
        Calendar endCal = DateUtil.calendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (var1_1 == false) {
            void var2_2;
            void var3_3;
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long l = var3_3.getTimeInMillis() - var2_2.getTimeInMillis();
            if (l < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public long betweenYear(boolean isReset) {
        Calendar beginCal = DateUtil.calendar(this.begin);
        Calendar endCal = DateUtil.calendar(this.end);
        int result = endCal.get(1) - beginCal.get(1);
        if (!isReset) {
            void var2_2;
            void var3_3;
            void var1_1;
            int endMonthBase0;
            int beginMonthBase0 = beginCal.get(2);
            if (beginMonthBase0 < (endMonthBase0 = endCal.get(2))) {
                return result;
            }
            if (beginMonthBase0 > endMonthBase0) {
                return result - 1;
            }
            if (true == var1_1 && CalendarUtil.isLastDayOfMonth(beginCal) && CalendarUtil.isLastDayOfMonth(endCal)) {
                beginCal.set(5, 1);
                endCal.set(5, 1);
            }
            endCal.set(1, beginCal.get(1));
            long l = var3_3.getTimeInMillis() - var2_2.getTimeInMillis();
            if (l < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(DateUnit unit, BetweenFormatter.Level level) {
        void var2_2;
        void var1_1;
        return DateUtil.formatBetween(this.between((DateUnit)var1_1), (BetweenFormatter.Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(BetweenFormatter.Level level) {
        void var1_1;
        return this.toString(DateUnit.MS, (BetweenFormatter.Level)var1_1);
    }

    public String toString() {
        return this.toString(BetweenFormatter.Level.MILLISECOND);
    }
}

