/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.convert.NumberChineseFormatter;
import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateModifier;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Month;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.date.format.FastDateParser;
import cn.hutool.core.date.format.GlobalCustomFormat;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarUtil {
    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        Date date2;
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return CalendarUtil.calendar(date2.getTime());
    }

    public static Calendar calendar(long millis) {
        return CalendarUtil.calendar(millis, TimeZone.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar calendar(long millis, TimeZone timeZone) {
        void var2_1;
        long l;
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTimeInMillis(l);
        return var2_1;
    }

    public static boolean isAM(Calendar calendar) {
        Calendar calendar2;
        return 0 == calendar2.get(9);
    }

    public static boolean isPM(Calendar calendar) {
        Calendar calendar2;
        return 1 == calendar2.get(9);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar truncate(Calendar calendar, DateField dateField) {
        void var1_1;
        return DateModifier.modify(calendar, var1_1.getValue(), DateModifier.ModifyType.TRUNCATE);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar round(Calendar calendar, DateField dateField) {
        void var1_1;
        return DateModifier.modify(calendar, var1_1.getValue(), DateModifier.ModifyType.ROUND);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar ceiling(Calendar calendar, DateField dateField) {
        void var1_1;
        return DateModifier.modify(calendar, var1_1.getValue(), DateModifier.ModifyType.CEILING);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar ceiling(Calendar calendar, DateField dateField, boolean truncateMillisecond) {
        void var2_2;
        void var1_1;
        return DateModifier.modify(calendar, var1_1.getValue(), DateModifier.ModifyType.CEILING, (boolean)var2_2);
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.SECOND);
    }

    public static Calendar beginOfHour(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.HOUR_OF_DAY);
    }

    public static Calendar endOfHour(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.HOUR_OF_DAY);
    }

    public static Calendar beginOfMinute(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.MINUTE);
    }

    public static Calendar endOfMinute(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.MINUTE);
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return CalendarUtil.beginOfWeek(calendar, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        Calendar calendar2;
        void var1_1;
        calendar.setFirstDayOfWeek(var1_1 != false ? 2 : 1);
        return CalendarUtil.truncate(calendar2, DateField.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return CalendarUtil.endOfWeek(calendar, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        Calendar calendar2;
        void var1_1;
        calendar.setFirstDayOfWeek(var1_1 != false ? 2 : 1);
        return CalendarUtil.ceiling(calendar2, DateField.WEEK_OF_MONTH);
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.MONTH);
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        Calendar calendar2;
        calendar.set(2, calendar.get(DateField.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return CalendarUtil.beginOfDay(calendar2);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar endOfQuarter(Calendar calendar) {
        Calendar calendar2;
        void var1_1;
        void var2_2;
        int year = calendar.get(1);
        int month = calendar.get(DateField.MONTH.getValue()) / 3 * 3 + 2;
        Calendar resultCal = Calendar.getInstance(calendar.getTimeZone());
        void v0 = var2_2;
        resultCal.set(year, (int)v0, Month.of((int)v0).getLastDay(DateUtil.isLeapYear((int)var1_1)));
        return CalendarUtil.endOfDay(calendar2);
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.YEAR);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        void var1_1;
        Calendar calendar;
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && calendar.get(0) == var1_1.get(0);
    }

    public static boolean isLastDayOfMonth(Calendar calendar) {
        Calendar calendar2;
        return calendar.get(5) == calendar2.getActualMaximum(5);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameWeek(Calendar cal1, Calendar cal2, boolean isMon) {
        void var1_1;
        Calendar calendar;
        void var2_2;
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        cal1 = (Calendar)cal1.clone();
        cal2 = (Calendar)cal2.clone();
        if (var2_2 != false) {
            cal1.setFirstDayOfWeek(2);
            cal1.set(7, 2);
            cal2.setFirstDayOfWeek(2);
            cal2.set(7, 2);
        } else {
            cal1.setFirstDayOfWeek(1);
            cal1.set(7, 1);
            cal2.setFirstDayOfWeek(1);
            cal2.set(7, 1);
        }
        return CalendarUtil.isSameDay(calendar, (Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameMonth(Calendar cal1, Calendar cal2) {
        void var1_1;
        Calendar calendar;
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && calendar.get(0) == var1_1.get(0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameInstant(Calendar date1, Calendar date2) {
        void var1_1;
        Calendar calendar;
        if (date1 == null) {
            return date2 == null;
        }
        if (date2 == null) {
            return false;
        }
        return calendar.getTimeInMillis() == var1_1.getTimeInMillis();
    }

    public static LinkedHashSet<String> yearAndQuarter(long startDate, long endDate) {
        LinkedHashSet<String> quarters = new LinkedHashSet<String>();
        Calendar cal = CalendarUtil.calendar(startDate);
        while (startDate <= endDate) {
            quarters.add(CalendarUtil.yearAndQuarter(cal));
            cal.add(2, 3);
            startDate = cal.getTimeInMillis();
        }
        return quarters;
    }

    public static String yearAndQuarter(Calendar cal) {
        Calendar calendar;
        return StrUtil.builder().append(cal.get(1)).append(calendar.get(2) / 3 + 1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static int getBeginValue(Calendar calendar, DateField dateField) {
        void var1_1;
        return CalendarUtil.getBeginValue(calendar, var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static int getBeginValue(Calendar calendar, int dateField) {
        void var1_1;
        Calendar calendar2;
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar2.getActualMinimum((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int getEndValue(Calendar calendar, DateField dateField) {
        void var1_1;
        return CalendarUtil.getEndValue(calendar, var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static int getEndValue(Calendar calendar, int dateField) {
        void var1_1;
        Calendar calendar2;
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar2.getActualMaximum((int)var1_1);
    }

    public static Instant toInstant(Calendar calendar) {
        Calendar calendar2;
        if (calendar == null) {
            return null;
        }
        return calendar2.toInstant();
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        Calendar calendar2;
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar2.getTimeZone().toZoneId());
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(Calendar calendar1, Calendar calendar2) {
        void var1_1;
        return CompareUtil.compare(calendar1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int age(Calendar birthday, Calendar dateToCompare) {
        void var1_1;
        return CalendarUtil.age(birthday.getTimeInMillis(), var1_1.getTimeInMillis());
    }

    /*
     * WARNING - void declaration
     */
    public static String formatChineseDate(Calendar calendar, boolean withTime) {
        void var2_3;
        void var3_6;
        StringBuilder result = StrUtil.builder();
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(NumberChineseFormatter.numberCharToChinese(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(NumberChineseFormatter.formatThousand(month, false));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(NumberChineseFormatter.formatThousand(day, false));
        result.append('\u65e5');
        String temp = result.toString().replace('\u96f6', '\u3007');
        result.delete(0, result.length());
        result.append((String)var3_6);
        if (withTime) {
            void var0_1;
            void var1_2;
            int hour = calendar.get(11);
            result.append(NumberChineseFormatter.formatThousand(hour, false));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(NumberChineseFormatter.formatThousand((int)var1_2, false));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(NumberChineseFormatter.formatThousand((int)var0_1, false));
            result.append('\u79d2');
        }
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static int age(long birthday, long dateToCompare) {
        void var0_1;
        void var3_5;
        void var1_7;
        void var2_3;
        if (birthday > dateToCompare) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateToCompare);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTimeInMillis(birthday);
        void age = var2_3 - cal.get(1);
        if (age == false) {
            return 0;
        }
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth <= var1_7) {
                --age;
            }
        } else if (var3_5 < var1_7) {
            --age;
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar parseByPatterns(String str, String ... parsePatterns) throws DateException {
        void var1_1;
        return CalendarUtil.parseByPatterns(str, null, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar parseByPatterns(String str, Locale locale, String ... parsePatterns) throws DateException {
        void var2_2;
        void var1_1;
        return CalendarUtil.parseByPatterns(str, (Locale)var1_1, true, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar parseByPatterns(String str, Locale locale, boolean lenient, String ... parsePatterns) throws DateException {
        String string;
        void var3_4;
        void var2_2;
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectUtil.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient((boolean)var2_2);
        for (void parsePattern : var3_4) {
            Date parse;
            if (GlobalCustomFormat.isCustomFormat((String)parsePattern)) {
                parse = GlobalCustomFormat.parse(str, (String)parsePattern);
                if (parse == null) continue;
                calendar.setTime(parse);
                return calendar;
            }
            FastDateParser fdp = new FastDateParser((String)((Object)parse), tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(str, pos, calendar) && pos.getIndex() == str.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            pos.setIndex(0);
        }
        throw new DateException("Unable to parse the date: {}", string);
    }

    /*
     * WARNING - void declaration
     */
    public static Calendar parse(CharSequence str, boolean lenient, DateParser parser) {
        CharSequence charSequence;
        void var2_2;
        void var1_1;
        Calendar calendar = Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient((boolean)var1_1);
        if (var2_2.parse(StrUtil.str(charSequence), new ParsePosition(0), calendar)) {
            void var3_3;
            return var3_3;
        }
        return null;
    }
}

