/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;

public class BetweenFormatter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long betweenMs;
    private Level level;
    private final int levelMaxCount;

    /*
     * WARNING - void declaration
     */
    public BetweenFormatter(long betweenMs, Level level) {
        this((long)var1_1, (Level)var3_2, 0);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BetweenFormatter(long betweenMs, Level level, int levelMaxCount) {
        void var3_2;
        void var1_1;
        this.betweenMs = var1_1;
        this.level = var3_2;
        this.levelMaxCount = levelMaxCount;
    }

    /*
     * WARNING - void declaration
     */
    public String format() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        if (this.betweenMs > 0L) {
            long day = this.betweenMs / DateUnit.DAY.getMillis();
            long hour = this.betweenMs / DateUnit.HOUR.getMillis() - day * 24L;
            long minute = this.betweenMs / DateUnit.MINUTE.getMillis() - day * 24L * 60L - hour * 60L;
            long BetweenOfSecond = ((day * 24L + hour) * 60L + minute) * 60L;
            long second = this.betweenMs / DateUnit.SECOND.getMillis() - BetweenOfSecond;
            long millisecond = this.betweenMs - (BetweenOfSecond + second) * 1000L;
            int level = this.level.ordinal();
            int levelCount = 0;
            if (this.isLevelCountValid(0) && 0L != day && level >= Level.DAY.ordinal()) {
                void var2_2;
                sb.append((long)var2_2).append(Level.DAY.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != hour && level >= Level.HOUR.ordinal()) {
                sb.append(hour).append(Level.HOUR.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != minute && level >= Level.MINUTE.ordinal()) {
                sb.append(minute).append(Level.MINUTE.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != second && level >= Level.SECOND.ordinal()) {
                sb.append(second).append(Level.SECOND.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != millisecond && level >= Level.MILLISECOND.ordinal()) {
                sb.append(millisecond).append(Level.MILLISECOND.name);
            }
        }
        if (StrUtil.isEmpty(sb)) {
            sb.append(0).append(this.level.name);
        }
        return var1_1.toString();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    /*
     * WARNING - void declaration
     */
    public void setBetweenMs(long betweenMs) {
        void var1_1;
        this.betweenMs = var1_1;
    }

    public Level getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(Level level) {
        void var1_1;
        this.level = var1_1;
    }

    public String toString() {
        return this.format();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isLevelCountValid(int levelCount) {
        void var1_1;
        return this.levelMaxCount <= 0 || var1_1 < this.levelMaxCount;
    }

    public static enum Level {
        DAY("\u5929"),
        HOUR("\u5c0f\u65f6"),
        MINUTE("\u5206"),
        SECOND("\u79d2"),
        MILLISECOND("\u6beb\u79d2");

        private final String name;

        /*
         * WARNING - void declaration
         */
        private Level(String name) {
            void var3_3;
            this.name = var3_3;
        }

        public final String getName() {
            return this.name;
        }
    }
}

