/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.XmlUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class StringConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    @Override
    protected String convertInternal(Object value) {
        void var1_1;
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Node) {
            return XmlUtil.toStr((Node)value);
        }
        if (value instanceof Clob) {
            return StringConverter.clobToStr((Clob)value);
        }
        if (value instanceof Blob) {
            return StringConverter.blobToStr((Blob)value);
        }
        if (value instanceof Type) {
            return ((Type)value).getTypeName();
        }
        return this.convertToStr(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            clob = IoUtil.read(reader);
        }
        catch (SQLException e) {
            try {
                void var0_1;
                throw new ConvertException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var1_3;
                IoUtil.close((Closeable)var1_3);
                throw throwable;
            }
        }
        IoUtil.close(reader);
        return clob;
    }

    /*
     * WARNING - void declaration
     */
    private static String blobToStr(Blob blob) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            blob = IoUtil.read(in, CharsetUtil.CHARSET_UTF_8);
        }
        catch (SQLException e) {
            try {
                void var0_1;
                throw new ConvertException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var1_3;
                IoUtil.close((Closeable)var1_3);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return blob;
    }
}

