/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.impl.NumberConverter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.function.Function;

public class PrimitiveConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;

    /*
     * WARNING - void declaration
     */
    public PrimitiveConverter(Class<?> clazz) {
        void var1_1;
        if (clazz == null) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = var1_1;
    }

    @Override
    protected Object convertInternal(Object value) {
        return PrimitiveConverter.convert(value, this.targetType, this::convertToStr);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String convertToStr(Object value) {
        void var1_1;
        return StrUtil.trim(super.convertToStr(var1_1));
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }

    /*
     * WARNING - void declaration
     */
    protected static Object convert(Object value, Class<?> primitiveClass, Function<Object, String> toStringFunc) {
        void var1_1;
        if (Byte.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Byte.class, toStringFunc), 0);
        }
        if (Short.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Short.class, toStringFunc), 0);
        }
        if (Integer.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Integer.class, toStringFunc), 0);
        }
        if (Long.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Long.class, toStringFunc), 0);
        }
        if (Float.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Float.class, toStringFunc), 0);
        }
        if (Double.TYPE == primitiveClass) {
            void var2_2;
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Double.class, (Function<Object, String>)var2_2), 0);
        }
        if (Character.TYPE == primitiveClass) {
            return Convert.convert(Character.class, value);
        }
        if (Boolean.TYPE == primitiveClass) {
            Object object;
            return Convert.convert(Boolean.class, object);
        }
        throw new ConvertException("Unsupported target type: {}", var1_1);
    }
}

