/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ByteUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

public class NumberConverter
extends AbstractConverter<Number> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    /*
     * WARNING - void declaration
     */
    public NumberConverter(Class<? extends Number> clazz) {
        void var1_1;
        this.targetType = clazz == null ? Number.class : var1_1;
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }

    @Override
    protected Number convertInternal(Object value) {
        return NumberConverter.convert(value, this.targetType, this::convertToStr);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String convertToStr(Object value) {
        void var1_1;
        String result = StrUtil.trim(super.convertToStr(value));
        if (result != null && result.length() > 1) {
            void var2_2;
            String string = result;
            char c = Character.toUpperCase(string.charAt(string.length() - 1));
            if (c == 'D' || c == 'L' || var2_2 == 70) {
                return StrUtil.subPre(result, -1);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected static Number convert(Object value, Class<? extends Number> targetType, Function<Object, String> toStrFunc) {
        void var1_1;
        Object number;
        Object valueStr;
        while (value instanceof Enum) {
            value = ((Enum)value).ordinal();
        }
        if (value instanceof byte[]) {
            return ByteUtil.bytesToNumber((byte[])value, targetType, ByteUtil.DEFAULT_ORDER);
        }
        if (Byte.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtil.toByteObj((Boolean)value);
            }
            valueStr = toStrFunc.apply(value);
            try {
                if (StrUtil.isBlank((CharSequence)valueStr)) {
                    return null;
                }
                return Byte.valueOf((String)valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                return NumberUtil.parseNumber((String)valueStr).byteValue();
            }
        }
        if (Short.class == targetType) {
            if (valueStr instanceof Number) {
                return ((Number)valueStr).shortValue();
            }
            if (valueStr instanceof Boolean) {
                return BooleanUtil.toShortObj((Boolean)valueStr);
            }
            valueStr = toStrFunc.apply(valueStr);
            try {
                if (StrUtil.isBlank((CharSequence)valueStr)) {
                    return null;
                }
                return Short.valueOf((String)valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                return NumberUtil.parseNumber((String)valueStr).shortValue();
            }
        }
        if (Integer.class == targetType) {
            if (valueStr instanceof Number) {
                return ((Number)valueStr).intValue();
            }
            if (valueStr instanceof Boolean) {
                return BooleanUtil.toInteger((Boolean)valueStr);
            }
            if (valueStr instanceof Date) {
                return (int)((Date)valueStr).getTime();
            }
            if (valueStr instanceof Calendar) {
                return (int)((Calendar)valueStr).getTimeInMillis();
            }
            if (valueStr instanceof TemporalAccessor) {
                return (int)DateUtil.toInstant((TemporalAccessor)valueStr).toEpochMilli();
            }
            if (StrUtil.isBlank((CharSequence)(valueStr = toStrFunc.apply(valueStr)))) {
                return null;
            }
            return NumberUtil.parseInt((String)valueStr);
        }
        if (AtomicInteger.class == targetType) {
            number = NumberConverter.convert(valueStr, Integer.class, toStrFunc);
            if (number != null) {
                return new AtomicInteger(((Number)number).intValue());
            }
        } else {
            LongAdder longValue;
            if (Long.class == targetType) {
                if (number instanceof Number) {
                    return ((Number)number).longValue();
                }
                if (number instanceof Boolean) {
                    return BooleanUtil.toLongObj((Boolean)number);
                }
                if (number instanceof Date) {
                    return ((Date)number).getTime();
                }
                if (number instanceof Calendar) {
                    return ((Calendar)number).getTimeInMillis();
                }
                if (number instanceof TemporalAccessor) {
                    return DateUtil.toInstant((TemporalAccessor)number).toEpochMilli();
                }
                valueStr = toStrFunc.apply(number);
                if (StrUtil.isBlank((CharSequence)valueStr)) {
                    return null;
                }
                return NumberUtil.parseLong((String)valueStr);
            }
            if (AtomicLong.class == targetType) {
                number = NumberConverter.convert(valueStr, Long.class, toStrFunc);
                if (number != null) {
                    return new AtomicLong(((Number)number).longValue());
                }
            } else if (LongAdder.class == targetType) {
                if ((number = NumberConverter.convert(number, Long.class, toStrFunc)) != null) {
                    longValue = new LongAdder();
                    longValue.add(((Number)number).longValue());
                    return longValue;
                }
            } else {
                if (Float.class == longValue) {
                    if (number instanceof Number) {
                        return Float.valueOf(((Number)number).floatValue());
                    }
                    if (number instanceof Boolean) {
                        return BooleanUtil.toFloatObj((Boolean)number);
                    }
                    valueStr = toStrFunc.apply(number);
                    if (StrUtil.isBlank((CharSequence)valueStr)) {
                        return null;
                    }
                    return Float.valueOf(NumberUtil.parseFloat((String)valueStr));
                }
                if (Double.class == longValue) {
                    if (valueStr instanceof Number) {
                        return NumberUtil.toDouble((Number)valueStr);
                    }
                    if (valueStr instanceof Boolean) {
                        return BooleanUtil.toDoubleObj((Boolean)valueStr);
                    }
                    if (StrUtil.isBlank((CharSequence)(valueStr = toStrFunc.apply(valueStr)))) {
                        return null;
                    }
                    return NumberUtil.parseDouble((String)valueStr);
                }
                if (DoubleAdder.class == longValue) {
                    number = NumberConverter.convert(valueStr, Double.class, toStrFunc);
                    if (number != null) {
                        DoubleAdder doubleAdder = new DoubleAdder();
                        doubleAdder.add(((Number)number).doubleValue());
                        return var1_1;
                    }
                } else {
                    if (BigDecimal.class == var1_1) {
                        return NumberConverter.toBigDecimal(number, toStrFunc);
                    }
                    if (BigInteger.class == var1_1) {
                        return NumberConverter.toBigInteger(number, toStrFunc);
                    }
                    if (Number.class == var1_1) {
                        Object object;
                        void var2_2;
                        if (number instanceof Number) {
                            return (Number)number;
                        }
                        if (number instanceof Boolean) {
                            return BooleanUtil.toInteger((Boolean)number);
                        }
                        valueStr = (String)var2_2.apply(number);
                        if (StrUtil.isBlank((CharSequence)valueStr)) {
                            return null;
                        }
                        return NumberUtil.parseNumber((String)object);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupport Number type: {}", var1_1.getName()));
    }

    /*
     * WARNING - void declaration
     */
    private static BigDecimal toBigDecimal(Object value, Function<Object, String> toStrFunc) {
        Object object;
        void var1_1;
        if (value instanceof Number) {
            return NumberUtil.toBigDecimal((Number)value);
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return BigDecimal.ONE;
            }
            return BigDecimal.ZERO;
        }
        return NumberUtil.toBigDecimal((String)var1_1.apply(object));
    }

    /*
     * WARNING - void declaration
     */
    private static BigInteger toBigInteger(Object value, Function<Object, String> toStrFunc) {
        Object object;
        void var1_1;
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return BigInteger.ONE;
            }
            return BigInteger.ZERO;
        }
        return NumberUtil.toBigInteger((String)var1_1.apply(object));
    }
}

