/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.lang.EnumItem;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.WeakConcurrentMap;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class EnumConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private static final WeakConcurrentMap<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new WeakConcurrentMap();
    private final Class enumClass;

    /*
     * WARNING - void declaration
     */
    public EnumConverter(Class enumClass) {
        void var1_1;
        this.enumClass = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object convertInternal(Object value) {
        void var1_1;
        Enum enumValue = EnumConverter.tryConvertEnum(value, this.enumClass);
        if (enumValue == null && !(value instanceof String)) {
            enumValue = Enum.valueOf(this.enumClass, this.convertToStr(value));
        }
        if (enumValue != null) {
            void var2_2;
            return var2_2;
        }
        throw new ConvertException("Can not convert {} to {}", var1_1, this.enumClass);
    }

    @Override
    public Class getTargetType() {
        return this.enumClass;
    }

    /*
     * WARNING - void declaration
     */
    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        void var2_2;
        EnumItem first;
        if (value == null) {
            return null;
        }
        if (EnumItem.class.isAssignableFrom(enumClass) && (first = (EnumItem)EnumUtil.getEnumAt(enumClass, 0)) != null) {
            if (value instanceof Integer) {
                return (Enum)first.fromInt((Integer)value);
            }
            if (value instanceof String) {
                return (Enum)first.fromStr(value.toString());
            }
        }
        try {
            Map<Class<?>, Method> methodMap = EnumConverter.getMethodMap(enumClass);
            if (MapUtil.isNotEmpty(methodMap)) {
                Class<?> valueClass = value.getClass();
                for (Map.Entry entry : methodMap.entrySet()) {
                    if (!ClassUtil.isAssignable((Class)entry.getKey(), valueClass)) continue;
                    return (Enum)ReflectUtil.invokeStatic((Method)entry.getValue(), value);
                }
            }
        }
        catch (Exception exception) {}
        Object enumResult = null;
        if (value instanceof Integer) {
            enumResult = EnumUtil.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                Object object;
                void var1_1;
                enumResult = Enum.valueOf(var1_1, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return var2_2;
    }

    private static Map<Class<?>, Method> getMethodMap(Class<?> enumClass) {
        Class<?> clazz;
        Class<?> clazz2 = clazz;
        return VALUE_OF_METHOD_CACHE.computeIfAbsent(clazz2, key -> {
            Class clazz;
            return Arrays.stream(clazz2.getMethods()).filter(ModifierUtil::isStatic).filter(m -> {
                Class clazz;
                return m.getReturnType() == clazz;
            }).filter(m -> m.getParameterCount() == 1).filter(m -> {
                Method method;
                return false == "valueOf".equals(method.getName());
            }).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (k1, k2) -> k1));
        });
    }
}

