/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Date> targetType;
    private String format;

    /*
     * WARNING - void declaration
     */
    public DateConverter(Class<? extends Date> targetType) {
        void var1_1;
        this.targetType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateConverter(Class<? extends Date> targetType, String format) {
        void var2_2;
        void var1_1;
        this.targetType = var1_1;
        this.format = var2_2;
    }

    public String getFormat() {
        return this.format;
    }

    /*
     * WARNING - void declaration
     */
    public void setFormat(String format) {
        void var1_1;
        this.format = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Date convertInternal(Object value) {
        void var1_1;
        DateTime dateTime;
        if (value == null || value instanceof CharSequence && StrUtil.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(DateUtil.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(DateUtil.date((Calendar)value));
        }
        if (value instanceof Number) {
            return this.wrap(((Number)value).longValue());
        }
        String valueStr = this.convertToStr(value);
        DateTime dateTime2 = dateTime = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format);
        if (dateTime != null) {
            void var2_2;
            return this.wrap((DateTime)var2_2);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value.getClass().getName(), var1_1, this.targetType.getName());
    }

    /*
     * WARNING - void declaration
     */
    private Date wrap(DateTime date) {
        if (Date.class == this.targetType) {
            return date.toJdkDate();
        }
        if (DateTime.class == this.targetType) {
            return date;
        }
        if (java.sql.Date.class == this.targetType) {
            return date.toSqlDate();
        }
        if (Time.class == this.targetType) {
            return new Time(date.getTime());
        }
        if (Timestamp.class == this.targetType) {
            void var1_1;
            return var1_1.toTimestamp();
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupported target Date type: {}", this.targetType.getName()));
    }

    /*
     * WARNING - void declaration
     */
    private Date wrap(long mills) {
        if ("#sss".equals(this.format)) {
            return DateUtil.date(mills * 1000L);
        }
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (DateTime.class == this.targetType) {
            return DateUtil.date(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            void var1_1;
            return new Timestamp((long)var1_1);
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupported target Date type: {}", this.targetType.getName()));
    }

    @Override
    public Class<Date> getTargetType() {
        return this.targetType;
    }
}

