/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ByteUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;
    private final Class<?> targetComponentType;
    private boolean ignoreElementError;

    /*
     * WARNING - void declaration
     */
    public ArrayConverter(Class<?> targetType) {
        this((Class<?>)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayConverter(Class<?> targetType, boolean ignoreElementError) {
        void var2_2;
        if (targetType == null) {
            targetType = Object[].class;
        }
        if (targetType.isArray()) {
            this.targetType = targetType;
            this.targetComponentType = targetType.getComponentType();
        } else {
            void var1_1;
            this.targetComponentType = targetType;
            this.targetType = ArrayUtil.getArrayType(var1_1);
        }
        this.ignoreElementError = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object convertInternal(Object value) {
        void var1_1;
        if (value.getClass().isArray()) {
            return this.convertArrayToArray(value);
        }
        return this.convertObjectToArray(var1_1);
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoreElementError(boolean ignoreElementError) {
        void var1_1;
        this.ignoreElementError = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Object convertArrayToArray(Object array) {
        void var3_4;
        Class<?> clazz = ArrayUtil.getComponentType(array);
        if (clazz == this.targetComponentType) {
            return array;
        }
        int len = ArrayUtil.length(array);
        Object result = Array.newInstance(this.targetComponentType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, this.convertComponentType(Array.get(array, i)));
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private Object convertObjectToArray(Object value) {
        void var2_4;
        Object collection;
        Object[] result;
        List list;
        if (value instanceof CharSequence) {
            if (this.targetComponentType == Character.TYPE || this.targetComponentType == Character.class) {
                return this.convertArrayToArray(value.toString().toCharArray());
            }
            if (this.targetComponentType == Byte.TYPE) {
                String str = value.toString();
                if (Base64.isBase64(str)) {
                    return Base64.decode(value.toString());
                }
                return str.getBytes();
            }
            String[] strings = StrUtil.splitToArray((CharSequence)value.toString(), ',');
            return this.convertArrayToArray(strings);
        }
        if (value instanceof List) {
            list = (List)value;
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else if (list instanceof Collection) {
            collection = list;
            result = Array.newInstance(this.targetComponentType, collection.size());
            int i = 0;
            collection = collection.iterator();
            while (collection.hasNext()) {
                Object element = collection.next();
                Array.set(result, i, this.convertComponentType(element));
                ++i;
            }
        } else if (collection instanceof Iterable) {
            list = IterUtil.toList((Iterable)collection);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else if (list instanceof Iterator) {
            list = IterUtil.toList((Iterator)((Object)list));
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else {
            void var1_1;
            result = var1_1 instanceof Number && Byte.TYPE == this.targetComponentType ? (Object[])ByteUtil.numberToBytes((Number)var1_1) : (var1_1 instanceof Serializable && Byte.TYPE == this.targetComponentType ? (Object[])ObjectUtil.serialize(var1_1) : this.convertToSingleElementArray(var1_1));
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] convertToSingleElementArray(Object value) {
        void var2_2;
        void var1_1;
        T[] TArray = ArrayUtil.newArray(this.targetComponentType, 1);
        T[] singleElementArray = TArray;
        TArray[0] = this.convertComponentType(var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object convertComponentType(Object value) {
        void var1_1;
        return Convert.convertWithCheck(this.targetComponentType, var1_1, null, this.ignoreElementError);
    }
}

