/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class NumberChineseFormatter {
    private static final char[] DIGITS = new char[]{'\u96f6', '\u4e00', '\u58f9', '\u4e8c', '\u8d30', '\u4e09', '\u53c1', '\u56db', '\u8086', '\u4e94', '\u4f0d', '\u516d', '\u9646', '\u4e03', '\u67d2', '\u516b', '\u634c', '\u4e5d', '\u7396'};
    private static final ChineseUnit[] CHINESE_NAME_VALUE = new ChineseUnit[]{new ChineseUnit(' ', 1, false), new ChineseUnit('\u5341', 10, false), new ChineseUnit('\u62fe', 10, false), new ChineseUnit('\u767e', 100, false), new ChineseUnit('\u4f70', 100, false), new ChineseUnit('\u5343', 1000, false), new ChineseUnit('\u4edf', 1000, false), new ChineseUnit('\u4e07', 10000, true), new ChineseUnit('\u4ebf', 100000000, true)};

    /*
     * WARNING - void declaration
     */
    public static String format(double amount, boolean isUseTraditional) {
        void var2_1;
        return NumberChineseFormatter.format(amount, (boolean)var2_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode, String negativeName, String unitName) {
        if (0.0 == amount) {
            return "\u96f6";
        }
        Assert.checkBetween(amount, -9.999999999999998E13, 9.999999999999998E13, "Number support only: (-99999999999999.99 ~ 99999999999999.99)\uff01", new Object[0]);
        StringBuilder chineseStr = new StringBuilder();
        if (amount < 0.0) {
            chineseStr.append(StrUtil.isNullOrUndefined(negativeName) ? "\u8d1f" : negativeName);
            amount = -amount;
        }
        long yuan = Math.round(amount * 100.0);
        int fen = (int)(yuan % 10L);
        int jiao = (int)((yuan /= 10L) % 10L);
        if (!isMoneyMode || 0L != (yuan /= 10L)) {
            chineseStr.append(NumberChineseFormatter.longToChinese(yuan, isUseTraditional));
            if (isMoneyMode) {
                chineseStr.append(StrUtil.isNullOrUndefined(unitName) ? "\u5143" : unitName);
            }
        }
        if (jiao == 0 && fen == 0) {
            if (isMoneyMode) {
                chineseStr.append("\u6574");
            }
            return chineseStr.toString();
        }
        if (!isMoneyMode) {
            chineseStr.append("\u70b9");
        }
        if (0L == yuan && jiao == 0) {
            if (!isMoneyMode) {
                chineseStr.append("\u96f6");
            }
        } else {
            void var1_8;
            chineseStr.append(NumberChineseFormatter.numberToChinese(jiao, isUseTraditional));
            if (isMoneyMode && var1_8 != false) {
                chineseStr.append("\u89d2");
            }
        }
        if (fen != 0) {
            void var3_3;
            void var2_2;
            void var0_1;
            chineseStr.append(NumberChineseFormatter.numberToChinese((int)var0_1, (boolean)var2_2));
            if (var3_3 != false) {
                chineseStr.append("\u5206");
            }
        }
        return chineseStr.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        void var3_2;
        void var2_1;
        return NumberChineseFormatter.format(amount, (boolean)var2_1, (boolean)var3_2, "\u8d1f", "\u5143");
    }

    /*
     * WARNING - void declaration
     */
    public static String format(long amount, boolean isUseTraditional) {
        void var3_2;
        void var2_1;
        long l;
        if (0L == amount) {
            return "\u96f6";
        }
        Assert.checkBetween((double)amount, -9.999999999999998E13, 9.999999999999998E13, "Number support only: (-99999999999999.99 ~ 99999999999999.99)\uff01", new Object[0]);
        StringBuilder chineseStr = new StringBuilder();
        if (amount < 0L) {
            chineseStr.append("\u8d1f");
            amount = -amount;
        }
        chineseStr.append(NumberChineseFormatter.longToChinese(l, (boolean)var2_1));
        return var3_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String formatSimple(long amount) {
        void var0_1;
        long res22;
        if (amount < 10000L && amount > -10000L) {
            return String.valueOf(amount);
        }
        String res22 = amount < 100000000L && amount > -100000000L ? NumberUtil.div((float)amount, 10000.0f, 2) + "\u4e07" : (res22 < 1000000000000L && res22 > -1000000000000L ? NumberUtil.div((float)res22, 1.0E8f, 2) + "\u4ebf" : NumberUtil.div((float)res22, 1.0E12f, 2) + "\u4e07\u4ebf");
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatThousand(int amount, boolean isUseTraditional) {
        void var1_2;
        int n;
        Assert.checkBetween(amount, -999, 999, "Number support only: (-999 ~ 999)\uff01", new Object[0]);
        String chinese = NumberChineseFormatter.thousandToChinese(amount, isUseTraditional);
        if (amount < 20 && n >= 10) {
            return chinese.substring(1);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String numberCharToChinese(char c, boolean isUseTraditional) {
        void var1_1;
        char c2;
        if (c < '0' || c > '9') {
            return String.valueOf(c);
        }
        return String.valueOf(NumberChineseFormatter.numberToChinese(c2 - 48, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal chineseMoneyToNumber(String chineseMoneyAmount) {
        void var2_4;
        void var1_3;
        void var0_1;
        if (StrUtil.isBlank(chineseMoneyAmount)) {
            return null;
        }
        int yi = chineseMoneyAmount.indexOf("\u5143");
        if (yi == -1) {
            yi = chineseMoneyAmount.indexOf("\u5706");
        }
        int ji = chineseMoneyAmount.indexOf("\u89d2");
        int fi = chineseMoneyAmount.indexOf("\u5206");
        String yStr = null;
        if (yi > 0) {
            yStr = chineseMoneyAmount.substring(0, yi);
        }
        String jStr = null;
        if (ji > 0) {
            if (yi >= 0) {
                if (ji > yi) {
                    jStr = chineseMoneyAmount.substring(yi + 1, ji);
                }
            } else {
                jStr = chineseMoneyAmount.substring(0, ji);
            }
        }
        String fStr = null;
        if (fi > 0) {
            if (ji >= 0) {
                if (fi > ji) {
                    fStr = chineseMoneyAmount.substring(ji + 1, fi);
                }
            } else if (yi > 0) {
                if (fi > yi) {
                    fStr = chineseMoneyAmount.substring(yi + 1, fi);
                }
            } else {
                void var3_5;
                fStr = chineseMoneyAmount.substring(0, (int)var3_5);
            }
        }
        int y = 0;
        int j = 0;
        int f = 0;
        if (StrUtil.isNotBlank(yStr)) {
            y = NumberChineseFormatter.chineseToNumber(yStr);
        }
        if (StrUtil.isNotBlank(jStr)) {
            j = NumberChineseFormatter.chineseToNumber(jStr);
        }
        if (StrUtil.isNotBlank(fStr)) {
            f = NumberChineseFormatter.chineseToNumber(fStr);
        }
        BigDecimal bigDecimal = new BigDecimal((int)var0_1);
        bigDecimal = bigDecimal.add(BigDecimal.valueOf((long)var1_3).divide(BigDecimal.TEN, 2, RoundingMode.HALF_UP));
        bigDecimal = bigDecimal.add(BigDecimal.valueOf((long)var2_4).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        return bigDecimal;
    }

    /*
     * WARNING - void declaration
     */
    private static String longToChinese(long amount, boolean isUseTraditional) {
        String partChinese;
        int partValue;
        StringBuilder chineseStr;
        int[] parts;
        block18: {
            block17: {
                block16: {
                    block15: {
                        if (0L == amount) {
                            return "\u96f6";
                        }
                        parts = new int[4];
                        int i = 0;
                        while (amount != 0L) {
                            parts[i] = (int)(amount % 10000L);
                            amount /= 10000L;
                            ++i;
                        }
                        chineseStr = new StringBuilder();
                        partValue = parts[0];
                        if (partValue > 0) {
                            partChinese = NumberChineseFormatter.thousandToChinese(partValue, isUseTraditional);
                            chineseStr.insert(0, partChinese);
                            if (partValue < 1000) {
                                NumberChineseFormatter.addPreZero(chineseStr);
                            }
                        }
                        if ((partValue = parts[1]) <= 0) break block15;
                        if (partValue % 10 == 0 && parts[0] > 0) {
                            NumberChineseFormatter.addPreZero(chineseStr);
                        }
                        partChinese = NumberChineseFormatter.thousandToChinese(partValue, isUseTraditional);
                        chineseStr.insert(0, partChinese + "\u4e07");
                        if (partValue >= 1000) break block16;
                    }
                    NumberChineseFormatter.addPreZero(chineseStr);
                }
                if ((partValue = parts[2]) <= 0) break block17;
                if (partValue % 10 == 0 && parts[1] > 0) {
                    NumberChineseFormatter.addPreZero(chineseStr);
                }
                partChinese = NumberChineseFormatter.thousandToChinese(partValue, isUseTraditional);
                chineseStr.insert(0, partChinese + "\u4ebf");
                if (partValue >= 1000) break block18;
            }
            NumberChineseFormatter.addPreZero(chineseStr);
        }
        if ((partValue = parts[3]) > 0) {
            void var1_6;
            void var2_2;
            void var0_1;
            void var3_3;
            if (var3_3[2] == false) {
                chineseStr.insert(0, "\u4ebf");
            }
            partChinese = NumberChineseFormatter.thousandToChinese((int)var0_1, (boolean)var2_2);
            chineseStr.insert(0, (String)var1_6 + "\u4e07");
        }
        if (StrUtil.isNotEmpty(chineseStr) && '\u96f6' == chineseStr.charAt(0)) {
            return chineseStr.substring(1);
        }
        return chineseStr.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String thousandToChinese(int amountPart, boolean isUseTraditional) {
        void var2_2;
        int temp;
        if (amountPart == 0) {
            return String.valueOf(DIGITS[0]);
        }
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                chineseStr.insert(0, NumberChineseFormatter.numberToChinese(digit, isUseTraditional) + NumberChineseFormatter.getUnitName(i, isUseTraditional));
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static int chineseToNumber(String chinese) {
        void var3_3;
        void var2_2;
        int length = chinese.length();
        int result = 0;
        int section = 0;
        int number = 0;
        ChineseUnit unit = null;
        for (int i = 0; i < length; ++i) {
            char c = chinese.charAt(i);
            int num = NumberChineseFormatter.chineseToNumber(c);
            if (num >= 0) {
                if (num == 0) {
                    if (number > 0 && unit != null) {
                        section += number * (unit.value / 10);
                    }
                    unit = null;
                } else if (number > 0) {
                    throw new IllegalArgumentException(StrUtil.format("Bad number '{}{}' at: {}", Character.valueOf(chinese.charAt(i - 1)), Character.valueOf(c), i));
                }
                number = num;
                continue;
            }
            unit = NumberChineseFormatter.chineseToUnit(c);
            if (unit == null) {
                throw new IllegalArgumentException(StrUtil.format("Unknown unit '{}' at: {}", Character.valueOf(c), i));
            }
            if (unit.secUnit) {
                section = (section + number) * unit.value;
                result += section;
                section = 0;
            } else {
                int unitNumber = number;
                if (number == 0 && i == 0) {
                    unitNumber = 1;
                }
                section += unitNumber * unit.value;
            }
            number = 0;
        }
        if (number > 0 && unit != null) {
            number *= unit.value / 10;
        }
        return (int)(var2_2 + var3_3 + number);
    }

    private static ChineseUnit chineseToUnit(char chinese) {
        ChineseUnit[] chineseUnitArray = CHINESE_NAME_VALUE;
        int n = CHINESE_NAME_VALUE.length;
        for (int i = 0; i < n; ++i) {
            ChineseUnit chineseNameValue = chineseUnitArray[i];
            if (chineseNameValue.name != chinese) continue;
            return chineseNameValue;
        }
        return null;
    }

    private static int chineseToNumber(char chinese) {
        char c;
        if ('\u4e24' == chinese) {
            chinese = (char)20108;
        }
        int n = ArrayUtil.indexOf(DIGITS, chinese);
        char i = (char)n;
        if (n > 0) {
            return (i + '\u0001') / 2;
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    private static char numberToChinese(int number, boolean isUseTraditional) {
        void var1_1;
        int n;
        if (number == 0) {
            return DIGITS[0];
        }
        return DIGITS[(n << 1) - (var1_1 != false ? 0 : 1)];
    }

    /*
     * WARNING - void declaration
     */
    private static String getUnitName(int index, boolean isUseTraditional) {
        void var1_1;
        int n;
        if (index == 0) {
            return "";
        }
        return String.valueOf(CHINESE_NAME_VALUE[(n << 1) - (var1_1 != false ? 0 : 1)].name);
    }

    /*
     * WARNING - void declaration
     */
    private static void addPreZero(StringBuilder chineseStr) {
        void var1_1;
        if (StrUtil.isEmpty(chineseStr)) {
            return;
        }
        char c = chineseStr.charAt(0);
        if (38646 != var1_1) {
            StringBuilder stringBuilder;
            stringBuilder.insert(0, '\u96f6');
        }
    }

    private static class ChineseUnit {
        private final char name;
        private final int value;
        private final boolean secUnit;

        /*
         * WARNING - void declaration
         */
        public ChineseUnit(char name, int value, boolean secUnit) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.value = var2_2;
            this.secUnit = var3_3;
        }
    }
}

