/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.convert.BasicType;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.convert.NumberChineseFormatter;
import cn.hutool.core.convert.NumberWordFormatter;
import cn.hutool.core.convert.impl.CollectionConverter;
import cn.hutool.core.convert.impl.EnumConverter;
import cn.hutool.core.convert.impl.MapConverter;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.text.UnicodeUtil;
import cn.hutool.core.util.ByteUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Convert {
    /*
     * WARNING - void declaration
     */
    public static String toStr(Object value, String defaultValue) {
        void var1_1;
        Object object;
        return (String)Convert.convertQuietly(String.class, object, var1_1);
    }

    public static String toStr(Object value) {
        return Convert.toStr(value, null);
    }

    public static String[] toStrArray(Object value) {
        Object object;
        return Convert.convert(String[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Character toChar(Object value, Character defaultValue) {
        void var1_1;
        Object object;
        return (Character)Convert.convertQuietly(Character.class, object, var1_1);
    }

    public static Character toChar(Object value) {
        return Convert.toChar(value, null);
    }

    public static Character[] toCharArray(Object value) {
        Object object;
        return Convert.convert(Character[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Byte toByte(Object value, Byte defaultValue) {
        void var1_1;
        Object object;
        return (Byte)Convert.convertQuietly(Byte.class, object, var1_1);
    }

    public static Byte toByte(Object value) {
        return Convert.toByte(value, null);
    }

    public static Byte[] toByteArray(Object value) {
        Object object;
        return Convert.convert(Byte[].class, object);
    }

    public static byte[] toPrimitiveByteArray(Object value) {
        Object object;
        return Convert.convert(byte[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Short toShort(Object value, Short defaultValue) {
        void var1_1;
        Object object;
        return (Short)Convert.convertQuietly(Short.class, object, var1_1);
    }

    public static Short toShort(Object value) {
        return Convert.toShort(value, null);
    }

    public static Short[] toShortArray(Object value) {
        Object object;
        return Convert.convert(Short[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Number toNumber(Object value, Number defaultValue) {
        void var1_1;
        Object object;
        return (Number)Convert.convertQuietly(Number.class, object, var1_1);
    }

    public static Number toNumber(Object value) {
        return Convert.toNumber(value, null);
    }

    public static Number[] toNumberArray(Object value) {
        Object object;
        return Convert.convert(Number[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Integer toInt(Object value, Integer defaultValue) {
        void var1_1;
        Object object;
        return (Integer)Convert.convertQuietly(Integer.class, object, var1_1);
    }

    public static Integer toInt(Object value) {
        return Convert.toInt(value, null);
    }

    public static Integer[] toIntArray(Object value) {
        Object object;
        return Convert.convert(Integer[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Long toLong(Object value, Long defaultValue) {
        void var1_1;
        Object object;
        return (Long)Convert.convertQuietly(Long.class, object, var1_1);
    }

    public static Long toLong(Object value) {
        return Convert.toLong(value, null);
    }

    public static Long[] toLongArray(Object value) {
        Object object;
        return Convert.convert(Long[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Double toDouble(Object value, Double defaultValue) {
        void var1_1;
        Object object;
        return (Double)Convert.convertQuietly(Double.class, object, var1_1);
    }

    public static Double toDouble(Object value) {
        return Convert.toDouble(value, null);
    }

    public static Double[] toDoubleArray(Object value) {
        Object object;
        return Convert.convert(Double[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Float toFloat(Object value, Float defaultValue) {
        void var1_1;
        Object object;
        return (Float)Convert.convertQuietly(Float.class, object, var1_1);
    }

    public static Float toFloat(Object value) {
        return Convert.toFloat(value, null);
    }

    public static Float[] toFloatArray(Object value) {
        Object object;
        return Convert.convert(Float[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean toBool(Object value, Boolean defaultValue) {
        void var1_1;
        Object object;
        return (Boolean)Convert.convertQuietly(Boolean.class, object, var1_1);
    }

    public static Boolean toBool(Object value) {
        return Convert.toBool(value, null);
    }

    public static Boolean[] toBooleanArray(Object value) {
        Object object;
        return Convert.convert(Boolean[].class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        void var1_1;
        Object object;
        return (BigInteger)Convert.convertQuietly(BigInteger.class, object, var1_1);
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        void var1_1;
        Object object;
        return (BigDecimal)Convert.convertQuietly(BigDecimal.class, object, var1_1);
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Date toDate(Object value, Date defaultValue) {
        void var1_1;
        Object object;
        return (Date)Convert.convertQuietly(Date.class, object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static LocalDateTime toLocalDateTime(Object value, LocalDateTime defaultValue) {
        void var1_1;
        Object object;
        return (LocalDateTime)Convert.convertQuietly(LocalDateTime.class, object, var1_1);
    }

    public static LocalDateTime toLocalDateTime(Object value) {
        return Convert.toLocalDateTime(value, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Date toInstant(Object value, Date defaultValue) {
        void var1_1;
        Object object;
        return (Date)Convert.convertQuietly(Instant.class, object, var1_1);
    }

    public static Date toDate(Object value) {
        return Convert.toDate(value, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        void var2_2;
        void var1_1;
        Class<E> clazz2;
        return (E)((Enum)new EnumConverter(clazz2).convertQuietly(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        void var1_1;
        return Convert.toEnum(clazz, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<?> toCollection(Class<?> collectionType, Class<?> elementType, Object value) {
        void var2_2;
        void var1_1;
        Class<?> clazz;
        return new CollectionConverter(clazz, (Type)var1_1).convert((Object)var2_2, null);
    }

    public static List<?> toList(Object value) {
        Object object;
        return Convert.convert(List.class, object);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> toList(Class<T> elementType, Object value) {
        void var1_1;
        Class<T> clazz;
        return (List)Convert.toCollection(ArrayList.class, clazz, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Set<T> toSet(Class<T> elementType, Object value) {
        void var1_1;
        Class<T> clazz;
        return (Set)Convert.toCollection(HashSet.class, clazz, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType, Object value) {
        void var2_2;
        void var1_1;
        Class<K> clazz;
        if (value instanceof Map) {
            return Convert.toMap(value.getClass(), keyType, valueType, value);
        }
        return Convert.toMap(HashMap.class, clazz, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Class<? extends Map> clazz;
        return new MapConverter(clazz, (Type)var1_1, (Type)var2_2).convert(var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convertByClassName(String className, Object value) throws ConvertException {
        void var1_1;
        return Convert.convert(ClassUtil.loadClass(className), (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convert(Class<T> type, Object value) throws ConvertException {
        void var1_1;
        return Convert.convert(type, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convert(TypeReference<T> reference, Object value) throws ConvertException {
        void var1_1;
        return Convert.convert(reference.getType(), (Object)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convert(Type type, Object value) throws ConvertException {
        void var1_1;
        return Convert.convert(type, (Object)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        void var2_2;
        void var1_1;
        return Convert.convert(type, (Object)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        void var2_2;
        void var1_1;
        return Convert.convertWithCheck(type, var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convertQuietly(Type type, Object value) {
        void var1_1;
        return Convert.convertQuietly(type, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.convertWithCheck(type, var1_1, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T convertWithCheck(Type type, Object value, T defaultValue, boolean quietly) {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        try {
            void var1_2;
            return registry.convert(type, var1_2, defaultValue);
        }
        catch (Exception e) {
            void var0_1;
            void var3_4;
            if (var3_4 != false) {
                void var2_3;
                return var2_3;
            }
            throw var0_1;
        }
    }

    public static String toSBC(String input) {
        return Convert.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        Object object;
        if (StrUtil.isEmpty(input)) {
            return input;
        }
        Object c = input.toCharArray();
        for (int i = 0; i < ((Object)c).length; ++i) {
            if (notConvertSet != null && notConvertSet.contains(Character.valueOf((char)c[i]))) continue;
            if (c[i] == 32) {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= 127) continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String((char[])object);
    }

    public static String toDBC(String input) {
        return Convert.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        Object object;
        if (StrUtil.isBlank(text)) {
            return text;
        }
        Object c = text.toCharArray();
        for (int i = 0; i < ((Object)c).length; ++i) {
            if (notConvertSet != null && notConvertSet.contains(Character.valueOf((char)c[i]))) continue;
            if (c[i] == 12288 || c[i] == 160 || c[i] == 8199 || c[i] == 8239) {
                c[i] = 32;
                continue;
            }
            if (c[i] <= 65280 || c[i] >= 65375) continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String((char[])object);
    }

    /*
     * WARNING - void declaration
     */
    public static String toHex(String str, Charset charset) {
        void var1_1;
        return HexUtil.encodeHexStr(str, (Charset)var1_1);
    }

    public static String toHex(byte[] bytes) {
        return HexUtil.encodeHexStr(bytes);
    }

    public static byte[] hexToBytes(String src) {
        return HexUtil.decodeHex(src.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public static String hexToStr(String hexStr, Charset charset) {
        void var1_1;
        return HexUtil.decodeHexStr(hexStr, (Charset)var1_1);
    }

    public static String strToUnicode(String strText) {
        return UnicodeUtil.toUnicode(strText);
    }

    public static String unicodeToStr(String unicode) {
        return UnicodeUtil.toString(unicode);
    }

    /*
     * WARNING - void declaration
     */
    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        void var2_2;
        void var1_1;
        String string;
        if (StrUtil.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        return CharsetUtil.convert(string, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long convertTime(long sourceDuration, TimeUnit sourceUnit, TimeUnit destUnit) {
        void var2_1;
        long l;
        void var3_2;
        Assert.notNull(sourceUnit, "sourceUnit is null !", new Object[0]);
        Assert.notNull(destUnit, "destUnit is null !", new Object[0]);
        return var3_2.convert(l, (TimeUnit)var2_1);
    }

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class<?> unWrap(Class<?> clazz) {
        return BasicType.unWrap(clazz);
    }

    public static String numberToWord(Number number) {
        return NumberWordFormatter.format(number);
    }

    public static String numberToSimple(Number number) {
        return NumberWordFormatter.formatSimple(number.longValue());
    }

    /*
     * WARNING - void declaration
     */
    public static String numberToChinese(double number, boolean isUseTraditional) {
        void var2_1;
        return NumberChineseFormatter.format(number, (boolean)var2_1);
    }

    public static int chineseToNumber(String number) {
        return NumberChineseFormatter.chineseToNumber(number);
    }

    public static String digitToChinese(Number n) {
        Number number;
        if (n == null) {
            return "\u96f6";
        }
        return NumberChineseFormatter.format(number.doubleValue(), true, true);
    }

    public static BigDecimal chineseMoneyToNumber(String chineseMoneyAmount) {
        return NumberChineseFormatter.chineseMoneyToNumber(chineseMoneyAmount);
    }

    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes) {
        return ByteUtil.bytesToShort(bytes);
    }

    public static byte[] shortToBytes(short shortValue) {
        return ByteUtil.shortToBytes(shortValue);
    }

    public static int bytesToInt(byte[] bytes) {
        return ByteUtil.bytesToInt(bytes);
    }

    public static byte[] intToBytes(int intValue) {
        return ByteUtil.intToBytes(intValue);
    }

    public static byte[] longToBytes(long longValue) {
        return ByteUtil.longToBytes(longValue);
    }

    public static long bytesToLong(byte[] bytes) {
        return ByteUtil.bytesToLong(bytes);
    }
}

