/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.convert.Converter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Map;

public abstract class AbstractConverter<T>
implements Converter<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    public T convertQuietly(Object value, T defaultValue) {
        try {
            void var1_1;
            return this.convert(var1_1, defaultValue);
        }
        catch (Exception exception) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T convert(Object value, T defaultValue) {
        void var3_3;
        void var2_2;
        Class<Object> targetType = this.getTargetType();
        if (targetType == null && defaultValue == null) {
            throw new NullPointerException(StrUtil.format("[type] and [defaultValue] are both null for Converter [{}], we can not know what type to convert !", this.getClass().getName()));
        }
        if (targetType == null) {
            targetType = defaultValue.getClass();
        }
        if (value == null) {
            return defaultValue;
        }
        if (defaultValue == null || targetType.isInstance(defaultValue)) {
            void var1_1;
            if (targetType.isInstance(value) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value);
            }
            T result = this.convertInternal(value);
            if (result == null) {
                return defaultValue;
            }
            return var1_1;
        }
        throw new IllegalArgumentException(StrUtil.format("Default value [{}]({}) is not the instance of [{}]", defaultValue, var2_2.getClass(), var3_3));
    }

    protected abstract T convertInternal(Object var1);

    /*
     * WARNING - void declaration
     */
    protected String convertToStr(Object value) {
        void var1_1;
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayUtil.isArray(value)) {
            return ArrayUtil.toString(value);
        }
        if (CharUtil.isChar(value)) {
            return CharUtil.toString(((Character)value).charValue());
        }
        return var1_1.toString();
    }

    public Class<T> getTargetType() {
        return ClassUtil.getTypeArgument(this.getClass());
    }
}

