/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compress;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream out;

    /*
     * WARNING - void declaration
     */
    public static ZipWriter of(File zipFile, Charset charset) {
        void var1_1;
        File file;
        return new ZipWriter(file, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ZipWriter of(OutputStream out, Charset charset) {
        void var1_1;
        OutputStream outputStream;
        return new ZipWriter(outputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ZipWriter(File zipFile, Charset charset) {
        void var2_2;
        void var1_1;
        this.out = ZipWriter.getZipOutputStream((File)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ZipWriter(OutputStream out, Charset charset) {
        void var2_2;
        void var1_1;
        this.out = ZipUtil.getZipOutputStream((OutputStream)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ZipWriter(ZipOutputStream out) {
        void var1_1;
        this.out = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ZipWriter setLevel(int level) {
        void var1_1;
        this.out.setLevel((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ZipWriter setComment(String comment) {
        void var1_1;
        this.out.setComment((String)var1_1);
        return this;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    /*
     * WARNING - void declaration
     */
    public ZipWriter add(boolean withSrcDir, FileFilter filter, File ... files) throws IORuntimeException {
        File[] fileArray = files;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            String srcRootDir;
            File file = fileArray[i];
            try {
                srcRootDir = file.getCanonicalPath();
                if (!file.isDirectory() || withSrcDir) {
                    srcRootDir = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e) {
                void var1_2;
                throw new IORuntimeException((Throwable)var1_2);
            }
            this._add(file, srcRootDir, filter);
        }
        return this;
    }

    public ZipWriter add(Resource ... resources) throws IORuntimeException {
        Resource[] resourceArray = resources;
        int n = resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            if (resource == null) continue;
            this.add(resource.getName(), resource.getStream());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ZipWriter add(String path, InputStream in) throws IORuntimeException {
        void var2_2;
        void var1_1;
        path = StrUtil.nullToEmpty(path);
        if (in == null && StrUtil.isBlank(path = StrUtil.addSuffixIfNot(path, "/"))) {
            return this;
        }
        return this.putEntry((String)var1_1, (InputStream)var2_2);
    }

    public ZipWriter add(String[] paths, InputStream[] ins) throws IORuntimeException {
        if (ArrayUtil.isEmpty(paths) || ArrayUtil.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        for (int i = 0; i < paths.length; ++i) {
            this.add(paths[i], ins[i]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws IORuntimeException {
        try {
            this.out.finish();
            return;
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
        finally {
            IoUtil.close(this.out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        void var1_1;
        return ZipUtil.getZipOutputStream(FileUtil.getOutputStream(zipFile), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ZipWriter _add(File file, String srcRootDir, FileFilter filter) throws IORuntimeException {
        void var1_1;
        if (file == null || filter != null && !filter.accept(file)) {
            return this;
        }
        String subPath = FileUtil.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayUtil.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (void childFile : var1_1) {
                    this._add((File)childFile, srcRootDir, filter);
                }
            }
        } else {
            this.putEntry(subPath, FileUtil.getInputStream((File)var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ZipWriter putEntry(String path, InputStream in) throws IORuntimeException {
        try {
            this.out.putNextEntry(new ZipEntry(path));
            if (in != null) {
                IoUtil.copy(in, this.out);
            }
            this.out.closeEntry();
        }
        catch (IOException e) {
            try {
                void var1_2;
                throw new IORuntimeException((Throwable)var1_2);
            }
            catch (Throwable throwable) {
                void var2_4;
                IoUtil.close((Closeable)var2_4);
                throw throwable;
            }
        }
        IoUtil.close(in);
        IoUtil.flush(this.out);
        return this;
    }
}

