/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compress;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipReader
implements Closeable {
    private static final int DEFAULT_MAX_SIZE_DIFF = 100;
    private ZipFile zipFile;
    private ZipInputStream in;
    private int maxSizeDiff = 100;

    /*
     * WARNING - void declaration
     */
    public static ZipReader of(File zipFile, Charset charset) {
        void var1_1;
        File file;
        return new ZipReader(file, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ZipReader of(InputStream in, Charset charset) {
        void var1_1;
        InputStream inputStream;
        return new ZipReader(inputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ZipReader(File zipFile, Charset charset) {
        void var2_2;
        void var1_1;
        this.zipFile = ZipUtil.toZipFile((File)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ZipReader(ZipFile zipFile) {
        void var1_1;
        this.zipFile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ZipReader(InputStream in, Charset charset) {
        void var2_2;
        void var1_1;
        this.in = new ZipInputStream((InputStream)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ZipReader(ZipInputStream zin) {
        void var1_1;
        this.in = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ZipReader setMaxSizeDiff(int maxSizeDiff) {
        void var1_1;
        this.maxSizeDiff = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream get(String path) {
        void var1_1;
        if (this.zipFile != null) {
            ZipFile zipFile = this.zipFile;
            ZipEntry entry = zipFile.getEntry(path);
            if (entry != null) {
                return ZipUtil.getStream(zipFile, (ZipEntry)var1_1);
            }
        } else {
            try {
                ZipEntry zipEntry;
                while (null != (zipEntry = this.in.getNextEntry())) {
                    if (!zipEntry.getName().equals(var1_1)) continue;
                    return this.in;
                }
            }
            catch (IOException e) {
                void var2_4;
                throw new IORuntimeException((Throwable)var2_4);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public File readTo(File outFile) throws IORuntimeException {
        void var1_1;
        return this.readTo((File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public File readTo(File outFile, Filter<ZipEntry> entryFilter) throws IORuntimeException {
        void var1_1;
        void var2_2;
        ZipReader zipReader = this;
        zipReader.read(arg_0 -> zipReader.lambda$readTo$0((Filter)var2_2, outFile, arg_0));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ZipReader read(Consumer<ZipEntry> consumer) throws IORuntimeException {
        if (this.zipFile != null) {
            this.readFromZipFile(consumer);
        } else {
            void var1_1;
            this.readFromStream((Consumer<ZipEntry>)var1_1);
        }
        return this;
    }

    @Override
    public void close() throws IORuntimeException {
        if (this.zipFile != null) {
            IoUtil.close(this.zipFile);
            return;
        }
        IoUtil.close(this.in);
    }

    private void readFromZipFile(Consumer<ZipEntry> consumer) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(this.checkZipBomb(em.nextElement()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readFromStream(Consumer<ZipEntry> consumer) throws IORuntimeException {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
                this.checkZipBomb(zipEntry);
            }
            return;
        }
        catch (IOException e) {
            void var2_3;
            throw new IORuntimeException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ZipEntry checkZipBomb(ZipEntry entry) {
        void var1_1;
        if (this.maxSizeDiff < 0) {
            return entry;
        }
        if (entry == null) {
            return null;
        }
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L || compressedSize * (long)this.maxSizeDiff < uncompressedSize) {
            void var2_2;
            throw new UtilException("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", (long)var2_2, uncompressedSize, entry.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$readTo$0(Filter entryFilter, File outFile, ZipEntry zipEntry) {
        if (entryFilter == null || entryFilter.accept(zipEntry)) {
            void var1_1;
            void var2_2;
            void var3_3;
            String path = zipEntry.getName();
            if (FileUtil.isWindows()) {
                path = StrUtil.replace((CharSequence)path, (CharSequence)"*", "_");
            }
            File outItemFile = FileUtil.file(outFile, path);
            if (zipEntry.isDirectory()) {
                outItemFile.mkdirs();
                return;
            }
            InputStream in = this.zipFile != null ? ZipUtil.getStream(this.zipFile, (ZipEntry)var3_3) : this.in;
            FileUtil.writeFromStream((InputStream)var2_2, (File)var1_1, false);
        }
    }
}

