/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compress;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class ZipCopyVisitor
extends SimpleFileVisitor<Path> {
    private final Path source;
    private final FileSystem fileSystem;
    private final CopyOption[] copyOptions;

    /*
     * WARNING - void declaration
     */
    public ZipCopyVisitor(Path source, FileSystem fileSystem, CopyOption ... copyOptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.source = var1_1;
        this.fileSystem = var2_2;
        this.copyOptions = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        block4: {
            Path targetDir = this.resolveTarget(dir);
            if (StrUtil.isNotEmpty(targetDir.toString())) {
                try {
                    Files.copy(dir, targetDir, this.copyOptions);
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {
                }
                catch (FileAlreadyExistsException e) {
                    void var1_2;
                    void var2_3;
                    if (Files.isDirectory((Path)var2_3, new LinkOption[0])) break block4;
                    throw var1_2;
                }
            }
        }
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        void var1_1;
        Files.copy(file, this.resolveTarget((Path)var1_1), this.copyOptions);
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    private Path resolveTarget(Path file) {
        void var1_1;
        return this.fileSystem.getPath(this.source.relativize((Path)var1_1).toString(), new String[0]);
    }
}

