/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compiler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.compiler.CompilerException;
import cn.hutool.core.compiler.CompilerUtil;
import cn.hutool.core.compiler.DiagnosticUtil;
import cn.hutool.core.compiler.JavaClassFileManager;
import cn.hutool.core.compiler.JavaFileObjectUtil;
import cn.hutool.core.compiler.JavaSourceFileObject;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.StringResource;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaSourceCompiler {
    private final List<Resource> sourceList = new ArrayList<Resource>();
    private final List<File> libraryFileList = new ArrayList<File>();
    private final ClassLoader parentClassLoader;

    public static JavaSourceCompiler create(ClassLoader parent) {
        ClassLoader classLoader;
        return new JavaSourceCompiler(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private JavaSourceCompiler(ClassLoader parent) {
        void var1_1;
        this.parentClassLoader = ObjectUtil.defaultIfNull(var1_1, ClassLoaderUtil::getClassLoader);
    }

    /*
     * WARNING - void declaration
     */
    public JavaSourceCompiler addSource(Resource ... resources) {
        if (ArrayUtil.isNotEmpty(resources)) {
            void var1_1;
            this.sourceList.addAll(Arrays.asList(var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JavaSourceCompiler addSource(File ... files) {
        if (ArrayUtil.isNotEmpty(files)) {
            void var1_1;
            for (void file : var1_1) {
                this.sourceList.add(new FileResource((File)file));
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JavaSourceCompiler addSource(Map<String, String> sourceCodeMap) {
        if (MapUtil.isNotEmpty(sourceCodeMap)) {
            void var1_1;
            var1_1.forEach(this::addSource);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JavaSourceCompiler addSource(String className, String sourceCode) {
        if (className != null && sourceCode != null) {
            void var1_1;
            void var2_2;
            this.sourceList.add(new StringResource((String)var2_2, (String)var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JavaSourceCompiler addLibrary(File ... files) {
        if (ArrayUtil.isNotEmpty(files)) {
            void var1_1;
            this.libraryFileList.addAll(Arrays.asList(var1_1));
        }
        return this;
    }

    public ClassLoader compile() {
        return this.compile(null);
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoader compile(List<String> options) {
        void var2_3;
        JavaClassFileManager javaFileManager;
        block5: {
            ClassLoader classLoader;
            List<File> classPath = this.getClassPath();
            URL[] uRLArray = URLUtil.getURLs(classPath.toArray(new File[0]));
            URLClassLoader ucl = URLClassLoader.newInstance(uRLArray, this.parentClassLoader);
            if (this.sourceList.isEmpty()) {
                return ucl;
            }
            javaFileManager = new JavaClassFileManager(ucl, CompilerUtil.getFileManager());
            if (options == null) {
                options = new ArrayList<String>();
            }
            if (!classPath.isEmpty()) {
                List<String> cp = CollUtil.map(classPath, File::getAbsolutePath, true);
                options.add("-cp");
                options.add(CollUtil.join(cp, (CharSequence)(FileUtil.isWindows() ? ";" : ":")));
            }
            DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
            List<JavaFileObject> javaFileObjectList = this.getJavaFileObject();
            JavaCompiler.CompilationTask task = CompilerUtil.getTask(javaFileManager, diagnosticCollector, options, javaFileObjectList);
            try {
                if (!classLoader.call().booleanValue()) break block5;
                classLoader = javaFileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
            }
            catch (Throwable throwable) {
                IoUtil.close((Closeable)uRLArray);
                throw throwable;
            }
            IoUtil.close(javaFileManager);
            return classLoader;
        }
        IoUtil.close(javaFileManager);
        throw new CompilerException(DiagnosticUtil.getMessages(var2_3));
    }

    /*
     * WARNING - void declaration
     */
    private List<File> getClassPath() {
        void var1_1;
        ArrayList<Object> classPathFileList = new ArrayList<Object>();
        for (File file : this.libraryFileList) {
            void var3_3;
            List<File> jarOrZipFile = FileUtil.loopFiles(file, subFile -> JavaFileObjectUtil.isJarOrZipFile(subFile.getName()));
            classPathFileList.addAll(jarOrZipFile);
            if (!file.isDirectory()) continue;
            classPathFileList.add(var3_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<JavaFileObject> getJavaFileObject() {
        void var1_1;
        ArrayList<JavaSourceFileObject> list = new ArrayList<JavaSourceFileObject>();
        for (Resource resource : this.sourceList) {
            if (resource instanceof FileResource) {
                File file = ((FileResource)resource).getFile();
                FileUtil.walkFiles(file, subFile -> {
                    void var1_1;
                    list.addAll(JavaFileObjectUtil.getJavaFileObjects((File)var1_1));
                });
                continue;
            }
            list.add(new JavaSourceFileObject(resource.getName(), resource.getStream()));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<JavaFileObject> getJavaFileObjectByMap(Map<String, String> sourceCodeMap) {
        if (MapUtil.isNotEmpty(sourceCodeMap)) {
            void var1_1;
            return var1_1.entrySet().stream().map(entry -> {
                Map.Entry entry2;
                return new JavaSourceFileObject((String)entry.getKey(), (String)entry2.getValue(), CharsetUtil.CHARSET_UTF_8);
            }).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private JavaFileObject getJavaFileObjectByJavaFile(File file) {
        void var1_1;
        return new JavaSourceFileObject(var1_1.toURI());
    }
}

