/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.lang.Chain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ComparatorChain<E>
implements Chain<Comparator<E>, ComparatorChain<E>>,
Serializable,
Comparator<E> {
    private static final long serialVersionUID = -2426725788913962429L;
    private final List<Comparator<E>> chain;
    private final BitSet orderingBits;
    private boolean lock = false;

    public static <E> ComparatorChain<E> of(Comparator<E> comparator) {
        return ComparatorChain.of(comparator, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ComparatorChain<E> of(Comparator<E> comparator, boolean reverse) {
        void var1_1;
        Comparator<E> comparator2;
        return new ComparatorChain<E>(comparator2, (boolean)var1_1);
    }

    @SafeVarargs
    public static <E> ComparatorChain<E> of(Comparator<E> ... comparators) {
        return ComparatorChain.of(Arrays.asList(comparators));
    }

    public static <E> ComparatorChain<E> of(List<Comparator<E>> comparators) {
        List<Comparator<E>> list;
        return new ComparatorChain<E>(list);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ComparatorChain<E> of(List<Comparator<E>> comparators, BitSet bits) {
        void var1_1;
        List<Comparator<E>> list;
        return new ComparatorChain<E>(list, (BitSet)var1_1);
    }

    public ComparatorChain() {
        this(new ArrayList<Comparator<E>>(), new BitSet());
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain(Comparator<E> comparator) {
        this((Comparator<E>)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain(Comparator<E> comparator, boolean reverse) {
        void var2_2;
        void var1_1;
        this.chain = new ArrayList<Comparator<E>>(1);
        this.chain.add((Comparator<void>)var1_1);
        this.orderingBits = new BitSet(1);
        if (var2_2 == true) {
            this.orderingBits.set(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain(List<Comparator<E>> list) {
        this(list, new BitSet(var1_1.size()));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain(List<Comparator<E>> list, BitSet bits) {
        void var2_2;
        void var1_1;
        this.chain = var1_1;
        this.orderingBits = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain<E> addComparator(Comparator<E> comparator) {
        void var1_1;
        return this.addComparator((Comparator<E>)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain<E> addComparator(Comparator<E> comparator, boolean reverse) {
        void var2_2;
        void var1_1;
        this.checkLocked();
        this.chain.add((Comparator<void>)var1_1);
        if (var2_2 == true) {
            this.orderingBits.set(this.chain.size() - 1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain<E> setComparator(int index, Comparator<E> comparator) throws IndexOutOfBoundsException {
        void var2_2;
        void var1_1;
        return this.setComparator((int)var1_1, (Comparator<E>)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain<E> setComparator(int index, Comparator<E> comparator, boolean reverse) {
        void var3_3;
        void var2_2;
        this.checkLocked();
        this.chain.set(index, (Comparator<void>)var2_2);
        if (var3_3 == true) {
            this.orderingBits.set(index);
        } else {
            void var1_1;
            this.orderingBits.clear((int)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain<E> setForwardSort(int index) {
        void var1_1;
        this.checkLocked();
        this.orderingBits.clear((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ComparatorChain<E> setReverseSort(int index) {
        void var1_1;
        this.checkLocked();
        this.orderingBits.set((int)var1_1);
        return this;
    }

    public int size() {
        return this.chain.size();
    }

    public boolean isLocked() {
        return this.lock;
    }

    @Override
    public Iterator<Comparator<E>> iterator() {
        return this.chain.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ComparatorChain<E> addChain(Comparator<E> element) {
        void var1_1;
        return this.addComparator((Comparator<E>)var1_1);
    }

    @Override
    public int compare(E o1, E o2) throws UnsupportedOperationException {
        if (!this.lock) {
            this.checkChainIntegrity();
            this.lock = true;
        }
        Iterator<Comparator<E>> comparators = this.chain.iterator();
        int comparatorIndex = 0;
        while (comparators.hasNext()) {
            Comparator<E> comparator = comparators.next();
            int retval = comparator.compare(o1, o2);
            if (retval != 0) {
                if (this.orderingBits.get(comparatorIndex)) {
                    retval = retval > 0 ? -1 : 1;
                }
                return retval;
            }
            ++comparatorIndex;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int hash = 0;
        if (this.chain != null) {
            hash = 0 ^ this.chain.hashCode();
        }
        if (this.orderingBits != null) {
            hash ^= this.orderingBits.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            void var1_1;
            ComparatorChain otherChain = (ComparatorChain)object;
            return Objects.equals(this.orderingBits, otherChain.orderingBits) && this.chain.equals(var1_1.chain);
        }
        return false;
    }

    private void checkLocked() {
        if (this.lock) {
            throw new UnsupportedOperationException("Comparator ordering cannot be changed after the first comparison is performed");
        }
    }

    private void checkChainIntegrity() {
        if (this.chain.size() == 0) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }
}

