/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.AvgPartition;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.Partition;
import cn.hutool.core.collection.RandomAccessAvgPartition;
import cn.hutool.core.collection.RandomAccessPartition;
import cn.hutool.core.comparator.PinyinComparator;
import cn.hutool.core.comparator.PropertyComparator;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class ListUtil {
    public static <T> List<T> list(boolean isLinked) {
        if (isLinked) {
            return new LinkedList();
        }
        return new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        void var0_1;
        void var1_2;
        if (ArrayUtil.isEmpty(values)) {
            return ListUtil.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, var1_2);
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        void var1_1;
        boolean bl;
        if (collection == null) {
            return ListUtil.list(isLinked);
        }
        if (bl) {
            return new LinkedList<T>(collection);
        }
        return new ArrayList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        void var1_1;
        boolean bl;
        if (iterable == null) {
            return ListUtil.list(isLinked);
        }
        return ListUtil.list(bl, var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        void var0_1;
        List<T> list = ListUtil.list(isLinked);
        if (iter != null) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumration) {
        void var0_1;
        List<T> list = ListUtil.list(isLinked);
        if (enumration != null) {
            while (enumration.hasMoreElements()) {
                list.add(enumration.nextElement());
            }
        }
        return var0_1;
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        T[] TArray;
        return (ArrayList)ListUtil.list(false, TArray);
    }

    @SafeVarargs
    public static <T> LinkedList<T> toLinkedList(T ... values) {
        T[] TArray;
        return (LinkedList)ListUtil.list(true, TArray);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... ts) {
        T[] TArray;
        if (ArrayUtil.isEmpty(ts)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ListUtil.toList(TArray));
    }

    public static <T> CopyOnWriteArrayList<T> toCopyOnWriteArrayList(Collection<T> collection) {
        Collection<T> collection2;
        if (collection == null) {
            return new CopyOnWriteArrayList();
        }
        return new CopyOnWriteArrayList<T>(collection2);
    }

    public static <T> ArrayList<T> toList(Collection<T> collection) {
        Collection<T> collection2;
        return (ArrayList)ListUtil.list(false, collection2);
    }

    public static <T> ArrayList<T> toList(Iterable<T> iterable) {
        Iterable<T> iterable2;
        return (ArrayList)ListUtil.list(false, iterable2);
    }

    public static <T> ArrayList<T> toList(Iterator<T> iterator) {
        Iterator<T> iterator2;
        return (ArrayList)ListUtil.list(false, iterator2);
    }

    public static <T> ArrayList<T> toList(Enumeration<T> enumeration) {
        Enumeration<T> enumeration2;
        return (ArrayList)ListUtil.list(false, enumeration2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        void var0_1;
        void var2_3;
        void var1_2;
        if (CollUtil.isEmpty(list)) {
            return new ArrayList(0);
        }
        int resultSize = list.size();
        if (resultSize <= pageSize) {
            if (pageNo < PageUtil.getFirstPageNo() + 1) {
                return ListUtil.unmodifiable(list);
            }
            return new ArrayList(0);
        }
        if ((long)(pageNo - PageUtil.getFirstPageNo()) * (long)pageSize > (long)resultSize) {
            return new ArrayList(0);
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, (int)var1_2);
        if (startEnd[1] > resultSize) {
            void var3_4;
            startEnd[1] = var3_4;
            if (startEnd[0] > startEnd[1]) {
                return new ArrayList(0);
            }
        }
        return ListUtil.sub(var2_3, startEnd[0], (int)var0_1[1]);
    }

    public static <T> void page(List<T> list, int pageSize, Consumer<List<T>> pageListConsumer) {
        if (CollUtil.isEmpty(list) || pageSize <= 0) {
            return;
        }
        int total = list.size();
        int totalPage = PageUtil.totalPage(total, pageSize);
        for (int pageNo = PageUtil.getFirstPageNo(); pageNo < totalPage + PageUtil.getFirstPageNo(); ++pageNo) {
            int[] startEnd = PageUtil.transToStartEnd(pageNo, pageSize);
            if (startEnd[1] > total) {
                startEnd[1] = total;
            }
            pageListConsumer.accept(ListUtil.sub(list, startEnd[0], startEnd[1]));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        List<T> list2;
        void var1_1;
        if (CollUtil.isEmpty(list)) {
            return list;
        }
        list.sort((Comparator<T>)var1_1);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sortByProperty(List<T> list, String property) {
        void var1_1;
        return ListUtil.sort(list, new PropertyComparator((String)var1_1));
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtil.sort(list, new PinyinComparator());
    }

    public static <T> List<T> reverse(List<T> list) {
        List<T> list2;
        Collections.reverse(list);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> reverseNew(List<T> list) {
        List<T> list2 = ObjectUtil.clone(list);
        if (list2 == null) {
            list2 = new ArrayList<T>(list);
        }
        try {
            void var1_1;
            return ListUtil.reverse(var1_1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            List<T> list3;
            return ListUtil.reverse(ListUtil.list(false, list3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        List<T> list2;
        Assert.notNull(list, "List must be not null !", new Object[0]);
        if (index < list.size()) {
            void var1_1;
            list.set((int)var1_1, element);
        } else {
            void var2_2;
            list.add(var2_2);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> setOrPadding(List<T> list, int index, T element) {
        void var2_2;
        void var1_1;
        return ListUtil.setOrPadding(list, (int)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement) {
        List<T> list2;
        Assert.notNull(list, "List must be not null !", new Object[0]);
        int size = list.size();
        if (index < size) {
            list.set(index, element);
        } else {
            void var2_2;
            Validator.checkIndexLimit(index, list.size());
            for (int i = size; i < index; ++i) {
                list.add(paddingElement);
            }
            list.add(var2_2);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sub(List<T> list, int start, int end) {
        void var2_2;
        void var1_1;
        return ListUtil.sub(list, (int)var1_1, (int)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        void i;
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start == size) {
            return new ArrayList(0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > size) {
            if (start >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step <= 0) {
            step = 1;
        }
        ArrayList<T> result = new ArrayList<T>();
        while (i < end) {
            result.add(list.get((int)i));
            i += step;
        }
        return result;
    }

    public static <T> int lastIndexOf(List<T> list, Matcher<T> matcher) {
        int size;
        if (list != null && (size = list.size()) > 0) {
            for (int i = size - 1; i >= 0; --i) {
                if (matcher != null && !matcher.match(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int[] indexOfAll(List<T> list, Matcher<T> matcher) {
        void var1_1;
        return CollUtil.indexOfAll(list, var1_1);
    }

    public static <T> List<T> unmodifiable(List<T> list) {
        List<T> list2;
        if (list == null) {
            return null;
        }
        return Collections.unmodifiableList(list2);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<List<T>> partition(List<T> list, int size) {
        void var1_1;
        List<T> list2;
        if (CollUtil.isEmpty(list)) {
            return ListUtil.empty();
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessPartition<T>(list, size);
        }
        return new Partition<T>(list2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<List<T>> split(List<T> list, int size) {
        void var1_1;
        return ListUtil.partition(list, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<List<T>> splitAvg(List<T> list, int limit) {
        void var1_1;
        List<T> list2;
        if (CollUtil.isEmpty(list)) {
            return ListUtil.empty();
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessAvgPartition<T>(list, limit);
        }
        return new AvgPartition<T>(list2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void swapTo(List<T> list, T element, Integer targetIndex) {
        int index;
        if (CollUtil.isNotEmpty(list) && (index = list.indexOf(element)) >= 0) {
            void var2_3;
            void var1_2;
            List<T> list2;
            Collections.swap(list2, (int)var1_2, var2_3.intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void swapElement(List<T> list, T element, T targetElement) {
        int targetIndex;
        if (CollUtil.isNotEmpty(list) && (targetIndex = list.indexOf(targetElement)) >= 0) {
            void var2_3;
            void var1_1;
            List<T> list2;
            ListUtil.swapTo(list2, var1_1, (int)var2_3);
        }
    }
}

