/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.collection.FilterIter;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.collection.NodeListIter;
import cn.hutool.core.collection.TransIter;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IterUtil {
    public static <T> Iterator<T> getIter(Iterable<T> iterable) {
        Iterable<T> iterable2;
        if (iterable == null) {
            return null;
        }
        return iterable2.iterator();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        Iterable<?> iterable2;
        return iterable == null || IterUtil.isEmpty(iterable2.iterator());
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        Iterator<?> iterator;
        return Iterator2 == null || false == iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        Iterable<?> iterable2;
        return iterable != null && IterUtil.isNotEmpty(iterable2.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        Iterator<?> iterator;
        return Iterator2 != null && iterator.hasNext();
    }

    public static boolean hasNull(Iterable<?> iter) {
        Iterable<?> iterable;
        return IterUtil.hasNull(iter == null ? null : iterable.iterator());
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (iter == null) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iter) {
        Iterable<?> iterable;
        return IterUtil.isAllNull(iter == null ? null : iterable.iterator());
    }

    public static boolean isAllNull(Iterator<?> iter) {
        Iterator<?> iterator;
        return null == IterUtil.getFirstNoneNull(iterator);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Map<T, Integer> countMap(Iterator<T> iter) {
        void var1_1;
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (iter != null) {
            while (iter.hasNext()) {
                void var2_2;
                T t = iter.next();
                countMap.put(t, countMap.getOrDefault(var2_2, 0) + 1);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iter, String fieldName) {
        void var1_1;
        return IterUtil.toMap(iter, new HashMap(), arg_0 -> IterUtil.lambda$fieldValueMap$a3f4a90f$1((String)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> fieldValueAsMap(Iterator<?> iter, String fieldNameForKey, String fieldNameForValue) {
        void var2_2;
        void var1_1;
        return IterUtil.toMap(iter, new HashMap(), arg_0 -> IterUtil.lambda$fieldValueAsMap$f61513e$1((String)var1_1, arg_0), arg_0 -> IterUtil.lambda$fieldValueAsMap$ceda202c$1((String)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static <V> List<Object> fieldValueList(Iterable<V> iterable, String fieldName) {
        void var1_1;
        return IterUtil.fieldValueList(IterUtil.getIter(iterable), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> List<Object> fieldValueList(Iterator<V> iter, String fieldName) {
        void var2_2;
        ArrayList<Object> result = new ArrayList<Object>();
        if (iter != null) {
            while (iter.hasNext()) {
                void var3_3;
                V value = iter.next();
                result.add(ReflectUtil.getFieldValue((Object)var3_3, fieldName));
            }
        }
        return var2_2;
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        Iterator<T> iterator2;
        return StrJoiner.of(conjunction).append(iterator2).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, String prefix, String suffix) {
        Iterator<T> iterator2;
        void var3_3;
        void var2_2;
        return StrJoiner.of(conjunction, (CharSequence)var2_2, (CharSequence)var3_3).setWrapElement(true).append(iterator2).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        void var2_2;
        Iterator<T> iterator2;
        void var1_1;
        if (iterator == null) {
            return null;
        }
        return StrJoiner.of((CharSequence)var1_1).append(iterator2, var2_2).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        void var1_1;
        HashMap map = new HashMap();
        if (IterUtil.isNotEmpty(entryIter)) {
            Iterator<Map.Entry<K, V>> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Map.Entry entry = (Map.Entry)iterator.next();
                map.put(entry.getKey(), var2_2.getValue());
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        void var1_1;
        return IterUtil.toMap(keys, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values, boolean isOrder) {
        void var2_2;
        void var1_1;
        Iterable<K> iterable;
        return IterUtil.toMap(keys == null ? null : iterable.iterator(), values == null ? null : var1_1.iterator(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        void var1_1;
        return IterUtil.toMap(keys, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values, boolean isOrder) {
        void var2_3;
        HashMap<K, Object> resultMap = MapUtil.newHashMap(isOrder);
        if (IterUtil.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), values != null && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, List<V>> toListMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        void var1_1;
        return IterUtil.toListMap(iterable, var1_1, v -> v);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Map<K, List<V>> toListMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        void var2_2;
        void var1_1;
        Iterable<T> iterable2;
        return IterUtil.toListMap(MapUtil.newHashMap(), iterable2, var1_1, var2_2);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Map<K, List<V>> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        Map<K, List<V>> map;
        Iterator iterator;
        if (resultMap == null) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            resultMap.computeIfAbsent(keyMapper.apply(value), k -> new ArrayList()).add(valueMapper.apply(value));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        void var1_1;
        return IterUtil.toMap(iterable, var1_1, (T v) -> v);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        void var2_2;
        void var1_1;
        Iterable<T> iterable2;
        return IterUtil.toMap(MapUtil.newHashMap(), iterable2, var1_1, var2_2);
    }

    public static <T, K, V> Map<K, V> toMap(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        Map<K, V> map;
        Iterator iterator;
        if (resultMap == null) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return map;
    }

    public static <E> List<E> toList(Iterable<E> iter) {
        Iterable<E> iterable;
        if (iter == null) {
            return null;
        }
        return IterUtil.toList(iterable.iterator());
    }

    public static <E> List<E> toList(Iterator<E> iter) {
        return ListUtil.toList(iter);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        Enumeration<E> enumeration;
        return new EnumerationIter<E>(enumeration);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return () -> iter;
    }

    public static <E> E get(Iterator<E> iterator, int index) throws IndexOutOfBoundsException {
        if (iterator == null) {
            return null;
        }
        Assert.isTrue(index >= 0, "[index] must be >= 0", new Object[0]);
        while (iterator.hasNext()) {
            if (-1 == --index) {
                return iterator.next();
            }
            iterator.next();
        }
        return null;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        List list;
        if (iterable instanceof List) {
            List list2 = (List)iterable;
            if (CollUtil.isEmpty(list2)) {
                return null;
            }
            return (T)list.get(0);
        }
        return IterUtil.getFirst(IterUtil.getIter(list));
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        Iterable<T> iterable2;
        if (iterable == null) {
            return null;
        }
        return IterUtil.getFirstNoneNull(iterable2.iterator());
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return IterUtil.get(iterator, 0);
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator) {
        return (T)IterUtil.firstMatch(iterator, Objects::nonNull);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T firstMatch(Iterator<T> iterator, Matcher<T> matcher) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (iterator != null) {
            while (iterator.hasNext()) {
                void var2_2;
                T next = iterator.next();
                if (!matcher.match(next)) continue;
                return var2_2;
            }
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        return IterUtil.getElementType(IterUtil.getIter(iterable));
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        Iterator<?> iterator2;
        if (iterator == null) {
            return null;
        }
        Iterator<?> ele = IterUtil.getFirstNoneNull(iterator);
        if (ele == null) {
            return null;
        }
        return iterator2.getClass();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> edit(Iterable<T> iter, Editor<T> editor) {
        void var2_2;
        ArrayList<Iterable<T>> result = new ArrayList<Iterable<T>>();
        if (iter == null) {
            return result;
        }
        for (Iterable<T> t : iter) {
            Iterable<T> iterable;
            Iterable<T> modified = editor == null ? t : editor.edit(t);
            if (modified == null) continue;
            result.add(iterable);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Iterable<E>, E> T filter(T iter, Filter<E> filter) {
        T t;
        void var1_1;
        if (iter == null) {
            return null;
        }
        IterUtil.filter(iter.iterator(), var1_1);
        return t;
    }

    public static <E> Iterator<E> filter(Iterator<E> iter, Filter<E> filter) {
        Iterator<E> iterator;
        if (iter == null || filter == null) {
            return iter;
        }
        while (iter.hasNext()) {
            if (filter.accept(iter.next())) continue;
            iter.remove();
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    public static <E> List<E> filterToList(Iterator<E> iter, Filter<E> filter) {
        void var1_1;
        return IterUtil.toList(IterUtil.filtered(iter, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <E> FilterIter<E> filtered(Iterator<? extends E> iterator, Filter<? super E> filter) {
        void var1_1;
        Iterator<? extends E> iterator2;
        return new FilterIter<E>(iterator2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Iterator<V> iterator, Map<K, V> map, Func1<V, K> keyFunc) {
        void var2_2;
        void var1_1;
        return IterUtil.toMap(iterator, var1_1, var2_2, (E value) -> value);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, E> Map<K, V> toMap(Iterator<E> iterator, Map<K, V> map, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        void var1_2;
        if (iterator == null) {
            return map;
        }
        if (map == null) {
            map = MapUtil.newHashMap(true);
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            try {
                map.put(keyFunc.call(element), valueFunc.call(element));
            }
            catch (Exception e) {
                void var0_1;
                throw new UtilException((Throwable)var0_1);
            }
        }
        return var1_2;
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Iterator<T> trans(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        void var1_1;
        Iterator<F> iterator2;
        return new TransIter(iterator2, var1_1);
    }

    public static int size(Iterable<?> iterable) {
        Iterable<?> iterable2;
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IterUtil.size(iterable2.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static int size(Iterator<?> iterator) {
        void var1_1;
        int size = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEqualList(Iterable<?> list1, Iterable<?> list2) {
        void var1_1;
        Iterator<?> iterator;
        if (list1 == list2) {
            return true;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            void var3_3;
            void var2_2;
            Object obj1 = it1.next();
            Object obj2 = it2.next();
            if (Objects.equals(var2_2, var3_3)) continue;
            return false;
        }
        return false == (iterator.hasNext() || var1_1.hasNext());
    }

    public static void clear(Iterator<?> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <E> void forEach(Iterator<E> iterator, Consumer<? super E> consumer) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                void var2_2;
                E element = iterator.next();
                if (consumer == null) continue;
                consumer.accept(var2_2);
            }
        }
    }

    public static <E> String toStr(Iterator<E> iterator) {
        return IterUtil.toStr(iterator, ObjectUtil::toString);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> String toStr(Iterator<E> iterator, Function<? super E, String> transFunc) {
        void var1_1;
        return IterUtil.toStr(iterator, var1_1, ", ", "[", "]");
    }

    /*
     * WARNING - void declaration
     */
    public static <E> String toStr(Iterator<E> iterator, Function<? super E, String> transFunc, String delimiter, String prefix, String suffix) {
        void var2_2;
        void var1_1;
        Iterator<E> iterator2;
        void var3_3;
        StrJoiner strJoiner = StrJoiner.of(delimiter, (CharSequence)var3_3, suffix);
        strJoiner.append(iterator2, var1_1);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator<?> getIter(Object obj) {
        Object object;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (ArrayUtil.isArray(obj)) {
            return new ArrayIter(obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIter((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().iterator();
        }
        if (obj instanceof NodeList) {
            return new NodeListIter((NodeList)obj);
        }
        if (obj instanceof Node) {
            return new NodeListIter(((Node)obj).getChildNodes());
        }
        if (obj instanceof Dictionary) {
            return new EnumerationIter(((Dictionary)obj).elements());
        }
        try {
            Object iterator = ReflectUtil.invoke(obj, "iterator", new Object[0]);
            if (iterator instanceof Iterator) {
                void var1_1;
                return (Iterator)var1_1;
            }
        }
        catch (RuntimeException runtimeException) {}
        return new ArrayIter<Object>(new Object[]{object});
    }

    private static /* synthetic */ Object lambda$fieldValueAsMap$ceda202c$1(String fieldNameForValue, Object value) throws Exception {
        String string;
        return ReflectUtil.getFieldValue(value, string);
    }

    private static /* synthetic */ Object lambda$fieldValueAsMap$f61513e$1(String fieldNameForKey, Object value) throws Exception {
        String string;
        return ReflectUtil.getFieldValue(value, string);
    }

    private static /* synthetic */ Object lambda$fieldValueMap$a3f4a90f$1(String fieldName, Object value) throws Exception {
        String string;
        return ReflectUtil.getFieldValue(value, string);
    }
}

