/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.IteratorEnumeration;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.collection.TransCollection;
import cn.hutool.core.collection.UniqueKeySet;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.comparator.PinyinComparator;
import cn.hutool.core.comparator.PropertyComparator;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.lang.hash.Hash32;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class CollUtil {
    public static <T> Set<T> emptyIfNull(Set<T> set) {
        Set<T> set2;
        if (set == null) {
            return Collections.emptySet();
        }
        return set2;
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        List<T> list2;
        if (list == null) {
            return Collections.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2) {
        void var2_3;
        Iterator iterator;
        if (CollUtil.isEmpty(coll1) && CollUtil.isEmpty(coll2)) {
            return new ArrayList();
        }
        if (CollUtil.isEmpty(coll1)) {
            return new ArrayList<T>(coll2);
        }
        if (CollUtil.isEmpty(coll2)) {
            return new ArrayList<T>(coll1);
        }
        ArrayList list = new ArrayList(Math.max(coll1.size(), coll2.size()));
        Map<T, Integer> map1 = CollUtil.countMap(coll1);
        Map<T, Integer> map2 = CollUtil.countMap(coll2);
        HashSet<T> elts = CollUtil.newHashSet(coll2);
        elts.addAll(coll1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
            for (int i = 0; i < m; ++i) {
                list.add(t);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> collection;
        void var2_2;
        void var1_1;
        Collection<T> union = CollUtil.union(coll1, var1_1);
        for (void coll : var2_2) {
            if (CollUtil.isEmpty(coll)) continue;
            union = CollUtil.union(union, coll);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> Set<T> unionDistinct(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> collection;
        Collection<T> result;
        result = CollUtil.isEmpty(coll1) ? new LinkedHashSet<T>() : new LinkedHashSet<T>(result);
        if (CollUtil.isNotEmpty(coll2)) {
            void var1_1;
            result.addAll((Collection<T>)var1_1);
        }
        if (ArrayUtil.isNotEmpty(otherColls)) {
            void var2_2;
            for (void otherColl : var2_2) {
                if (CollUtil.isEmpty(otherColl)) continue;
                result.addAll((Collection<T>)otherColl);
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> List<T> unionAll(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        void var2_2;
        if (CollUtil.isEmpty(coll1) && CollUtil.isEmpty(coll2) && ArrayUtil.isEmpty(otherColls)) {
            return new ArrayList(0);
        }
        int n = 0 + CollUtil.size(coll1);
        int totalSize = n + CollUtil.size(coll2);
        if (otherColls != null) {
            Collection<T>[] collectionArray = otherColls;
            int n2 = otherColls.length;
            for (int i = 0; i < n2; ++i) {
                Collection<T> otherColl = collectionArray[i];
                totalSize += CollUtil.size(otherColl);
            }
        }
        ArrayList<T> res = new ArrayList<T>(n);
        if (coll1 != null) {
            res.addAll(coll1);
        }
        if (coll2 != null) {
            void var1_1;
            res.addAll((Collection<T>)var1_1);
        }
        if (otherColls == null) {
            return res;
        }
        for (Collection<T> otherColl : var2_2) {
            Collection<T> collection;
            if (otherColl == null) continue;
            res.addAll(collection);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2) {
        if (CollUtil.isNotEmpty(coll1) && CollUtil.isNotEmpty(coll2)) {
            void var2_3;
            ArrayList list = new ArrayList(Math.min(coll1.size(), coll2.size()));
            Map<T, Integer> map1 = CollUtil.countMap(coll1);
            Map<T, Integer> map2 = CollUtil.countMap(coll2);
            coll2 = CollUtil.newHashSet(coll2);
            for (Object t : coll2) {
                int m = Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
            return var2_3;
        }
        return new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> collection;
        void var2_2;
        void var1_1;
        Collection<T> intersection = CollUtil.intersection(coll1, var1_1);
        if (CollUtil.isEmpty(intersection)) {
            return intersection;
        }
        for (void coll : var2_2) {
            if (!CollUtil.isEmpty(intersection = CollUtil.intersection(intersection, coll))) continue;
            return intersection;
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> Set<T> intersectionDistinct(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> collection;
        void var1_1;
        if (CollUtil.isEmpty(coll1) || CollUtil.isEmpty(coll2)) {
            return new LinkedHashSet();
        }
        Collection<T> result = new LinkedHashSet<T>(coll1);
        if (ArrayUtil.isNotEmpty(otherColls)) {
            void var2_2;
            for (void otherColl : var2_2) {
                if (!CollUtil.isNotEmpty(otherColl)) {
                    return new LinkedHashSet();
                }
                result.retainAll((Collection<?>)otherColl);
            }
        }
        result.retainAll((Collection<?>)var1_1);
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        void var2_3;
        Iterator iterator;
        if (CollUtil.isEmpty(coll1)) {
            return coll2;
        }
        if (CollUtil.isEmpty(coll2)) {
            return coll1;
        }
        ArrayList result = new ArrayList();
        Map<T, Integer> map1 = CollUtil.countMap(coll1);
        Map<T, Integer> map2 = CollUtil.countMap(coll2);
        HashSet<T> elts = CollUtil.newHashSet(coll2);
        elts.addAll(coll1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            int m = Math.abs(Convert.toInt(map1.get(t), 0) - Convert.toInt(map2.get(t), 0));
            for (int i = 0; i < m; ++i) {
                result.add(t);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> subtract(Collection<T> coll1, Collection<T> coll2) {
        void var2_2;
        Collection<T> result = ObjectUtil.clone(coll1);
        try {
            if (result == null) {
                result = CollUtil.create(coll1.getClass());
                result.addAll(coll1);
            }
            result.removeAll(coll2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            void var1_1;
            Collection<T> collection;
            result = CollUtil.create(AbstractCollection.class);
            result.addAll(collection);
            result.removeAll((Collection<?>)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> subtractToList(Collection<T> coll1, Collection<T> coll2) {
        void var2_2;
        Iterator<T> iterator;
        if (CollUtil.isEmpty(coll1)) {
            return ListUtil.empty();
        }
        if (CollUtil.isEmpty(coll2)) {
            return ListUtil.list(true, coll1);
        }
        LinkedList<void> result = new LinkedList<void>();
        HashSet<T> set = new HashSet<T>(coll2);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object t = iterator.next();
            if (set.contains(t)) continue;
            result.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(Collection<?> collection, Object value) {
        void var1_1;
        Collection<?> collection2;
        return CollUtil.isNotEmpty(collection) && collection2.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean safeContains(Collection<?> collection, Object value) {
        try {
            void var1_1;
            return CollUtil.contains(collection, var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean contains(Collection<T> collection, Predicate<? super T> containFunc) {
        Iterator<T> iterator;
        if (CollUtil.isEmpty(collection)) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object t = iterator.next();
            if (!containFunc.test(var2_2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollUtil.isEmpty(coll1) || CollUtil.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            void var1_1;
            for (Object object : var1_1) {
                void var3_5;
                if (!coll1.contains(var3_5)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(Collection<?> coll1, Collection<?> coll2) {
        Iterator iterator;
        if (CollUtil.isEmpty(coll1)) {
            return CollUtil.isEmpty(coll2);
        }
        if (CollUtil.isEmpty(coll2)) {
            return true;
        }
        if (coll1 instanceof Set) {
            return coll1.containsAll(coll2);
        }
        Iterator<?> it = coll1.iterator();
        Collection<?> elementsAlreadySeen = new HashSet(coll1.size(), 1.0f);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object nextElement = iterator.next();
            if (elementsAlreadySeen.contains(nextElement)) continue;
            boolean foundCurrentElement = false;
            while (it.hasNext()) {
                Object p = it.next();
                elementsAlreadySeen.add(p);
                if (!Objects.equals(nextElement, p)) continue;
                foundCurrentElement = true;
                break;
            }
            if (foundCurrentElement) continue;
            return false;
        }
        return true;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> collection) {
        Iterable<T> iterable;
        return IterUtil.countMap(collection == null ? null : iterable.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        void var2_2;
        void var1_1;
        Iterable<T> iterable2;
        if (iterable == null) {
            return null;
        }
        return IterUtil.join(iterable2.iterator(), (CharSequence)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        void var1_1;
        Iterable<T> iterable2;
        if (iterable == null) {
            return null;
        }
        return IterUtil.join(iterable2.iterator(), (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, String prefix, String suffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        Iterable<T> iterable2;
        if (iterable == null) {
            return null;
        }
        return IterUtil.join(iterable2.iterator(), (CharSequence)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        void var1_1;
        return IterUtil.join(iterator, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        void var2_2;
        if (CollUtil.isEmpty(surplusAlaDatas)) {
            return ListUtil.empty();
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        void var2_2;
        if (CollUtil.isEmpty(surplusAlaDatas)) {
            return ListUtil.empty();
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean anyMatch(Collection<T> collection, Predicate<T> predicate) {
        void var1_1;
        Collection<T> collection2;
        if (CollUtil.isEmpty(collection)) {
            return false;
        }
        return collection2.stream().anyMatch((Predicate<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean allMatch(Collection<T> collection, Predicate<T> predicate) {
        void var1_1;
        Collection<T> collection2;
        if (CollUtil.isEmpty(collection)) {
            return false;
        }
        return collection2.stream().allMatch((Predicate<T>)var1_1);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        T[] TArray;
        return CollUtil.set(false, TArray);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... ts) {
        T[] TArray;
        return (LinkedHashSet)CollUtil.set(true, TArray);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> HashSet<T> set(boolean isSorted, T ... ts) {
        void var0_1;
        void var1_2;
        void var2_3;
        if (ts == null) {
            if (isSorted) {
                return new LinkedHashSet();
            }
            return new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet((int)var2_3);
        Collections.addAll(set, var1_2);
        return var0_1;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        Collection<T> collection2;
        return CollUtil.newHashSet(false, collection2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        void var1_1;
        if (isSorted) {
            return new LinkedHashSet<T>(collection);
        }
        return new HashSet(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<T> iter) {
        void var0_1;
        HashSet set;
        if (iter == null) {
            return CollUtil.set(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> HashSet<T> newHashSet(boolean isSorted, Enumeration<T> enumeration) {
        void var0_1;
        HashSet set;
        if (enumeration == null) {
            return CollUtil.set(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return var0_1;
    }

    public static <T> List<T> list(boolean isLinked) {
        return ListUtil.list(isLinked);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        void var1_1;
        return ListUtil.list(isLinked, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        void var1_1;
        return ListUtil.list(isLinked, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        void var1_1;
        return ListUtil.list(isLinked, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        void var1_1;
        return ListUtil.list(isLinked, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumeration) {
        void var1_1;
        return ListUtil.list(isLinked, var1_1);
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        return ListUtil.toList(values);
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return ListUtil.toList(values);
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return ListUtil.toList(collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> iterable) {
        return ListUtil.toList(iterable);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iterator) {
        return ListUtil.toList(iterator);
    }

    public static <T> ArrayList<T> newArrayList(Enumeration<T> enumeration) {
        return ListUtil.toList(enumeration);
    }

    @SafeVarargs
    public static <T> LinkedList<T> newLinkedList(T ... values) {
        return ListUtil.toLinkedList(values);
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(Collection<T> collection) {
        return ListUtil.toCopyOnWriteArrayList(collection);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> BlockingQueue<T> newBlockingQueue(int capacity, boolean isLinked) {
        void var0_1;
        int queue22;
        AbstractQueue queue22 = isLinked ? new LinkedBlockingDeque(capacity) : new ArrayBlockingQueue(queue22);
        return var0_1;
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        return CollUtil.create(collectionType, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> create(Class<?> collectionType, Class<T> elementType) {
        void var1_1;
        Collection list;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet((o1, o2) -> {
                void var1_1;
                Object object;
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return CompareUtil.compare(object.toString(), var1_1.toString());
            });
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf((Class)((Object)Assert.notNull(list)));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ReflectUtil.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                Class<?> clazz;
                Class<?> superclass = collectionType.getSuperclass();
                if (superclass != null && clazz != superclass) {
                    void var2_3;
                    return CollUtil.create(var2_3);
                }
                throw new UtilException(e);
            }
        }
        return var1_1;
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        Collection<T> collection2;
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K> List<T> distinct(Collection<T> collection, Function<T, K> uniqueGenerator, boolean override) {
        void var1_1;
        void var2_2;
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        UniqueKeySet<K, T> set = new UniqueKeySet<K, T>(true, uniqueGenerator);
        if (var2_2 != false) {
            set.addAll(collection);
        } else {
            Collection<T> collection2;
            set.addAllIfAbsent(collection2);
        }
        return new ArrayList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sub(List<T> list, int start, int end) {
        void var2_2;
        void var1_1;
        return ListUtil.sub(list, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ListUtil.sub(list, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sub(Collection<T> collection, int start, int end) {
        void var2_2;
        void var1_1;
        return CollUtil.sub(collection, (int)var1_1, (int)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sub(Collection<T> collection, int start, int end, int step) {
        void var3_3;
        void var2_2;
        void var1_1;
        Collection<T> collection2;
        if (CollUtil.isEmpty(collection)) {
            return ListUtil.empty();
        }
        collection2 = collection instanceof List ? (ArrayList<T>)collection : ListUtil.toList(collection2);
        return CollUtil.sub(collection2, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> List<List<T>> splitList(List<T> list, int size) {
        void var1_1;
        return ListUtil.partition(list, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<List<T>> split(Collection<T> collection, int size) {
        void var2_2;
        Iterator<T> iterator;
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollUtil.isEmpty(collection)) {
            return result;
        }
        int initSize = Math.min(collection.size(), size);
        ArrayList subList = new ArrayList(initSize);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (subList.size() >= size) {
                result.add(subList);
                subList = new ArrayList(initSize);
            }
            subList.add(t);
        }
        result.add(subList);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> edit(Collection<T> collection, Editor<T> editor) {
        void var2_2;
        if (collection == null || editor == null) {
            return collection;
        }
        Collection<T> collection2 = CollUtil.create(collection.getClass());
        if (CollUtil.isEmpty(collection)) {
            return collection2;
        }
        for (Collection<T> t : collection) {
            Collection<T> collection3;
            Collection<T> modified = editor.edit(t);
            if (modified == null) continue;
            collection2.add(collection3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> filterNew(Collection<T> collection, Filter<T> filter) {
        void var1_1;
        Collection<T> collection2;
        if (collection == null || filter == null) {
            return collection;
        }
        return CollUtil.edit(collection2, arg_0 -> CollUtil.lambda$filterNew$1((Filter)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<E>, E> T removeAny(T collection, E ... elesRemoved) {
        T t;
        void var1_1;
        collection.removeAll(CollUtil.newHashSet(var1_1));
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<E>, E> T filter(T collection, Filter<E> filter) {
        void var1_1;
        return IterUtil.filter(collection, var1_1);
    }

    public static <T extends Collection<E>, E> T removeNull(T collection) {
        return CollUtil.filter(collection, Objects::nonNull);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeEmpty(T collection) {
        return CollUtil.filter(collection, CharSequenceUtil::isNotEmpty);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeBlank(T collection) {
        return CollUtil.filter(collection, CharSequenceUtil::isNotBlank);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<E>, E> T removeWithAddIf(T targetCollection, T resultCollection, Predicate<? super E> predicate) {
        void var1_1;
        Objects.requireNonNull(predicate);
        Iterator<E> each = targetCollection.iterator();
        while (each.hasNext()) {
            void var3_3;
            Object next = each.next();
            if (!predicate.test(next)) continue;
            resultCollection.add(var3_3);
            each.remove();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<E>, E> List<E> removeWithAddIf(T targetCollection, Predicate<? super E> predicate) {
        void var2_2;
        void var1_1;
        T t;
        ArrayList removed = new ArrayList();
        CollUtil.removeWithAddIf(t, removed, var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor) {
        void var1_1;
        return CollUtil.extract(collection, (Editor<Object>)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor, boolean ignoreNull) {
        void var2_2;
        void var1_1;
        return CollUtil.map(collection, ((Editor)var1_1)::edit, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> func, boolean ignoreNull) {
        void var3_3;
        ArrayList<Iterable<T>> fieldValueList = new ArrayList<Iterable<T>>();
        if (collection == null) {
            return fieldValueList;
        }
        for (Iterable<Object> t : collection) {
            Iterable<Object> iterable;
            Iterable<Object> value;
            if (t == null && ignoreNull || (value = func.apply(t)) == null && ignoreNull) continue;
            fieldValueList.add(iterable);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> getFieldValues(Iterable<?> collection, String fieldName) {
        void var1_1;
        return CollUtil.getFieldValues(collection, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> getFieldValues(Iterable<?> collection, String fieldName, boolean ignoreNull) {
        void var2_2;
        void var1_1;
        return CollUtil.map(collection, arg_0 -> CollUtil.lambda$getFieldValues$2((String)var1_1, arg_0), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> getFieldValues(Iterable<?> collection, String fieldName, Class<T> elementType) {
        Iterable<?> iterable;
        void var2_2;
        void var1_1;
        Iterable<?> fieldValues = CollUtil.getFieldValues(collection, (String)var1_1);
        return Convert.toList(var2_2, iterable);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> fieldValueMap(Iterable<V> iterable, String fieldName) {
        void var1_1;
        return IterUtil.fieldValueMap(IterUtil.getIter(iterable), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> fieldValueAsMap(Iterable<?> iterable, String fieldNameForKey, String fieldNameForValue) {
        void var2_2;
        void var1_1;
        return IterUtil.fieldValueAsMap(IterUtil.getIter(iterable), (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T findOne(Iterable<T> collection, Filter<T> filter) {
        if (collection != null) {
            Iterator<T> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Object t = iterator.next();
                if (!filter.accept(t)) continue;
                return var2_2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T findOneByField(Iterable<T> collection, String fieldName, Object fieldValue) {
        void var2_2;
        void var1_1;
        return (T)CollUtil.findOne(collection, arg_0 -> CollUtil.lambda$findOneByField$3((String)var1_1, var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int count(Iterable<T> iterable, Matcher<T> matcher) {
        void var2_2;
        int count = 0;
        if (iterable != null) {
            Iterator<T> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object t = iterator.next();
                if (matcher != null && !matcher.match(var3_3)) continue;
                ++count;
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOf(Collection<T> collection, Matcher<T> matcher) {
        if (CollUtil.isNotEmpty(collection)) {
            Iterator<T> iterator;
            int index = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object t = iterator.next();
                if (matcher == null || matcher.match(var3_3)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int lastIndexOf(Collection<T> collection, Matcher<T> matcher) {
        void var2_2;
        if (collection instanceof List) {
            return ListUtil.lastIndexOf((List)collection, matcher);
        }
        int matchIndex = -1;
        if (CollUtil.isNotEmpty(collection)) {
            Iterator<T> iterator;
            int index = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                if (matcher == null || matcher.match(t)) {
                    matchIndex = index;
                }
                ++index;
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int[] indexOfAll(Collection<T> collection, Matcher<T> matcher) {
        void var2_2;
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (collection != null) {
            Iterator<T> iterator;
            int index = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                if (matcher == null || matcher.match(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return Convert.convert(int[].class, (Object)var2_2);
    }

    public static boolean isEmpty(Collection<?> collection) {
        Collection<?> collection2;
        return collection == null || collection2.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<E>, E> T defaultIfEmpty(T collection, T defaultCollection) {
        T t;
        if (CollUtil.isEmpty(collection)) {
            void var1_1;
            return var1_1;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<E>, E> T defaultIfEmpty(T collection, Supplier<? extends T> supplier) {
        T t;
        if (CollUtil.isEmpty(collection)) {
            void var1_1;
            return (T)((Collection)var1_1.get());
        }
        return t;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterUtil.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return IterUtil.isEmpty(Iterator2);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        Enumeration<?> enumeration2;
        return enumeration == null || false == enumeration2.hasMoreElements();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtil.isEmpty(map);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IterUtil.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return IterUtil.isNotEmpty(Iterator2);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        Enumeration<?> enumeration2;
        return enumeration != null && enumeration2.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IterUtil.hasNull(iterable);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtil.isNotEmpty(map);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ArrayUtil.zip(StrUtil.splitToArray((CharSequence)keys, delimiter), StrUtil.splitToArray((CharSequence)var1_1, (CharSequence)var2_2), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> zip(String keys, String values, String delimiter) {
        void var2_2;
        void var1_1;
        return CollUtil.zip(keys, (String)var1_1, (String)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        void var3_3;
        int entryCount;
        if (CollUtil.isEmpty(keys) || CollUtil.isEmpty(values)) {
            return MapUtil.empty();
        }
        HashMap map = MapUtil.newHashMap(entryCount);
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        for (entryCount = Math.min(keys.size(), values.size()); entryCount > 0; --entryCount) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return var3_3;
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        return IterUtil.toMap(entryIter);
    }

    public static HashMap<Object, Object> toMap(Object[] array) {
        return MapUtil.of(array);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        void var1_1;
        Collection<T> collection2;
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        treeSet.addAll(collection2);
        return var1_1;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        Iterator<E> iterator;
        return new IteratorEnumeration<E>(iterator);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return IterUtil.asIterator(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return IterUtil.asIterable(iter);
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        Iterable<E> iterable2;
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return CollUtil.newArrayList(iterable2.iterator());
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        return MapUtil.toListMap(mapList);
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        return MapUtil.toMapList(listMap);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> toMap(Iterable<V> values, Map<K, V> map, Func1<V, K> keyFunc) {
        void var2_2;
        void var1_1;
        Iterable<V> iterable;
        return IterUtil.toMap(values == null ? null : iterable.iterator(), var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, E> Map<K, V> toMap(Iterable<E> values, Map<K, V> map, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        void var3_3;
        void var2_2;
        void var1_1;
        Iterable<E> iterable;
        return IterUtil.toMap(values == null ? null : iterable.iterator(), var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, S extends T> boolean addIfAbsent(Collection<T> collection, S object) {
        void var1_1;
        Collection<T> collection2;
        if (object == null || collection == null || collection.contains(object)) {
            return false;
        }
        return collection2.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        Collection<T> collection2;
        void var1_1;
        return CollUtil.addAll(collection, var1_1, TypeUtil.getTypeArgument(collection2.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Collection<T> collection2;
        Iterator<Object> iter;
        if (collection == null || value == null) {
            return collection;
        }
        if (TypeUtil.isUnknown((Type)elementType)) {
            elementType = Object.class;
        }
        if (value instanceof Iterator) {
            iter = (Iterator)value;
        } else if (iter instanceof Iterable) {
            iter = iter instanceof Map && BeanUtil.isBean(TypeUtil.getClass((Type)elementType)) ? new ArrayIter<Object>(new Object[]{iter}) : ((Iterable)((Object)iter)).iterator();
        } else if (iter instanceof Enumeration) {
            iter = new EnumerationIter((Enumeration)((Object)iter));
        } else if (ArrayUtil.isArray(iter)) {
            iter = new ArrayIter(iter);
        } else if (iter instanceof CharSequence) {
            String string = StrUtil.unWrap((CharSequence)((Object)iter), '[', ']');
            iter = StrUtil.splitTrim((CharSequence)string, ',').iterator();
        } else {
            iter = CollUtil.newArrayList(new Object[]{iter}).iterator();
        }
        ConverterRegistry convert = ConverterRegistry.getInstance();
        while (iter.hasNext()) {
            collection.add(convert.convert((Type)elementType, iter.next()));
        }
        return collection2;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        Collection<T> collection2;
        if (collection != null && iterator != null) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        void var1_1;
        Collection<T> collection2;
        if (iterable == null) {
            return collection;
        }
        return CollUtil.addAll(collection2, var1_1.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        Collection<T> collection2;
        if (collection != null && enumeration != null) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        Collection<T> collection2;
        if (collection != null && values != null) {
            void var1_1;
            Collections.addAll(collection, var1_1);
        }
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        List<T> list2;
        for (T t : otherList) {
            void var2_2;
            if (list.contains(t)) continue;
            list.add(var2_2);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Collection<T> collection, int index) {
        void var1_1;
        Collection<T> collection2;
        void var2_2;
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        if (size == 0) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= var2_2 || index < 0) {
            return null;
        }
        if (collection instanceof List) {
            collection = collection;
            return (T)collection.get(index);
        }
        return IterUtil.get(collection2.iterator(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        void var3_3;
        Object[] list;
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>();
        if (collection instanceof List) {
            list = (Object[])collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            void var1_1;
            Object[] array = list.toArray();
            for (void index : var1_1) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return var3_3;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        return IterUtil.getFirst(iterable);
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return IterUtil.getFirst(iterator);
    }

    public static <T> T getLast(Collection<T> collection) {
        return CollUtil.get(collection, -1);
    }

    @Deprecated
    public static Class<?> getElementType(Iterable<?> iterable) {
        return IterUtil.getElementType(iterable);
    }

    @Deprecated
    public static Class<?> getElementType(Iterator<?> iterator) {
        return IterUtil.getElementType(iterator);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        void var1_1;
        return MapUtil.valuesOfKeys(map, new ArrayIter((E[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        void var1_1;
        return CollUtil.valuesOfKeys(map, var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        void var1_1;
        return MapUtil.valuesOfKeys(map, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> List<T> sortPageAll(int pageNo, int pageSize, Comparator<T> comparator, Collection<T> ... colls) {
        void var1_1;
        int n;
        void var3_3;
        ArrayList list = new ArrayList(pageNo * pageSize);
        for (void coll : var3_3) {
            list.addAll(coll);
        }
        if (comparator != null) {
            void var2_2;
            list.sort(var2_2);
        }
        return CollUtil.page(n, (int)var1_1, list);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        void var2_2;
        void var1_1;
        return ListUtil.page(pageNo, (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        Collection<T> collection2;
        void var1_1;
        Collection<T> list = new ArrayList<T>(collection);
        list.sort((Comparator<T>)var1_1);
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        void var1_1;
        return ListUtil.sort(list, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sortByProperty(Collection<T> collection, String property) {
        void var1_1;
        return CollUtil.sort(collection, new PropertyComparator((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> sortByProperty(List<T> list, String property) {
        void var1_1;
        return ListUtil.sortByProperty(list, (String)var1_1);
    }

    public static List<String> sortByPinyin(Collection<String> collection) {
        return CollUtil.sort(collection, new PinyinComparator());
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtil.sortByPinyin(list);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        void var1_1;
        Map<K, V> map2;
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        void var1_1;
        LinkedList<Map.Entry<K, V>> linkedList;
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        list.sort(comparator);
        LinkedHashMap result = new LinkedHashMap();
        linkedList = linkedList.iterator();
        while (linkedList.hasNext()) {
            void var2_2;
            Map.Entry entry = (Map.Entry)linkedList.next();
            result.put(entry.getKey(), var2_2.getValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        void var1_1;
        return CollUtil.sortToMap(map.entrySet(), var1_1);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        Collection<Map.Entry<K, V>> collection2;
        Collection<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        list.sort((o1, o2) -> {
            void var1_1;
            Map.Entry entry;
            Map.Entry v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1 instanceof Comparable) {
                return ((Comparable)((Object)v1)).compareTo(v2);
            }
            return entry.toString().compareTo(var1_1.toString());
        });
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void forEach(Iterable<T> iterable, Consumer<T> consumer) {
        void var1_1;
        Iterable<T> iterable2;
        if (iterable == null) {
            return;
        }
        CollUtil.forEach(iterable2.iterator(), var1_1);
    }

    public static <T> void forEach(Iterator<T> iterator, Consumer<T> consumer) {
        if (iterator == null) {
            return;
        }
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, Consumer<T> consumer) {
        if (enumeration == null) {
            return;
        }
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, KVConsumer<K, V> kvConsumer) {
        Object object;
        if (map == null) {
            return;
        }
        int index = 0;
        for (Map.Entry entry : object.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<List<T>> group(Collection<T> collection, Hash32<T> hash) {
        void var2_3;
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollUtil.isEmpty(collection)) {
            return result;
        }
        if (hash == null) {
            hash = t -> {
                Object object;
                if (t == null) {
                    return 0;
                }
                return object.hashCode();
            };
        }
        for (T t2 : collection) {
            void var3_5;
            int index = hash.hash32(t2);
            if (result.size() - 1 < index) {
                while (result.size() - 1 < index) {
                    result.add(null);
                }
                result.set(index, CollUtil.newArrayList(t2));
                continue;
            }
            List subList = (List)result.get(index);
            if (subList == null) {
                void var0_1;
                result.set((int)var0_1, CollUtil.newArrayList(t2));
                continue;
            }
            var3_5.add(t2);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<List<T>> groupByField(Collection<T> collection, String fieldName) {
        void var1_1;
        return CollUtil.group(collection, new Hash32<T>((String)var1_1){
            private final List<Object> fieldNameList = new ArrayList<Object>();
            final /* synthetic */ String val$fieldName;
            {
                this.val$fieldName = string;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int hash32(T t) {
                void var2_2;
                if (t == null || !BeanUtil.isBean(t.getClass())) {
                    return 0;
                }
                Object value = ReflectUtil.getFieldValue(t, this.val$fieldName);
                int hash = this.fieldNameList.indexOf(value);
                if (hash < 0) {
                    void var1_1;
                    this.fieldNameList.add(var1_1);
                    return this.fieldNameList.size() - 1;
                }
                return (int)var2_2;
            }
        });
    }

    public static <T> List<T> reverse(List<T> list) {
        return ListUtil.reverse(list);
    }

    public static <T> List<T> reverseNew(List<T> list) {
        return ListUtil.reverseNew(list);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        void var2_2;
        void var1_1;
        return ListUtil.setOrAppend(list, (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> Set<K> keySet(Collection<Map<K, ?>> mapCollection) {
        void var1_1;
        Iterator<Map<K, ?>> iterator;
        if (CollUtil.isEmpty(mapCollection)) {
            return new HashSet();
        }
        HashSet set = new HashSet(mapCollection.size() << 4);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Map map = (Map)iterator.next();
            set.addAll(var2_2.keySet());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <V> List<V> values(Collection<Map<?, V>> mapCollection) {
        void var1_1;
        Iterator<Map<?, V>> iterator;
        ArrayList values = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Map map = (Map)iterator.next();
            values.addAll(var2_2.values());
        }
        return var1_1;
    }

    public static <T extends Comparable<? super T>> T max(Collection<T> coll) {
        Collection<T> collection;
        if (CollUtil.isEmpty(coll)) {
            return null;
        }
        return (T)((Comparable)Collections.max(collection));
    }

    public static <T extends Comparable<? super T>> T min(Collection<T> coll) {
        Collection<T> collection;
        if (CollUtil.isEmpty(coll)) {
            return null;
        }
        return (T)((Comparable)Collections.min(collection));
    }

    public static <T> Collection<T> unmodifiable(Collection<? extends T> c) {
        return Collections.unmodifiableCollection(c);
    }

    public static <E, T extends Collection<E>> T empty(Class<?> collectionClass) {
        Class<?> clazz;
        if (collectionClass == null) {
            return (T)Collections.emptyList();
        }
        if (Set.class.isAssignableFrom(collectionClass)) {
            if (NavigableSet.class == collectionClass) {
                return (T)Collections.emptyNavigableSet();
            }
            if (SortedSet.class == collectionClass) {
                return (T)Collections.emptySortedSet();
            }
            return (T)Collections.emptySet();
        }
        if (List.class.isAssignableFrom(collectionClass)) {
            return (T)Collections.emptyList();
        }
        throw new IllegalArgumentException(StrUtil.format("[{}] is not support to get empty!", clazz));
    }

    /*
     * WARNING - void declaration
     */
    public static void clear(Collection<?> ... collections) {
        Collection<?>[] collectionArray = collections;
        int n = collections.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            Collection<?> collection = collectionArray[i];
            if (!CollUtil.isNotEmpty(collection)) continue;
            var3_3.clear();
        }
    }

    public static <T> void padLeft(List<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            CollUtil.padRight(list, minLen, padObj);
            return;
        }
        for (int i = list.size(); i < minLen; ++i) {
            list.add(0, padObj);
        }
    }

    public static <T> void padRight(Collection<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        for (int i = list.size(); i < minLen; ++i) {
            list.add(padObj);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Collection<T> trans(Collection<F> collection, Function<? super F, ? extends T> function) {
        void var1_1;
        Collection<F> collection2;
        return new TransCollection(collection2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E, K, V> void setValueByMap(Iterable<E> iterable, Map<K, V> map, Function<E, K> keyGenerate, BiConsumer<E, V> biConsumer) {
        void var3_3;
        void var2_2;
        void var1_1;
        iterable.forEach(arg_0 -> CollUtil.lambda$setValueByMap$7((Map)var1_1, (Function)var2_2, (BiConsumer)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static int size(Object object) {
        void var1_1;
        Object object2;
        if (object == null) {
            return 0;
        }
        int total = 0;
        if (object instanceof Map) {
            total = ((Map)object).size();
        } else if (object instanceof Collection) {
            total = ((Collection)object).size();
        } else if (object instanceof Iterable) {
            total = IterUtil.size((Iterable)object);
        } else if (object instanceof Iterator) {
            total = IterUtil.size((Iterator)object);
        } else if (object instanceof Enumeration) {
            Object it = (Enumeration)object;
            while (it.hasMoreElements()) {
                ++total;
                it.nextElement();
            }
        } else if (ArrayUtil.isArray(object2)) {
            total = ArrayUtil.length(object2);
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + object2.getClass().getName());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEqualList(Collection<?> list1, Collection<?> list2) {
        void var1_1;
        Collection<?> collection;
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            return false;
        }
        return IterUtil.isEqualList(collection, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setValueByMap$7(Map map, Function keyGenerate, BiConsumer biConsumer, Object x) {
        void var3_3;
        void var2_2;
        void var1_1;
        Optional.ofNullable(map.get(var1_1.apply(x))).ifPresent(arg_0 -> CollUtil.lambda$null$6((BiConsumer)var2_2, var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$null$6(BiConsumer biConsumer, Object x, Object y) {
        void var2_2;
        void var1_1;
        biConsumer.accept(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$findOneByField$3(String fieldName, Object fieldValue, Object t) {
        void var1_1;
        String string;
        Object object;
        if (t instanceof Map) {
            t = (Map)t;
            fieldName = t.get(fieldName);
            return ObjectUtil.equal(fieldName, fieldValue);
        }
        object = ReflectUtil.getFieldValue(object, string);
        return ObjectUtil.equal(object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$getFieldValues$2(String fieldName, Object bean) {
        String string;
        void var1_1;
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldName);
        }
        return ReflectUtil.getFieldValue((Object)var1_1, string);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$filterNew$1(Filter filter, Object t) {
        if (filter.accept(t)) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    @FunctionalInterface
    public static interface KVConsumer<K, V>
    extends Serializable {
        public void accept(K var1, V var2, int var3);
    }

    @FunctionalInterface
    public static interface Consumer<T>
    extends Serializable {
        public void accept(T var1, int var2);
    }
}

