/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;

public class PercentCodec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public static PercentCodec of(PercentCodec codec) {
        PercentCodec percentCodec;
        return new PercentCodec((BitSet)percentCodec.safeCharacters.clone());
    }

    /*
     * WARNING - void declaration
     */
    public static PercentCodec of(CharSequence chars) {
        void var1_1;
        Assert.notNull(chars, "chars must not be null", new Object[0]);
        PercentCodec codec = new PercentCodec();
        int length = chars.length();
        for (int i = 0; i < length; ++i) {
            codec.addSafe(chars.charAt(i));
        }
        return var1_1;
    }

    public PercentCodec() {
        this(new BitSet(256));
    }

    /*
     * WARNING - void declaration
     */
    public PercentCodec(BitSet safeCharacters) {
        void var1_1;
        this.safeCharacters = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PercentCodec addSafe(char c) {
        void var1_1;
        this.safeCharacters.set((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PercentCodec removeSafe(char c) {
        void var1_1;
        this.safeCharacters.clear((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PercentCodec or(PercentCodec codec) {
        void var1_1;
        this.safeCharacters.or(var1_1.safeCharacters);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PercentCodec orNew(PercentCodec codec) {
        void var1_1;
        return PercentCodec.of(this).or((PercentCodec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public PercentCodec setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        void var1_1;
        this.encodeSpaceAsPlus = var1_1;
        return this;
    }

    public String encode(CharSequence path, Charset charset, char ... customSafeChar) {
        if (charset == null || StrUtil.isEmpty(path)) {
            return StrUtil.str(path);
        }
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i = 0; i < path.length(); ++i) {
            block7: {
                char c = path.charAt(i);
                if (this.safeCharacters.get(c) || ArrayUtil.contains(customSafeChar, c)) {
                    rewrittenPath.append(c);
                    continue;
                }
                if (this.encodeSpaceAsPlus && c == ' ') {
                    rewrittenPath.append('+');
                    continue;
                }
                try {
                    writer.write(c);
                    writer.flush();
                }
                catch (IOException iOException) {
                    break block7;
                }
                byte[] byArray = buf.toByteArray();
                byte[] byArray2 = byArray;
                byArray2 = byArray;
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte toEncode = byArray2[j];
                    rewrittenPath.append('%');
                    HexUtil.appendHex(rewrittenPath, toEncode, false);
                }
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

