/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Morse {
    private static final Map<Integer, String> ALPHABETS = new HashMap<Integer, String>();
    private static final Map<String, Integer> DICTIONARIES = new HashMap<String, Integer>();
    private final char dit;
    private final char dah;
    private final char split;

    /*
     * WARNING - void declaration
     */
    private static void registerMorse(Character abc, String dict) {
        Character c;
        void var1_1;
        ALPHABETS.put(Integer.valueOf(abc.charValue()), dict);
        DICTIONARIES.put((String)var1_1, Integer.valueOf(c.charValue()));
    }

    public Morse() {
        this('.', '-', '/');
    }

    /*
     * WARNING - void declaration
     */
    public Morse(char dit, char dah, char split) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.dit = var1_1;
        this.dah = var2_2;
        this.split = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String text) {
        void var2_2;
        Assert.notNull(text, "Text should not be null.", new Object[0]);
        text = text.toUpperCase();
        StringBuilder morseBuilder = new StringBuilder();
        int len = text.codePointCount(0, text.length());
        for (int i = 0; i < len; ++i) {
            int codePoint = text.codePointAt(i);
            String word = ALPHABETS.get(codePoint);
            if (word == null) {
                word = Integer.toBinaryString(codePoint);
            }
            morseBuilder.append(word.replace('0', this.dit).replace('1', this.dah)).append(this.split);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String decode(String morse) {
        Assert.notNull(morse, "Morse should not be null.", new Object[0]);
        char dit = this.dit;
        char dah = this.dah;
        char split = this.split;
        if (!StrUtil.containsOnly(morse, dit, dah, split)) {
            throw new IllegalArgumentException("Incorrect morse.");
        }
        List<String> words = StrUtil.split((CharSequence)morse, split);
        StringBuilder textBuilder = new StringBuilder();
        for (String word : words) {
            void var1_1;
            if (StrUtil.isEmpty(word)) continue;
            Integer codePoint = DICTIONARIES.get(word = word.replace(dit, '0').replace(dah, '1'));
            if (codePoint == null) {
                codePoint = Integer.valueOf(word, 2);
            }
            textBuilder.appendCodePoint(var1_1.intValue());
        }
        return textBuilder.toString();
    }

    static {
        Morse.registerMorse(Character.valueOf('A'), "01");
        Morse.registerMorse(Character.valueOf('B'), "1000");
        Morse.registerMorse(Character.valueOf('C'), "1010");
        Morse.registerMorse(Character.valueOf('D'), "100");
        Morse.registerMorse(Character.valueOf('E'), "0");
        Morse.registerMorse(Character.valueOf('F'), "0010");
        Morse.registerMorse(Character.valueOf('G'), "110");
        Morse.registerMorse(Character.valueOf('H'), "0000");
        Morse.registerMorse(Character.valueOf('I'), "00");
        Morse.registerMorse(Character.valueOf('J'), "0111");
        Morse.registerMorse(Character.valueOf('K'), "101");
        Morse.registerMorse(Character.valueOf('L'), "0100");
        Morse.registerMorse(Character.valueOf('M'), "11");
        Morse.registerMorse(Character.valueOf('N'), "10");
        Morse.registerMorse(Character.valueOf('O'), "111");
        Morse.registerMorse(Character.valueOf('P'), "0110");
        Morse.registerMorse(Character.valueOf('Q'), "1101");
        Morse.registerMorse(Character.valueOf('R'), "010");
        Morse.registerMorse(Character.valueOf('S'), "000");
        Morse.registerMorse(Character.valueOf('T'), "1");
        Morse.registerMorse(Character.valueOf('U'), "001");
        Morse.registerMorse(Character.valueOf('V'), "0001");
        Morse.registerMorse(Character.valueOf('W'), "011");
        Morse.registerMorse(Character.valueOf('X'), "1001");
        Morse.registerMorse(Character.valueOf('Y'), "1011");
        Morse.registerMorse(Character.valueOf('Z'), "1100");
        Morse.registerMorse(Character.valueOf('0'), "11111");
        Morse.registerMorse(Character.valueOf('1'), "01111");
        Morse.registerMorse(Character.valueOf('2'), "00111");
        Morse.registerMorse(Character.valueOf('3'), "00011");
        Morse.registerMorse(Character.valueOf('4'), "00001");
        Morse.registerMorse(Character.valueOf('5'), "00000");
        Morse.registerMorse(Character.valueOf('6'), "10000");
        Morse.registerMorse(Character.valueOf('7'), "11000");
        Morse.registerMorse(Character.valueOf('8'), "11100");
        Morse.registerMorse(Character.valueOf('9'), "11110");
        Morse.registerMorse(Character.valueOf('.'), "010101");
        Morse.registerMorse(Character.valueOf(','), "110011");
        Morse.registerMorse(Character.valueOf('?'), "001100");
        Morse.registerMorse(Character.valueOf('\''), "011110");
        Morse.registerMorse(Character.valueOf('!'), "101011");
        Morse.registerMorse(Character.valueOf('/'), "10010");
        Morse.registerMorse(Character.valueOf('('), "10110");
        Morse.registerMorse(Character.valueOf(')'), "101101");
        Morse.registerMorse(Character.valueOf('&'), "01000");
        Morse.registerMorse(Character.valueOf(':'), "111000");
        Morse.registerMorse(Character.valueOf(';'), "101010");
        Morse.registerMorse(Character.valueOf('='), "10001");
        Morse.registerMorse(Character.valueOf('+'), "01010");
        Morse.registerMorse(Character.valueOf('-'), "100001");
        Morse.registerMorse(Character.valueOf('_'), "001101");
        Morse.registerMorse(Character.valueOf('\"'), "010010");
        Morse.registerMorse(Character.valueOf('$'), "0001001");
        Morse.registerMorse(Character.valueOf('@'), "011010");
    }
}

