/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Decoder;
import cn.hutool.core.codec.Encoder;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class Hashids
implements Decoder<String, long[]>,
Encoder<long[], String> {
    private static final int LOTTERY_MOD = 100;
    private static final double GUARD_THRESHOLD = 12.0;
    private static final double SEPARATOR_THRESHOLD = 3.5;
    private static final int MIN_ALPHABET_LENGTH = 16;
    private static final Pattern HEX_VALUES_PATTERN = Pattern.compile("[\\w\\W]{1,12}");
    public static final char[] DEFAULT_ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static final char[] DEFAULT_SEPARATORS = new char[]{'c', 'f', 'h', 'i', 's', 't', 'u', 'C', 'F', 'H', 'I', 'S', 'T', 'U'};
    private final char[] alphabet;
    private final char[] separators;
    private final Set<Character> separatorsSet;
    private final char[] salt;
    private final char[] guards;
    private final int minLength;

    public static Hashids create(char[] salt) {
        return Hashids.create(salt, DEFAULT_ALPHABET, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static Hashids create(char[] salt, int minLength) {
        void var1_1;
        return Hashids.create(salt, DEFAULT_ALPHABET, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Hashids create(char[] salt, char[] alphabet, int minLength) {
        void var2_2;
        void var1_1;
        char[] cArray;
        return new Hashids(cArray, (char[])var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Hashids(char[] salt, char[] alphabet, int minLength) {
        void var2_2;
        int minSeparatorsSize;
        this.minLength = minLength;
        this.salt = Arrays.copyOf(salt, salt.length);
        Hashids hashids = this;
        char[] tmpSeparators = hashids.shuffle(hashids.filterSeparators(DEFAULT_SEPARATORS, alphabet), this.salt);
        char[] tmpAlphabet = this.validateAndFilterAlphabet(alphabet, tmpSeparators);
        if ((tmpSeparators.length == 0 || (double)(tmpAlphabet.length / tmpSeparators.length) > 3.5) && (minSeparatorsSize = (int)Math.ceil((double)tmpAlphabet.length / 3.5)) > tmpSeparators.length) {
            int missingSeparators = minSeparatorsSize - tmpSeparators.length;
            tmpSeparators = Arrays.copyOf(tmpSeparators, tmpSeparators.length + missingSeparators);
            System.arraycopy(tmpAlphabet, 0, tmpSeparators, tmpSeparators.length - missingSeparators, missingSeparators);
            System.arraycopy(tmpAlphabet, 0, tmpSeparators, tmpSeparators.length - missingSeparators, missingSeparators);
            tmpAlphabet = Arrays.copyOfRange(tmpAlphabet, missingSeparators, tmpAlphabet.length);
        }
        this.shuffle(tmpAlphabet, this.salt);
        this.guards = new char[(int)Math.ceil((double)tmpAlphabet.length / 12.0)];
        if (((void)var2_2).length < 3) {
            System.arraycopy(tmpSeparators, 0, this.guards, 0, this.guards.length);
            this.separators = Arrays.copyOfRange(tmpSeparators, this.guards.length, tmpSeparators.length);
            this.alphabet = tmpAlphabet;
        } else {
            void var3_4;
            void var1_1;
            System.arraycopy(tmpAlphabet, 0, this.guards, 0, this.guards.length);
            this.separators = var1_1;
            this.alphabet = Arrays.copyOfRange(tmpAlphabet, this.guards.length, ((void)var3_4).length);
        }
        this.separatorsSet = IntStream.range(0, this.separators.length).mapToObj(idx -> {
            void var1_1;
            return Character.valueOf(this.separators[var1_1]);
        }).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    public String encodeFromHex(String hexNumbers) {
        void var2_2;
        String hex;
        if (hexNumbers == null) {
            return null;
        }
        hex = hexNumbers.startsWith("0x") || hexNumbers.startsWith("0X") ? hexNumbers.substring(2) : hex;
        LongStream values = LongStream.empty();
        Matcher matcher = HEX_VALUES_PATTERN.matcher(hex);
        while (matcher.find()) {
            long value = new BigInteger("1" + matcher.group(), 16).longValue();
            values = LongStream.concat(values, LongStream.of(value));
        }
        return this.encode(var2_2.toArray());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(long ... numbers) {
        if (numbers == null) {
            return null;
        }
        char[] currentAlphabet = Arrays.copyOf(this.alphabet, this.alphabet.length);
        long lotteryId = LongStream.range(0L, numbers.length).reduce(0L, (state, i) -> {
            void var3_2;
            void var1_1;
            long number = numbers[(int)i];
            if (number < 0L) {
                throw new IllegalArgumentException("invalid number: " + number);
            }
            return (long)(var1_1 + number % (var3_2 + 100L));
        });
        char lottery = currentAlphabet[(int)(lotteryId % (long)currentAlphabet.length)];
        StringBuilder global = new StringBuilder();
        IntStream.range(0, numbers.length).forEach(idx -> {
            void var1_1;
            this.deriveNewAlphabet(currentAlphabet, this.salt, lottery);
            int initialLength = global.length();
            this.translate(numbers[idx], (char[])var1_1, global, initialLength);
            if (idx == 0) {
                void var2_2;
                global.insert(0, (char)var2_2);
            }
            if (idx + 1 < numbers.length) {
                void var3_3;
                long n = numbers[idx] % (long)(global.charAt(initialLength) + '\u0001');
                var3_3.append(this.separators[(int)(n % (long)this.separators.length)]);
            }
        });
        if (this.minLength > global.length()) {
            int guardIdx = (int)((lotteryId + (long)lottery) % (long)this.guards.length);
            global.insert(0, this.guards[guardIdx]);
            if (this.minLength > global.length()) {
                guardIdx = (int)((lotteryId + (long)global.charAt(2)) % (long)this.guards.length);
                global.append(this.guards[guardIdx]);
            }
        }
        int paddingLeft = this.minLength - global.length();
        while (paddingLeft > 0) {
            boolean bl;
            void var3_6;
            this.shuffle(currentAlphabet, Arrays.copyOf(currentAlphabet, currentAlphabet.length));
            int alphabetHalfSize = currentAlphabet.length / 2;
            int initialSize = global.length();
            if (paddingLeft > currentAlphabet.length) {
                int offset = alphabetHalfSize + (currentAlphabet.length % 2 == 0 ? 0 : 1);
                global.insert(0, currentAlphabet, alphabetHalfSize, offset);
                global.insert(offset + initialSize, currentAlphabet, 0, alphabetHalfSize);
                paddingLeft -= currentAlphabet.length;
                continue;
            }
            int excess = currentAlphabet.length + global.length() - this.minLength;
            int secondHalfStartOffset = alphabetHalfSize + Math.floorDiv(excess, 2);
            int secondHalfLength = currentAlphabet.length - secondHalfStartOffset;
            int firstHalfLength = paddingLeft - secondHalfLength;
            global.insert(0, currentAlphabet, (int)var3_6, secondHalfLength);
            global.insert(secondHalfLength + initialSize, currentAlphabet, 0, bl ? 1 : 0);
            bl = false;
        }
        return global.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String decodeToHex(String hash) {
        void var2_2;
        void var1_1;
        if (hash == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Arrays.stream(this.decode((String)var1_1)).mapToObj(Long::toHexString).forEach(hex -> {
            void var1_1;
            sb.append((CharSequence)hex, 1, var1_1.length());
        });
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long[] decode(String hash) {
        long[] decodedValue;
        int endIdx;
        int startIdx;
        if (hash == null) {
            return null;
        }
        Set guardsSet = IntStream.range(0, this.guards.length).mapToObj(idx -> {
            void var1_1;
            return Character.valueOf(this.guards[var1_1]);
        }).collect(Collectors.toSet());
        int[] guardsIdx = IntStream.range(0, hash.length()).filter(idx -> {
            void var2_2;
            void var1_1;
            return guardsSet.contains(Character.valueOf(var1_1.charAt((int)var2_2)));
        }).toArray();
        if (guardsIdx.length > 0) {
            startIdx = guardsIdx[0] + 1;
            endIdx = guardsIdx.length > 1 ? guardsIdx[1] : hash.length();
        } else {
            startIdx = 0;
            endIdx = hash.length();
        }
        LongStream decoded = LongStream.empty();
        if (hash.length() > 0) {
            char lottery = hash.charAt(startIdx);
            int length = hash.length() - guardsIdx.length - 1;
            StringBuilder block = new StringBuilder(length);
            char[] cArray = new char[this.alphabet.length];
            char[] decodeSalt = cArray;
            cArray[0] = lottery;
            int saltLength = this.salt.length >= this.alphabet.length ? this.alphabet.length - 1 : this.salt.length;
            System.arraycopy(this.salt, 0, decodeSalt, 1, saltLength);
            int saltLeft = this.alphabet.length - saltLength - 1;
            char[] currentAlphabet = Arrays.copyOf(this.alphabet, this.alphabet.length);
            for (int i = startIdx + 1; i < endIdx; ++i) {
                if (!this.separatorsSet.contains(Character.valueOf(hash.charAt(i)))) {
                    block.append(hash.charAt(i));
                    if (i < endIdx - 1) continue;
                }
                if (block.length() <= 0) continue;
                if (saltLeft > 0) {
                    System.arraycopy(currentAlphabet, 0, decodeSalt, this.alphabet.length - saltLeft, saltLeft);
                }
                this.shuffle(currentAlphabet, decodeSalt);
                long n = this.translate(block.toString().toCharArray(), currentAlphabet);
                decoded = LongStream.concat(decoded, LongStream.of(n));
                block = new StringBuilder(length);
            }
        }
        if (!Objects.equals(hash, this.encode(decodedValue = decoded.toArray()))) {
            void var1_1;
            throw new IllegalArgumentException("invalid hash: " + (String)var1_1);
        }
        return decodedValue;
    }

    private StringBuilder translate(long n, char[] alphabet, StringBuilder sb, int start) {
        long input = n;
        do {
            sb.insert(start, alphabet[(int)(input % (long)alphabet.length)]);
        } while ((input /= (long)alphabet.length) > 0L);
        return sb;
    }

    /*
     * WARNING - void declaration
     */
    private long translate(char[] hash, char[] alphabet) {
        void var3_3;
        long number = 0L;
        Map<Character, Object> alphabetMapping = IntStream.range(0, alphabet.length).mapToObj(idx -> {
            void var1_1;
            char[] cArray;
            return new Object[]{Character.valueOf(cArray[idx]), (int)var1_1};
        }).collect(Collectors.groupingBy(arr -> (Character)arr[0], Collectors.mapping(arr -> (Integer)arr[1], Collectors.reducing(null, (a, b) -> {
            Integer n;
            if (a == null) {
                void var1_1;
                return var1_1;
            }
            return n;
        }))));
        for (int i = 0; i < hash.length; ++i) {
            number += (long)alphabetMapping.computeIfAbsent(Character.valueOf(hash[i]), k -> {
                throw new IllegalArgumentException("Invalid alphabet for hash");
            }).intValue() * (long)Math.pow(alphabet.length, hash.length - i - 1);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private char[] deriveNewAlphabet(char[] alphabet, char[] salt, char lottery) {
        void var1_1;
        int n;
        char[] cArray = new char[alphabet.length];
        char[] newSalt = cArray;
        cArray[0] = lottery;
        int spaceLeft = newSalt.length - 1;
        boolean offset = true;
        if (salt.length > 0 && spaceLeft > 0) {
            void var2_2;
            int length = Math.min(salt.length, spaceLeft);
            System.arraycopy(var2_2, 0, newSalt, 1, length);
            spaceLeft -= length;
            n = length + 1;
        }
        if (spaceLeft > 0) {
            void var3_3;
            System.arraycopy(alphabet, 0, newSalt, n, (int)var3_3);
        }
        return this.shuffle((char[])var1_1, newSalt);
    }

    /*
     * WARNING - void declaration
     */
    private char[] validateAndFilterAlphabet(char[] alphabet, char[] separators) {
        void var1_1;
        Iterator iterator;
        if (alphabet.length < 16) {
            throw new IllegalArgumentException(String.format("alphabet must contain at least %d unique characters: %d", 16, alphabet.length));
        }
        LinkedHashSet seen = new LinkedHashSet(alphabet.length);
        Set invalid = IntStream.range(0, separators.length).mapToObj(idx -> {
            void var1_1;
            return Character.valueOf(separators[var1_1]);
        }).collect(Collectors.toSet());
        IntStream.range(0, alphabet.length).forEach(i -> {
            void var1_1;
            void var3_3;
            if (alphabet[i] == ' ') {
                throw new IllegalArgumentException(String.format("alphabet must not contain spaces: index %d", i));
            }
            Object c = Character.valueOf(alphabet[var3_3]);
            if (!var1_1.contains(c)) {
                Object object;
                void var2_2;
                var2_2.add(object);
            }
        });
        char[] uniqueAlphabet = new char[seen.size()];
        int idx2 = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            uniqueAlphabet[idx2++] = c;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private char[] filterSeparators(char[] separators, char[] alphabet) {
        void var2_2;
        void var1_1;
        Set valid = IntStream.range(0, alphabet.length).mapToObj(idx -> {
            void var1_1;
            return Character.valueOf(alphabet[var1_1]);
        }).collect(Collectors.toSet());
        return IntStream.range(0, separators.length).mapToObj(arg_0 -> Hashids.lambda$filterSeparators$14((char[])var1_1, arg_0)).filter(((Set)var2_2)::contains).map(c -> Character.toString(c.charValue())).collect(Collectors.joining()).toCharArray();
    }

    /*
     * WARNING - void declaration
     */
    private char[] shuffle(char[] alphabet, char[] salt) {
        void var1_1;
        int i = alphabet.length - 1;
        int v = 0;
        int p = 0;
        while (salt.length > 0 && i > 0) {
            char z = salt[v %= salt.length];
            int j = (z + v + (p += z)) % i;
            char tmp = alphabet[j];
            alphabet[j] = alphabet[i];
            alphabet[i] = tmp;
            --i;
            ++v;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Character lambda$filterSeparators$14(char[] separators, int idx) {
        void var1_1;
        return Character.valueOf(separators[var1_1]);
    }
}

