/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Base64 {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;

    /*
     * WARNING - void declaration
     */
    public static byte[] encode(byte[] arr, boolean lineSep) {
        byte[] byArray;
        void var1_1;
        if (arr == null) {
            return null;
        }
        if (var1_1 != false) {
            return java.util.Base64.getMimeEncoder().encode(arr);
        }
        return java.util.Base64.getEncoder().encode(byArray);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static byte[] encodeUrlSafe(byte[] arr, boolean lineSep) {
        void var1_1;
        return Base64Encoder.encodeUrlSafe(arr, (boolean)var1_1);
    }

    public static String encode(CharSequence source) {
        return Base64.encode(source, DEFAULT_CHARSET);
    }

    public static String encodeUrlSafe(CharSequence source) {
        return Base64.encodeUrlSafe(source, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static String encode(CharSequence source, String charset) {
        void var1_1;
        return Base64.encode(source, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeWithoutPadding(CharSequence source, String charset) {
        void var1_1;
        return Base64.encodeWithoutPadding(StrUtil.bytes(source, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String encodeUrlSafe(CharSequence source, String charset) {
        void var1_1;
        return Base64.encodeUrlSafe(source, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String encode(CharSequence source, Charset charset) {
        void var1_1;
        return Base64.encode(StrUtil.bytes(source, (Charset)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeUrlSafe(CharSequence source, Charset charset) {
        void var1_1;
        return Base64.encodeUrlSafe(StrUtil.bytes(source, (Charset)var1_1));
    }

    public static String encode(byte[] source) {
        byte[] byArray;
        if (source == null) {
            return null;
        }
        return java.util.Base64.getEncoder().encodeToString(byArray);
    }

    public static String encodeWithoutPadding(byte[] source) {
        byte[] byArray;
        if (source == null) {
            return null;
        }
        return java.util.Base64.getEncoder().withoutPadding().encodeToString(byArray);
    }

    public static String encodeUrlSafe(byte[] source) {
        byte[] byArray;
        if (source == null) {
            return null;
        }
        return java.util.Base64.getUrlEncoder().withoutPadding().encodeToString(byArray);
    }

    public static String encode(InputStream in) {
        return Base64.encode(IoUtil.readBytes(in));
    }

    public static String encodeUrlSafe(InputStream in) {
        return Base64.encodeUrlSafe(IoUtil.readBytes(in));
    }

    public static String encode(File file) {
        return Base64.encode(FileUtil.readBytes(file));
    }

    public static String encodeUrlSafe(File file) {
        return Base64.encodeUrlSafe(FileUtil.readBytes(file));
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeStr(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        void var2_2;
        void var1_1;
        return StrUtil.str(Base64.encode(arr, (boolean)var1_1, (boolean)var2_2), DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encode(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        void var2_2;
        void var1_1;
        return Base64Encoder.encode(arr, (boolean)var1_1, (boolean)var2_2);
    }

    public static String decodeStrGbk(CharSequence source) {
        return Base64Decoder.decodeStr(source, CharsetUtil.CHARSET_GBK);
    }

    public static String decodeStr(CharSequence source) {
        return Base64Decoder.decodeStr(source);
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeStr(CharSequence source, String charset) {
        void var1_1;
        return Base64.decodeStr(source, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeStr(CharSequence source, Charset charset) {
        void var1_1;
        return Base64Decoder.decodeStr(source, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File decodeToFile(CharSequence base64, File destFile) {
        void var1_1;
        return FileUtil.writeBytes(Base64Decoder.decode(base64), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void decodeToStream(CharSequence base64, OutputStream out, boolean isCloseOut) {
        CharSequence charSequence;
        void var2_2;
        IoUtil.write(out, (boolean)var2_2, Base64Decoder.decode(charSequence));
    }

    public static byte[] decode(CharSequence base64) {
        return Base64Decoder.decode(base64);
    }

    public static byte[] decode(byte[] in) {
        return Base64Decoder.decode(in);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isBase64(CharSequence base64) {
        void var1_1;
        CharSequence charSequence;
        if (base64 == null || base64.length() < 2) {
            return false;
        }
        byte[] bytes = StrUtil.utf8Bytes(base64);
        if (bytes.length != charSequence.length()) {
            return false;
        }
        return Base64.isBase64((byte[])var1_1);
    }

    public static boolean isBase64(byte[] base64Bytes) {
        byte[] byArray;
        if (base64Bytes == null || base64Bytes.length < 3) {
            return false;
        }
        boolean hasPadding = false;
        for (byte base64Byte : byArray) {
            if (hasPadding) {
                if (61 == base64Byte) continue;
                return false;
            }
            if (61 == base64Byte) {
                hasPadding = true;
                continue;
            }
            if (Base64Decoder.isBase64Code(base64Byte) || Base64.isWhiteSpace(base64Byte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

