/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Decoder;
import cn.hutool.core.codec.Encoder;
import cn.hutool.core.util.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;

public class Base62Codec
implements Decoder<byte[], byte[]>,
Encoder<byte[], byte[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int STANDARD_BASE = 256;
    private static final int TARGET_BASE = 62;
    public static Base62Codec INSTANCE = new Base62Codec();

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encode(byte[] data) {
        void var1_1;
        return this.encode((byte[])var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encode(byte[] data, boolean useInverted) {
        void var1_1;
        Base62Encoder base62Encoder = useInverted ? Base62Encoder.INVERTED_ENCODER : Base62Encoder.GMP_ENCODER;
        return base62Encoder.encode((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decode(byte[] encoded) {
        void var1_1;
        return this.decode((byte[])var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] decode(byte[] encoded, boolean useInverted) {
        void var1_1;
        Base62Decoder base62Decoder = useInverted ? Base62Decoder.INVERTED_DECODER : Base62Decoder.GMP_DECODER;
        return base62Decoder.decode((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] translate(byte[] indices, byte[] dictionary) {
        void var2_2;
        byte[] translation = new byte[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            translation[i] = dictionary[indices[i]];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] convert(byte[] message, int sourceBase, int targetBase) {
        void var3_4;
        int estimatedLength = Base62Codec.estimateOutputLength(message.length, sourceBase, targetBase);
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] source = message;
        while (source.length > 0) {
            int n;
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte by : source) {
                int accumulator = (by & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                n = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(n);
            source = quotient.toByteArray();
        }
        for (int i = 0; i < message.length - 1 && message[i] == 0; ++i) {
            out.write(0);
        }
        return ArrayUtil.reverse(var3_4.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    private static int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
        int n;
        void var2_2;
        return (int)Math.ceil(Math.log(sourceBase) / Math.log((double)var2_2) * (double)n);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$000(byte[] x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return Base62Codec.convert(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$100(byte[] x0, byte[] x1) {
        void var1_1;
        return Base62Codec.translate(x0, (byte[])var1_1);
    }

    public static class Base62Decoder
    implements Decoder<byte[], byte[]> {
        public static Base62Decoder GMP_DECODER = new Base62Decoder(Base62Encoder.access$200());
        public static Base62Decoder INVERTED_DECODER = new Base62Decoder(Base62Encoder.access$300());
        private final byte[] lookupTable = new byte[123];

        public Base62Decoder(byte[] alphabet) {
            for (int i = 0; i < alphabet.length; ++i) {
                this.lookupTable[alphabet[i]] = (byte)i;
            }
        }

        @Override
        public byte[] decode(byte[] encoded) {
            byte[] byArray = Base62Codec.access$100(encoded, this.lookupTable);
            return Base62Codec.access$000(byArray, 62, 256);
        }
    }

    public static class Base62Encoder
    implements Encoder<byte[], byte[]> {
        private static final byte[] GMP = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        private static final byte[] INVERTED = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
        public static Base62Encoder GMP_ENCODER = new Base62Encoder(GMP);
        public static Base62Encoder INVERTED_ENCODER = new Base62Encoder(INVERTED);
        private final byte[] alphabet;

        /*
         * WARNING - void declaration
         */
        public Base62Encoder(byte[] alphabet) {
            void var1_1;
            this.alphabet = var1_1;
        }

        @Override
        public byte[] encode(byte[] data) {
            byte[] byArray = Base62Codec.access$000(data, 256, 62);
            return Base62Codec.access$100(byArray, this.alphabet);
        }

        static /* synthetic */ byte[] access$200() {
            return GMP;
        }

        static /* synthetic */ byte[] access$300() {
            return INVERTED;
        }
    }
}

