/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Decoder;
import cn.hutool.core.codec.Encoder;
import cn.hutool.core.util.StrUtil;
import java.util.Arrays;

public class Base58Codec
implements Decoder<CharSequence, byte[]>,
Encoder<byte[], String> {
    public static Base58Codec INSTANCE = new Base58Codec();

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(byte[] data) {
        void var1_1;
        return Base58Encoder.ENCODER.encode((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decode(CharSequence encoded) throws IllegalArgumentException {
        void var1_1;
        return Base58Decoder.DECODER.decode((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int n;
        void i;
        int remainder = 0;
        while (i < number.length) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            n = temp % divisor;
            ++i;
        }
        return (byte)n;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte access$000(byte[] x0, int x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Base58Codec.divmod(x0, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    public static class Base58Decoder
    implements Decoder<CharSequence, byte[]> {
        public static Base58Decoder DECODER = new Base58Decoder("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz");
        private final byte[] lookupTable;

        /*
         * WARNING - void declaration
         */
        public Base58Decoder(String alphabet) {
            void var2_2;
            byte[] lookupTable = new byte[123];
            Arrays.fill(lookupTable, (byte)-1);
            int length = alphabet.length();
            for (int i = 0; i < length; ++i) {
                lookupTable[alphabet.charAt((int)i)] = (byte)i;
            }
            this.lookupTable = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] decode(CharSequence encoded) {
            void var3_4;
            int zeros;
            if (encoded.length() == 0) {
                return new byte[0];
            }
            byte[] input58 = new byte[encoded.length()];
            for (int i = 0; i < encoded.length(); ++i) {
                char c = encoded.charAt(i);
                int digit = c < '\u0080' ? this.lookupTable[c] : -1;
                if (digit < 0) {
                    throw new IllegalArgumentException(StrUtil.format("Invalid char '{}' at [{}]", Character.valueOf(c), i));
                }
                input58[i] = (byte)digit;
            }
            for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
            }
            byte[] decoded = new byte[encoded.length()];
            int outputStart = decoded.length;
            int inputStart = zeros;
            while (inputStart < input58.length) {
                decoded[--outputStart] = Base58Codec.access$000(input58, inputStart, 58, 256);
                if (input58[inputStart] != 0) continue;
                ++inputStart;
            }
            while (outputStart < decoded.length && decoded[outputStart] == 0) {
                ++outputStart;
            }
            return Arrays.copyOfRange(decoded, outputStart - var3_4, decoded.length);
        }
    }

    public static class Base58Encoder
    implements Encoder<byte[], String> {
        private static final String DEFAULT_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
        public static final Base58Encoder ENCODER = new Base58Encoder("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray());
        private final char[] alphabet;
        private final char alphabetZero;

        /*
         * WARNING - void declaration
         */
        public Base58Encoder(char[] alphabet) {
            void var1_1;
            this.alphabet = alphabet;
            this.alphabetZero = var1_1[0];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String encode(byte[] data) {
            void var3_3;
            int zeroCount;
            if (data == null) {
                return null;
            }
            if (data.length == 0) {
                return "";
            }
            for (zeroCount = 0; zeroCount < data.length && data[zeroCount] == 0; ++zeroCount) {
            }
            data = Arrays.copyOf(data, data.length);
            char[] encoded = new char[data.length << 1];
            int outputStart = encoded.length;
            int inputStart = zeroCount;
            while (inputStart < data.length) {
                encoded[--outputStart] = this.alphabet[Base58Codec.access$000(data, inputStart, 256, 58)];
                if (data[inputStart] != 0) continue;
                ++inputStart;
            }
            while (outputStart < encoded.length && encoded[outputStart] == this.alphabetZero) {
                ++outputStart;
            }
            while (--zeroCount >= 0) {
                encoded[--outputStart] = this.alphabetZero;
            }
            return new String(encoded, outputStart, ((void)var3_3).length - outputStart);
        }
    }
}

