/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Base58Codec;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.exceptions.ValidateException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Base58 {
    private static final int CHECKSUM_SIZE = 4;

    /*
     * WARNING - void declaration
     */
    public static String encodeChecked(Integer version, byte[] data) {
        void var1_1;
        return Base58.encode(Base58.addChecksum(version, (byte[])var1_1));
    }

    public static String encode(byte[] data) {
        byte[] byArray;
        return Base58Codec.INSTANCE.encode(byArray);
    }

    public static byte[] decodeChecked(CharSequence encoded) throws ValidateException {
        try {
            return Base58.decodeChecked(encoded, true);
        }
        catch (ValidateException validateException) {
            CharSequence charSequence;
            return Base58.decodeChecked(charSequence, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decodeChecked(CharSequence encoded, boolean withVersion) throws ValidateException {
        void var1_1;
        byte[] byArray = Base58.decode(encoded);
        Object object = byArray;
        return Base58.verifyAndRemoveChecksum(byArray, (boolean)var1_1);
    }

    public static byte[] decode(CharSequence encoded) {
        CharSequence charSequence;
        return Base58Codec.INSTANCE.decode(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] verifyAndRemoveChecksum(byte[] data, boolean withVersion) {
        void var1_2;
        void var2_3;
        byte[] byArray;
        byte[] payload = Arrays.copyOfRange(data, withVersion ? 1 : 0, data.length - 4);
        byte[] checksum = Arrays.copyOfRange(data, data.length - 4, data.length);
        byte[] expectedChecksum = Base58.checksum(payload);
        if (!Arrays.equals(byArray, (byte[])var2_3)) {
            throw new ValidateException("Base58 checksum is invalid");
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] addChecksum(Integer version, byte[] payload) {
        void var2_2;
        void var1_1;
        Object object;
        byte[] addressBytes;
        if (version != null) {
            byte[] byArray = new byte[1 + payload.length + 4];
            addressBytes = byArray;
            byArray[0] = (byte)((Integer)object).intValue();
            System.arraycopy(payload, 0, addressBytes, 1, payload.length);
        } else {
            addressBytes = new byte[payload.length + 4];
            System.arraycopy(payload, 0, addressBytes, 0, payload.length);
        }
        byte[] byArray = Base58.checksum((byte[])var1_1);
        object = byArray;
        System.arraycopy(byArray, 0, addressBytes, addressBytes.length - 4, 4);
        return var2_2;
    }

    private static byte[] checksum(byte[] data) {
        byte[] byArray = Base58.hash256(Base58.hash256(data));
        return Arrays.copyOfRange(byArray, 0, 4);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] hash256(byte[] data) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }
}

