/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Decoder;
import cn.hutool.core.codec.Encoder;
import java.util.Arrays;

public class Base32Codec
implements Decoder<CharSequence, byte[]>,
Encoder<byte[], String> {
    public static Base32Codec INSTANCE = new Base32Codec();

    /*
     * WARNING - void declaration
     */
    @Override
    public String encode(byte[] data) {
        void var1_1;
        return this.encode((byte[])var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(byte[] data, boolean useHex) {
        void var1_1;
        Base32Encoder base32Encoder = useHex ? Base32Encoder.HEX_ENCODER : Base32Encoder.ENCODER;
        return base32Encoder.encode((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decode(CharSequence encoded) {
        void var1_1;
        return this.decode((CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] decode(CharSequence encoded, boolean useHex) {
        void var1_1;
        Base32Decoder base32Decoder = useHex ? Base32Decoder.HEX_DECODER : Base32Decoder.DECODER;
        return base32Decoder.decode((CharSequence)var1_1);
    }

    public static class Base32Decoder
    implements Decoder<CharSequence, byte[]> {
        private static final char BASE_CHAR = '0';
        public static final Base32Decoder DECODER = new Base32Decoder("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
        public static final Base32Decoder HEX_DECODER = new Base32Decoder("0123456789ABCDEFGHIJKLMNOPQRSTUV");
        private final byte[] lookupTable = new byte[128];

        public Base32Decoder(String alphabet) {
            Arrays.fill(this.lookupTable, (byte)-1);
            int length = alphabet.length();
            for (int i = 0; i < length; ++i) {
                char c = alphabet.charAt(i);
                this.lookupTable[c - 48] = (byte)i;
                if (c < 'A' || c > 'Z') continue;
                this.lookupTable[Character.toLowerCase((char)var3_4) - 48] = (byte)i;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] decode(CharSequence encoded2) {
            String base32 = encoded2.toString();
            int encoded2 = base32.endsWith("=") ? base32.indexOf("=") * 5 / 8 : base32.length() * 5 / 8;
            byte[] bytes = new byte[encoded2];
            int index = 0;
            int offset = 0;
            for (int i = 0; i < base32.length(); ++i) {
                void var3_7;
                byte digit;
                int lookup = base32.charAt(i) - 48;
                if (lookup < 0 || lookup >= this.lookupTable.length || (digit = this.lookupTable[lookup]) < 0) continue;
                if (index <= 3) {
                    if ((index = (index + 5) % 8) == 0) {
                        int n = offset++;
                        bytes[n] = (byte)(bytes[n] | digit);
                        if (offset < bytes.length) continue;
                        break;
                    }
                    int n = offset;
                    bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                    continue;
                }
                index = (index + 5) % 8;
                int n = offset++;
                bytes[n] = (byte)(bytes[n] | digit >>> index);
                if (offset >= bytes.length) break;
                int n2 = offset;
                bytes[n2] = (byte)(bytes[n2] | var3_7 << 8 - index);
            }
            return bytes;
        }
    }

    public static class Base32Encoder
    implements Encoder<byte[], String> {
        private static final String DEFAULT_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
        private static final String HEX_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
        private static final Character DEFAULT_PAD = Character.valueOf('=');
        private static final int[] BASE32_FILL = new int[]{-1, 4, 1, 6, 3};
        public static final Base32Encoder ENCODER = new Base32Encoder("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", DEFAULT_PAD);
        public static final Base32Encoder HEX_ENCODER = new Base32Encoder("0123456789ABCDEFGHIJKLMNOPQRSTUV", DEFAULT_PAD);
        private final char[] alphabet;
        private final Character pad;

        /*
         * WARNING - void declaration
         */
        public Base32Encoder(String alphabet, Character pad) {
            void var2_2;
            void var1_1;
            this.alphabet = var1_1.toCharArray();
            this.pad = var2_2;
        }

        @Override
        public String encode(byte[] data) {
            int i = 0;
            int index = 0;
            int encodeLen = (data.length << 3) / 5;
            if (encodeLen != 0) {
                encodeLen = encodeLen + 1 + BASE32_FILL[(data.length << 3) % 5];
            }
            StringBuilder base32 = new StringBuilder(encodeLen);
            while (i < data.length) {
                int digit;
                int currByte;
                int n = currByte = data[i] >= 0 ? data[i] : data[i] + 256;
                if (index > 3) {
                    int nextByte = i + 1 < data.length ? (data[i + 1] >= 0 ? data[i + 1] : data[i + 1] + 256) : 0;
                    digit = currByte & 255 >> index;
                    index = (index + 5) % 8;
                    digit <<= index;
                    digit |= nextByte >> 8 - index;
                    ++i;
                } else {
                    digit = digit >> 8 - (index + 5) & 0x1F;
                    if ((index = (index + 5) % 8) == 0) {
                        ++i;
                    }
                }
                base32.append(this.alphabet[digit]);
            }
            if (this.pad != null) {
                while (base32.length() < encodeLen) {
                    base32.append(this.pad.charValue());
                }
            }
            return base32.toString();
        }
    }
}

