/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Decoder;
import cn.hutool.core.codec.Encoder;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.StrUtil;

public class Base16Codec
implements Decoder<CharSequence, byte[]>,
Encoder<byte[], char[]> {
    public static final Base16Codec CODEC_LOWER = new Base16Codec(true);
    public static final Base16Codec CODEC_UPPER = new Base16Codec(false);
    private final char[] alphabets;

    /*
     * WARNING - void declaration
     */
    public Base16Codec(boolean lowerCase) {
        void var1_1;
        this.alphabets = (var1_1 != false ? "0123456789abcdef" : "0123456789ABCDEF").toCharArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char[] encode(byte[] data) {
        void var3_3;
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = this.alphabets[(0xF0 & data[i]) >>> 4];
            out[j++] = this.alphabets[0xF & data[i]];
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decode(CharSequence encoded) {
        void var3_3;
        if (StrUtil.isEmpty(encoded)) {
            return null;
        }
        int len = (encoded = StrUtil.cleanBlank(encoded)).length();
        if ((len & 1) != 0) {
            encoded = "0" + encoded;
            len = encoded.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Base16Codec.toDigit(encoded.charAt(j), j) << 4;
            f |= Base16Codec.toDigit(encoded.charAt(++j), j);
            ++j;
            out[i] = (byte)f;
            ++i;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String toUnicodeHex(char ch) {
        void var1_1;
        return "\\u" + this.alphabets[ch >> 12 & 0xF] + this.alphabets[ch >> 8 & 0xF] + this.alphabets[ch >> 4 & 0xF] + this.alphabets[var1_1 & 0xF];
    }

    /*
     * WARNING - void declaration
     */
    public void appendHex(StringBuilder builder, byte b) {
        void var2_2;
        void var1_1;
        void var3_3;
        int high = (b & 0xF0) >>> 4;
        int low = b & 0xF;
        builder.append(this.alphabets[var3_3]);
        var1_1.append(this.alphabets[var2_2]);
    }

    /*
     * WARNING - void declaration
     */
    private static int toDigit(char ch, int index) {
        void var2_2;
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            void var1_1;
            char c;
            throw new UtilException("Illegal hexadecimal character {} at index {}", Character.valueOf(c), (int)var1_1);
        }
        return (int)var2_2;
    }
}

