/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.builder;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.builder.IDKey;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HashCodeBuilder
implements Builder<Integer> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_VALUE = 17;
    private static final int DEFAULT_MULTIPLIER_VALUE = 37;
    private static final ThreadLocal<Set<IDKey>> REGISTRY = new ThreadLocal();
    private final int iConstant;
    private int iTotal;

    private static Set<IDKey> getRegistry() {
        return REGISTRY.get();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isRegistered(Object value) {
        Object object;
        void var1_1;
        Set<IDKey> registry = HashCodeBuilder.getRegistry();
        return registry != null && var1_1.contains(new IDKey(object));
    }

    /*
     * WARNING - void declaration
     */
    private static void reflectionAppend(Object object, Class<?> clazz, HashCodeBuilder builder, boolean useTransients, String[] excludeFields) {
        if (HashCodeBuilder.isRegistered(object)) {
            return;
        }
        try {
            void var1_1;
            HashCodeBuilder.register(object);
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (void field : var1_1) {
                if (ArrayUtil.contains(excludeFields, field.getName()) || field.getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                try {
                    Object fieldValue = field.get(object);
                    builder.append(fieldValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
        }
        catch (Throwable throwable) {
            Object object2;
            HashCodeBuilder.unregister(object2);
            throw throwable;
        }
        HashCodeBuilder.unregister(object);
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object) {
        void var2_2;
        void var1_1;
        return HashCodeBuilder.reflectionHashCode(initialNonZeroOddNumber, (int)var1_1, var2_2, false, null, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object, boolean testTransients) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HashCodeBuilder.reflectionHashCode(initialNonZeroOddNumber, (int)var1_1, var2_2, (boolean)var3_3, null, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, T object, boolean testTransients, Class<? super T> reflectUpToClass, String ... excludeFields) {
        void var0_1;
        Class<?> clazz;
        if (object == null) {
            throw new IllegalArgumentException("The object to build a hash code for must not be null");
        }
        HashCodeBuilder builder = new HashCodeBuilder(initialNonZeroOddNumber, multiplierNonZeroOddNumber);
        HashCodeBuilder.reflectionAppend(object, clazz, builder, testTransients, excludeFields);
        for (clazz = object.getClass(); clazz.getSuperclass() != null && clazz != reflectUpToClass; clazz = clazz.getSuperclass()) {
            HashCodeBuilder.reflectionAppend(object, clazz, builder, testTransients, excludeFields);
        }
        return var0_1.toHashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionHashCode(Object object, boolean testTransients) {
        void var1_1;
        Object object2;
        return HashCodeBuilder.reflectionHashCode(17, 37, object2, (boolean)var1_1, null, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionHashCode(Object object, Collection<String> excludeFields) {
        void var1_1;
        return HashCodeBuilder.reflectionHashCode(object, ArrayUtil.toArray(var1_1, String.class));
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionHashCode(Object object, String ... excludeFields) {
        void var1_1;
        Object object2;
        return HashCodeBuilder.reflectionHashCode(17, 37, object2, false, null, (String[])var1_1);
    }

    static void register(Object value) {
        Class<HashCodeBuilder> clazz = HashCodeBuilder.class;
        synchronized (HashCodeBuilder.class) {
            Object object;
            if (HashCodeBuilder.getRegistry() == null) {
                REGISTRY.set(new HashSet());
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            HashCodeBuilder.getRegistry().add(new IDKey(object));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void unregister(Object value) {
        Set<IDKey> registry = HashCodeBuilder.getRegistry();
        if (registry != null) {
            Class<HashCodeBuilder> clazz;
            registry.remove(new IDKey(clazz));
            clazz = HashCodeBuilder.class;
            synchronized (HashCodeBuilder.class) {
                void var1_1;
                registry = HashCodeBuilder.getRegistry();
                if (registry != null && var1_1.isEmpty()) {
                    REGISTRY.remove();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }

    public HashCodeBuilder() {
        this.iConstant = 37;
        this.iTotal = 17;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder(int initialOddNumber, int multiplierOddNumber) {
        void var1_1;
        void var2_2;
        Assert.isTrue(initialOddNumber % 2 != 0, "HashCodeBuilder requires an odd initial value", new Object[0]);
        Assert.isTrue(multiplierOddNumber % 2 != 0, "HashCodeBuilder requires an odd multiplier", new Object[0]);
        this.iConstant = var2_2;
        this.iTotal = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(boolean value) {
        void var1_1;
        this.iTotal = this.iTotal * this.iConstant + (var1_1 != false ? 0 : 1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(boolean[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((boolean)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(byte value) {
        void var1_1;
        this.iTotal = this.iTotal * this.iConstant + var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(byte[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((byte)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(char value) {
        void var1_1;
        this.iTotal = this.iTotal * this.iConstant + var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(char[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((char)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(double value) {
        void var1_1;
        return this.append(Double.doubleToLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(double[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((double)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(float value) {
        void var1_1;
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(float[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((float)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(int value) {
        void var1_1;
        this.iTotal = this.iTotal * this.iConstant + var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(int[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((int)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(long value) {
        void var1_1;
        void v0 = var1_1;
        this.iTotal = this.iTotal * this.iConstant + (int)(v0 ^ v0 >> 32);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(long[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((long)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
        } else if (object.getClass().isArray()) {
            if (object instanceof long[]) {
                this.append((long[])object);
            } else if (object instanceof int[]) {
                this.append((int[])object);
            } else if (object instanceof short[]) {
                this.append((short[])object);
            } else if (object instanceof char[]) {
                this.append((char[])object);
            } else if (object instanceof byte[]) {
                this.append((byte[])object);
            } else if (object instanceof double[]) {
                this.append((double[])object);
            } else if (object instanceof float[]) {
                this.append((float[])object);
            } else if (object instanceof boolean[]) {
                this.append((boolean[])object);
            } else {
                this.append((Object[])object);
            }
        } else {
            void var1_1;
            this.iTotal = this.iTotal * this.iConstant + var1_1.hashCode();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(Object[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append(element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(short value) {
        void var1_1;
        this.iTotal = this.iTotal * this.iConstant + var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder append(short[] array) {
        if (array == null) {
            this.iTotal *= this.iConstant;
        } else {
            void var1_1;
            for (void element : var1_1) {
                this.append((short)element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HashCodeBuilder appendSuper(int superHashCode) {
        void var1_1;
        this.iTotal = this.iTotal * this.iConstant + var1_1;
        return this;
    }

    public int toHashCode() {
        return this.iTotal;
    }

    @Override
    public Integer build() {
        return this.toHashCode();
    }

    public int hashCode() {
        return this.toHashCode();
    }
}

