/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.builder;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.builder.IDKey;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class EqualsBuilder
implements Builder<Boolean> {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<Set<Pair<IDKey, IDKey>>> REGISTRY = new ThreadLocal();
    private boolean isEquals = true;

    static Set<Pair<IDKey, IDKey>> getRegistry() {
        return REGISTRY.get();
    }

    /*
     * WARNING - void declaration
     */
    static Pair<IDKey, IDKey> getRegisterPair(Object lhs, Object rhs) {
        void var1_1;
        Object object;
        Object left = new IDKey(lhs);
        IDKey right = new IDKey(rhs);
        return new Pair<Object, void>(object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isRegistered(Object lhs, Object rhs) {
        void var1_1;
        void var2_2;
        Pair<IDKey, IDKey> pair;
        Set<Pair<IDKey, IDKey>> registry = EqualsBuilder.getRegistry();
        Pair<IDKey, IDKey> pair2 = EqualsBuilder.getRegisterPair(lhs, rhs);
        Pair<IDKey, IDKey> swappedPair = new Pair<IDKey, IDKey>(pair2.getKey(), pair2.getValue());
        return registry != null && (registry.contains(pair) || var2_2.contains(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static void register(Object lhs, Object rhs) {
        Class<EqualsBuilder> clazz = EqualsBuilder.class;
        synchronized (EqualsBuilder.class) {
            Pair<IDKey, IDKey> pair;
            void var1_2;
            if (EqualsBuilder.getRegistry() == null) {
                REGISTRY.set(new HashSet());
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            Set<Pair<IDKey, IDKey>> registry = EqualsBuilder.getRegistry();
            Pair<IDKey, IDKey> pair2 = EqualsBuilder.getRegisterPair(lhs, var1_2);
            clazz.add((EqualsBuilder)((Object)pair));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void unregister(Object lhs, Object rhs) {
        Set<Pair<IDKey, IDKey>> registry = EqualsBuilder.getRegistry();
        if (registry != null) {
            Pair<IDKey, IDKey> pair;
            void var1_1;
            Pair<IDKey, IDKey> pair2 = EqualsBuilder.getRegisterPair(lhs, var1_1);
            registry.remove(pair);
            pair = EqualsBuilder.class;
            synchronized (EqualsBuilder.class) {
                void var2_3;
                registry = EqualsBuilder.getRegistry();
                if (registry != null && var2_3.isEmpty()) {
                    REGISTRY.remove();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, Collection<String> excludeFields) {
        void var2_2;
        void var1_1;
        return EqualsBuilder.reflectionEquals(lhs, (Object)var1_1, ArrayUtil.toArray(var2_2, String.class));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, String ... excludeFields) {
        void var2_2;
        void var1_1;
        return EqualsBuilder.reflectionEquals(lhs, (Object)var1_1, false, null, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients) {
        void var2_2;
        void var1_1;
        return EqualsBuilder.reflectionEquals(lhs, (Object)var1_1, (boolean)var2_2, null, new String[0]);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class<?> reflectUpToClass, String ... excludeFields) {
        EqualsBuilder equalsBuilder;
        block13: {
            Class<?> testClass;
            if (lhs == rhs) {
                return true;
            }
            if (lhs == null || rhs == null) {
                return false;
            }
            Class<?> lhsClass = lhs.getClass();
            Class<?> rhsClass = rhs.getClass();
            if (lhsClass.isInstance(rhs)) {
                testClass = lhsClass;
                if (!rhsClass.isInstance(lhs)) {
                    testClass = rhsClass;
                }
            } else if (rhsClass.isInstance(lhs)) {
                testClass = rhsClass;
                if (!lhsClass.isInstance(rhs)) {
                    testClass = lhsClass;
                }
            } else {
                return false;
            }
            equalsBuilder = new EqualsBuilder();
            try {
                if (testClass.isArray()) {
                    equalsBuilder.append(lhs, rhs);
                    break block13;
                }
                while (true) {
                    EqualsBuilder.reflectionAppend(lhs, rhs, testClass, equalsBuilder, testTransients, excludeFields);
                    if (testClass.getSuperclass() != null && testClass != reflectUpToClass) {
                        testClass = testClass.getSuperclass();
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return equalsBuilder.isEquals();
    }

    /*
     * WARNING - void declaration
     */
    private static void reflectionAppend(Object lhs, Object rhs, Class<?> clazz, EqualsBuilder builder, boolean useTransients, String[] excludeFields) {
        if (EqualsBuilder.isRegistered(lhs, rhs)) {
            return;
        }
        try {
            EqualsBuilder.register(lhs, rhs);
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length && builder.isEquals; ++i) {
                AccessibleObject f = fields[i];
                if (ArrayUtil.contains(excludeFields, ((Field)f).getName()) || ((Field)f).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers())) continue;
                try {
                    builder.append(((Field)f).get(lhs), ((Field)f).get(rhs));
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            Object object;
            EqualsBuilder.unregister(object, var1_1);
            throw throwable;
        }
        EqualsBuilder.unregister(lhs, rhs);
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder appendSuper(boolean superEquals) {
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(Object lhs, Object rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            return this.setEquals(false);
        }
        if (ArrayUtil.isArray(lhs)) {
            return this.setEquals(ArrayUtil.equals(lhs, rhs));
        }
        return this.setEquals(var1_1.equals(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(long lhs, long rhs) {
        void var3_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1 == var3_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(int lhs, int rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1 == var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(short lhs, short rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1 == var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(char lhs, char rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1 == var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(byte lhs, byte rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1 == var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(double lhs, double rhs) {
        void var3_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        return this.append(Double.doubleToLongBits((double)var1_1), Double.doubleToLongBits((double)var3_2));
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(float lhs, float rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        return this.append(Float.floatToIntBits((float)var1_1), Float.floatToIntBits((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public EqualsBuilder append(boolean lhs, boolean rhs) {
        void var2_2;
        void var1_1;
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = var1_1 == var2_2;
        return this;
    }

    public boolean isEquals() {
        return this.isEquals;
    }

    @Override
    public Boolean build() {
        return this.isEquals();
    }

    /*
     * WARNING - void declaration
     */
    protected EqualsBuilder setEquals(boolean isEquals) {
        void var1_1;
        this.isEquals = var1_1;
        return this;
    }

    public void reset() {
        this.isEquals = true;
    }
}

