/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.builder;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;

public class CompareToBuilder
implements Builder<Integer> {
    private static final long serialVersionUID = 1L;
    private int comparison = 0;

    /*
     * WARNING - void declaration
     */
    public static int reflectionCompare(Object lhs, Object rhs) {
        void var1_1;
        return CompareToBuilder.reflectionCompare(lhs, (Object)var1_1, false, null, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionCompare(Object lhs, Object rhs, boolean compareTransients) {
        void var2_2;
        void var1_1;
        return CompareToBuilder.reflectionCompare(lhs, (Object)var1_1, (boolean)var2_2, null, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionCompare(Object lhs, Object rhs, Collection<String> excludeFields) {
        void var2_2;
        void var1_1;
        return CompareToBuilder.reflectionCompare(lhs, (Object)var1_1, ArrayUtil.toArray(var2_2, String.class));
    }

    /*
     * WARNING - void declaration
     */
    public static int reflectionCompare(Object lhs, Object rhs, String ... excludeFields) {
        void var2_2;
        void var1_1;
        return CompareToBuilder.reflectionCompare(lhs, (Object)var1_1, false, null, (String[])var2_2);
    }

    public static int reflectionCompare(Object lhs, Object rhs, boolean compareTransients, Class<?> reflectUpToClass, String ... excludeFields) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        Class<?> lhsClazz = lhs.getClass();
        if (!lhsClazz.isInstance(rhs)) {
            throw new ClassCastException();
        }
        CompareToBuilder compareToBuilder = new CompareToBuilder();
        CompareToBuilder.reflectionAppend(lhs, rhs, lhsClazz, compareToBuilder, compareTransients, excludeFields);
        while (lhsClazz.getSuperclass() != null && lhsClazz != reflectUpToClass) {
            lhsClazz = lhsClazz.getSuperclass();
            CompareToBuilder.reflectionAppend(lhs, rhs, lhsClazz, compareToBuilder, compareTransients, excludeFields);
        }
        return compareToBuilder.toComparison();
    }

    private static void reflectionAppend(Object lhs, Object rhs, Class<?> clazz, CompareToBuilder builder, boolean useTransients, String[] excludeFields) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (int i = 0; i < fields.length && builder.comparison == 0; ++i) {
            AccessibleObject f = fields[i];
            if (ArrayUtil.contains(excludeFields, ((Field)f).getName()) || ((Field)f).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers())) continue;
            try {
                builder.append(((Field)f).get(lhs), ((Field)f).get(rhs));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder appendSuper(int superCompareTo) {
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(Object lhs, Object rhs) {
        void var2_2;
        void var1_1;
        return this.append(var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(Object lhs, Object rhs, Comparator<?> comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.getClass().isArray()) {
            if (lhs instanceof long[]) {
                this.append((long[])lhs, (long[])rhs);
            } else if (lhs instanceof int[]) {
                this.append((int[])lhs, (int[])rhs);
            } else if (lhs instanceof short[]) {
                this.append((short[])lhs, (short[])rhs);
            } else if (lhs instanceof char[]) {
                this.append((char[])lhs, (char[])rhs);
            } else if (lhs instanceof byte[]) {
                this.append((byte[])lhs, (byte[])rhs);
            } else if (lhs instanceof double[]) {
                this.append((double[])lhs, (double[])rhs);
            } else if (lhs instanceof float[]) {
                this.append((float[])lhs, (float[])rhs);
            } else if (lhs instanceof boolean[]) {
                this.append((boolean[])lhs, (boolean[])rhs);
            } else {
                this.append((Object[])lhs, (Object[])rhs, comparator);
            }
        } else if (comparator == null) {
            Comparable comparable = (Comparable)lhs;
            this.comparison = comparable.compareTo(rhs);
        } else {
            void var2_2;
            void var1_1;
            void var3_3;
            this.comparison = var3_3.compare(var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(long lhs, long rhs) {
        void var3_2;
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Long.compare((long)var1_1, (long)var3_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(int lhs, int rhs) {
        void var2_2;
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Integer.compare((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(short lhs, short rhs) {
        void var2_2;
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Short.compare((short)var1_1, (short)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(char lhs, char rhs) {
        void var2_2;
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Character.compare((char)var1_1, (char)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(byte lhs, byte rhs) {
        void var2_2;
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Byte.compare((byte)var1_1, (byte)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(double lhs, double rhs) {
        void var3_2;
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Double.compare((double)var1_1, (double)var3_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(float lhs, float rhs) {
        void var2_2;
        void var1_1;
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Float.compare((float)var1_1, (float)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(boolean lhs, boolean rhs) {
        void var1_1;
        void var2_2;
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == var2_2) {
            return this;
        }
        this.comparison = var1_1 == false ? -1 : 1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CompareToBuilder append(Object[] lhs, Object[] rhs) {
        void var2_2;
        void var1_1;
        return this.append((Object[])var1_1, (Object[])var2_2, (Comparator<?>)null);
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs, Comparator<?> comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i], comparator);
        }
        return this;
    }

    public CompareToBuilder append(long[] lhs, long[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(int[] lhs, int[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(short[] lhs, short[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(char[] lhs, char[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(byte[] lhs, byte[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(double[] lhs, double[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(float[] lhs, float[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public CompareToBuilder append(boolean[] lhs, boolean[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < lhs.length && this.comparison == 0; ++i) {
            this.append(lhs[i], rhs[i]);
        }
        return this;
    }

    public int toComparison() {
        return this.comparison;
    }

    @Override
    public Integer build() {
        return this.toComparison();
    }
}

