/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.PropIgnore;
import cn.hutool.core.bean.BeanException;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.TypeUtil;
import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class PropDesc {
    final Field field;
    protected Method getter;
    protected Method setter;

    /*
     * WARNING - void declaration
     */
    public PropDesc(Field field, Method getter, Method setter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.field = var1_1;
        this.getter = ClassUtil.setAccessible((Method)var2_2);
        this.setter = ClassUtil.setAccessible((Method)var3_3);
    }

    public String getFieldName() {
        return ReflectUtil.getFieldName(this.field);
    }

    public String getRawFieldName() {
        if (this.field == null) {
            return null;
        }
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (this.field != null) {
            return TypeUtil.getType(this.field);
        }
        PropDesc propDesc = this;
        return propDesc.findPropType(propDesc.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (this.field != null) {
            return TypeUtil.getClass(this.field);
        }
        PropDesc propDesc = this;
        return propDesc.findPropClass(propDesc.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReadable(boolean checkTransient) {
        void var1_1;
        if (this.getter == null && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (var1_1 != false && this.isTransientForGet()) {
            return false;
        }
        return false == this.isIgnoreGet();
    }

    /*
     * WARNING - void declaration
     */
    public Object getValue(Object bean) {
        if (this.getter != null) {
            return ReflectUtil.invoke(bean, this.getter, new Object[0]);
        }
        if (ModifierUtil.isPublic(this.field)) {
            void var1_1;
            return ReflectUtil.getFieldValue((Object)var1_1, this.field);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean);
            }
            catch (Exception e) {
                void var1_2;
                if (ignoreError) break block3;
                throw new BeanException((Throwable)var1_2, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (result != null && targetType != null) {
            void var3_4;
            void var2_3;
            return Convert.convertWithCheck((Type)var2_3, result, null, (boolean)var3_4);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isWritable(boolean checkTransient) {
        void var1_1;
        if (this.setter == null && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (var1_1 != false && this.isTransientForSet()) {
            return false;
        }
        return false == this.isIgnoreSet();
    }

    /*
     * WARNING - void declaration
     */
    public PropDesc setValue(Object bean, Object value) {
        if (this.setter != null) {
            ReflectUtil.invoke(bean, this.setter, value);
        } else if (ModifierUtil.isPublic(this.field)) {
            void var2_2;
            void var1_1;
            ReflectUtil.setFieldValue((Object)var1_1, this.field, (Object)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.setValue(var1_1, var2_2, (boolean)var3_3, ignoreError, true);
    }

    /*
     * WARNING - void declaration
     */
    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            void var3_3;
            Class<?> propClass;
            if (value == null && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean)) {
                return this;
            }
            if (value != null && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (value != null || var3_3 == false) {
                try {
                    void var2_2;
                    void var1_1;
                    this.setValue(var1_1, var2_2);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private Type findPropType(Method getter, Method setter) {
        void var3_3;
        Type type = null;
        if (getter != null) {
            void var1_1;
            type = TypeUtil.getReturnType((Method)var1_1);
        }
        if (type == null && setter != null) {
            void var2_2;
            type = TypeUtil.getParamType((Method)var2_2, 0);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> findPropClass(Method getter, Method setter) {
        void var3_3;
        Class<?> type = null;
        if (getter != null) {
            void var1_1;
            type = TypeUtil.getReturnClass((Method)var1_1);
        }
        if (type == null && setter != null) {
            void var2_2;
            type = TypeUtil.getFirstParamClass((Method)var2_2);
        }
        return var3_3;
    }

    private boolean isIgnoreSet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.setter, PropIgnore.class);
    }

    private boolean isIgnoreGet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.getter, PropIgnore.class);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTransientForGet() {
        void var1_1;
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierUtil.ModifierType.TRANSIENT);
        if (!isTransient && this.getter != null && !(isTransient = ModifierUtil.hasModifier(this.getter, ModifierUtil.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.getter, Transient.class);
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTransientForSet() {
        void var1_1;
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierUtil.ModifierType.TRANSIENT);
        if (!isTransient && this.setter != null && !(isTransient = ModifierUtil.hasModifier(this.setter, ModifierUtil.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.setter, Transient.class);
        }
        return (boolean)var1_1;
    }
}

