/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanDescCache;
import cn.hutool.core.bean.BeanException;
import cn.hutool.core.bean.BeanInfoCache;
import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.bean.DynaBean;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.bean.copier.BeanCopier;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BeanUtil {
    public static boolean isReadableBean(Class<?> clazz) {
        Class<?> clazz2;
        return BeanUtil.hasGetter(clazz) || BeanUtil.hasPublicField(clazz2);
    }

    public static boolean isBean(Class<?> clazz) {
        Class<?> clazz2;
        return BeanUtil.hasSetter(clazz) || BeanUtil.hasPublicField(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasSetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methodArray;
            for (Method method : methodArray.getMethods()) {
                void var3_3;
                if (method.getParameterCount() != 1 || !var3_3.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasGetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methodArray;
            for (Method method : methodArray.getMethods()) {
                void var3_3;
                String name;
                if (method.getParameterCount() != 0 || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || "getClass".equals(var3_3)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Field[] fieldArray;
            for (Field field : fieldArray.getFields()) {
                void var3_3;
                if (!ModifierUtil.isPublic(field) || ModifierUtil.isStatic((Field)var3_3)) continue;
                return true;
            }
        }
        return false;
    }

    public static DynaBean createDynaBean(Object bean) {
        Object object;
        return new DynaBean(object);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        Class<?> clazz2;
        Class<?> clazz3 = clazz2;
        return BeanDescCache.INSTANCE.getBeanDesc(clazz3, () -> {
            Class clazz2;
            return new BeanDesc(clazz2);
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void descForEach(Class<?> clazz, Consumer<? super PropDesc> action) {
        void var1_1;
        BeanUtil.getBeanDesc(clazz).getProps().forEach(var1_1);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            BeanInfo beanInfo2 = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayUtil.filter(beanInfo.getPropertyDescriptors(), t -> {
            PropertyDescriptor propertyDescriptor;
            return false == "class".equals(propertyDescriptor.getName());
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        void var1_1;
        Class<?> clazz2;
        return BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase, () -> BeanUtil.lambda$getPropertyDescriptorMap$58f3b7cb$1(clazz2, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        void var1_2;
        PropertyDescriptor[] propertyDescriptorArray;
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        Map<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        void var1_1;
        return BeanUtil.getPropertyDescriptor(clazz, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        void var1_1;
        Map<String, PropertyDescriptor> map;
        void var2_2;
        Map<String, PropertyDescriptor> map2 = BeanUtil.getPropertyDescriptorMap(clazz, (boolean)var2_2);
        if (map2 == null) {
            return null;
        }
        return (PropertyDescriptor)map.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        void var1_1;
        Object object;
        if (bean == null || fieldNameOrIndex == null) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            try {
                return CollUtil.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException numberFormatException) {
                return CollUtil.map((Collection)bean, beanEle -> {
                    String string;
                    return BeanUtil.getFieldValue(beanEle, string);
                }, false);
            }
        }
        if (ArrayUtil.isArray(bean)) {
            try {
                return ArrayUtil.get(bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException numberFormatException) {
                return ArrayUtil.map(bean, Object.class, beanEle -> {
                    String string;
                    return BeanUtil.getFieldValue(beanEle, string);
                });
            }
        }
        return ReflectUtil.getFieldValue(object, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        Object object;
        if (bean instanceof Map) {
            ((Map)bean).put(fieldNameOrIndex, value);
        } else if (bean instanceof List) {
            ListUtil.setOrPadding((List)bean, Convert.toInt(fieldNameOrIndex), value);
        } else {
            void var2_2;
            void var1_1;
            if (ArrayUtil.isArray(bean)) {
                return ArrayUtil.setOrAppend(bean, (int)Convert.toInt(fieldNameOrIndex), value);
            }
            ReflectUtil.setFieldValue(bean, (String)var1_1, (Object)var2_2);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getProperty(Object bean, String expression) {
        Object object;
        void var1_1;
        if (bean == null || StrUtil.isBlank(expression)) {
            return null;
        }
        return (T)BeanPath.create((String)var1_1).get(object);
    }

    /*
     * WARNING - void declaration
     */
    public static void setProperty(Object bean, String expression, Object value) {
        void var2_2;
        Object object;
        BeanPath.create(expression).set(object, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        void var2_2;
        void var1_1;
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        void var2_2;
        void var1_1;
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ReflectUtil.newInstanceIfPossible(var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, CopyOptions copyOptions) {
        void var2_2;
        void var1_1;
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(var1_1), (CopyOptions)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isToCamelCase, CopyOptions copyOptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(var1_1), (boolean)var2_2, (CopyOptions)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isIgnoreError) {
        void var2_2;
        void var1_1;
        return BeanUtil.fillBeanWithMap(map, var1_1, false, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BeanUtil.fillBeanWithMap(map, var1_1, (boolean)var2_2, CopyOptions.create().setIgnoreError((boolean)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        void var2_2;
        void var1_1;
        return BeanUtil.fillBeanWithMap(map, var1_1, CopyOptions.create().setIgnoreCase(true).setIgnoreError((boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        void var1_1;
        void var2_2;
        Map<?, ?> map2;
        if (MapUtil.isEmpty(map)) {
            return bean;
        }
        BeanUtil.copyProperties(map2, bean, (CopyOptions)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, CopyOptions copyOptions) {
        void var1_1;
        void var3_3;
        Map<?, ?> map2;
        if (MapUtil.isEmpty(map)) {
            return bean;
        }
        BeanUtil.copyProperties(map2, bean, (CopyOptions)var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(Object source, Class<T> clazz) {
        void var1_1;
        return BeanUtil.toBean(source, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBeanIgnoreError(Object source, Class<T> clazz) {
        void var1_1;
        return BeanUtil.toBean(source, var1_1, CopyOptions.create().setIgnoreError(true));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBeanIgnoreCase(Object source, Class<T> clazz, boolean ignoreError) {
        void var2_2;
        void var1_1;
        return BeanUtil.toBean(source, var1_1, CopyOptions.create().setIgnoreCase(true).setIgnoreError((boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        void var2_2;
        void var1_1;
        return (T)BeanUtil.toBean(source, () -> BeanUtil.lambda$toBean$3((Class)var1_1), (CopyOptions)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(Object source, Supplier<T> targetSupplier, CopyOptions options) {
        void var1_1;
        void var2_2;
        Object object;
        if (source == null || targetSupplier == null) {
            return null;
        }
        T target = targetSupplier.get();
        BeanUtil.copyProperties(object, target, (CopyOptions)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        void var2_2;
        void var1_1;
        Class<T> clazz;
        if (beanClass == null || valueProvider == null) {
            return null;
        }
        return BeanUtil.fillBean(ReflectUtil.newInstanceIfPossible(clazz), (ValueProvider<String>)var1_1, (CopyOptions)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        void var2_2;
        T t;
        void var1_1;
        if (valueProvider == null) {
            return bean;
        }
        return BeanCopier.create(var1_1, t, (CopyOptions)var2_2).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> beanToMap(Object bean, String ... properties) {
        void var3_3;
        void var2_2;
        Object object;
        int mapSize = 16;
        Editor<String> keyEditor = null;
        if (ArrayUtil.isNotEmpty(properties)) {
            HashSet hashSet;
            mapSize = properties.length;
            hashSet = CollUtil.set(false, hashSet);
            keyEditor = property -> {
                if (hashSet.contains(property)) {
                    void var1_1;
                    return var1_1;
                }
                return null;
            };
        }
        return BeanUtil.beanToMap(object, new LinkedHashMap<String, Object>((int)var2_2, 1.0f), false, (Editor<String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        void var2_2;
        void var1_1;
        Object object;
        if (bean == null) {
            return null;
        }
        return BeanUtil.beanToMap(object, new LinkedHashMap<String, Object>(), (boolean)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        void var2_2;
        void var3_3;
        void var1_1;
        Object object;
        if (bean == null) {
            return null;
        }
        return BeanUtil.beanToMap(object, (Map<String, Object>)var1_1, (boolean)var3_3, arg_0 -> BeanUtil.lambda$beanToMap$5((boolean)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object;
        if (bean == null) {
            return null;
        }
        return (Map)BeanCopier.create(object, var1_1, CopyOptions.create().setIgnoreNullValue((boolean)var2_2).setFieldNameEditor((Editor<String>)var3_3)).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, CopyOptions copyOptions) {
        void var2_2;
        void var1_1;
        Object object;
        if (bean == null) {
            return null;
        }
        return (Map)BeanCopier.create(object, var1_1, (CopyOptions)var2_2).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T copyProperties(Object source, Class<T> tClass, String ... ignoreProperties) {
        void var1_1;
        void var2_2;
        Object object;
        if (source == null) {
            return null;
        }
        T target = ReflectUtil.newInstanceIfPossible(tClass);
        BeanUtil.copyProperties(object, target, CopyOptions.create().setIgnoreProperties((String[])var2_2));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        void var2_2;
        void var1_1;
        BeanUtil.copyProperties(source, (Object)var1_1, CopyOptions.create().setIgnoreProperties((String[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void copyProperties(Object source, Object target, boolean ignoreCase) {
        void var2_2;
        void var1_1;
        BeanCopier.create(source, var1_1, CopyOptions.create().setIgnoreCase((boolean)var2_2)).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        void var2_2;
        void var1_1;
        Object object;
        if (source == null) {
            return;
        }
        BeanCopier.create(object, var1_1, ObjectUtil.defaultIfNull(var2_2, CopyOptions::create)).copy();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType, CopyOptions copyOptions) {
        void var2_2;
        void var1_1;
        Collection<?> collection2;
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList(0);
        }
        if (ClassUtil.isBasicType(targetType) || String.class == targetType) {
            return Convert.toList(targetType, collection);
        }
        return collection2.stream().map(arg_0 -> BeanUtil.lambda$copyToList$6((Class)var1_1, (CopyOptions)var2_2, arg_0)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType) {
        void var1_1;
        return BeanUtil.copyToList(collection, var1_1, CopyOptions.create());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        void var1_1;
        void var2_2;
        Object object;
        if (bean == null || StrUtil.isBlank(beanClassName)) {
            return false;
        }
        return ClassUtil.getClassName(object, isSimple).equals(var2_2 != false ? StrUtil.upperFirst(beanClassName) : var1_1);
    }

    public static <T> T edit(T bean, Editor<Field> editor) {
        T t;
        if (bean == null) {
            return null;
        }
        Field[] fieldArray = ReflectUtil.getFields(bean.getClass());
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray2[i];
            if (ModifierUtil.isStatic(field)) continue;
            editor.edit(field);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T trimStrFields(T bean, String ... ignoreFields) {
        T t;
        void var1_1;
        return BeanUtil.edit(bean, arg_0 -> BeanUtil.lambda$trimStrFields$7((String[])var1_1, t, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isNotEmpty(Object bean, String ... ignoreFieldNames) {
        void var1_1;
        Object object;
        return false == BeanUtil.isEmpty(object, (String[])var1_1);
    }

    public static boolean isEmpty(Object bean, String ... ignoreFieldNames) {
        if (bean != null) {
            for (Field field : ReflectUtil.getFields(bean.getClass())) {
                if (ModifierUtil.isStatic(field) || ArrayUtil.contains(ignoreFieldNames, field.getName()) || null == ReflectUtil.getFieldValue(bean, field)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNullField(Object bean, String ... ignoreFieldNames) {
        if (bean == null) {
            return true;
        }
        for (Field field : ReflectUtil.getFields(bean.getClass())) {
            if (ModifierUtil.isStatic(field) || ArrayUtil.contains(ignoreFieldNames, field.getName()) || null != ReflectUtil.getFieldValue(bean, field)) continue;
            return true;
        }
        return false;
    }

    public static String getFieldName(String getterOrSetterName) {
        String string;
        if (getterOrSetterName.startsWith("get") || getterOrSetterName.startsWith("set")) {
            return StrUtil.removePreAndLowerFirst((CharSequence)getterOrSetterName, 3);
        }
        if (getterOrSetterName.startsWith("is")) {
            return StrUtil.removePreAndLowerFirst((CharSequence)getterOrSetterName, 2);
        }
        throw new IllegalArgumentException("Invalid Getter or Setter name: " + string);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCommonFieldsEqual(Object source, Object target, String ... ignoreProperties) {
        Iterator<String> iterator;
        if (source == null && target == null) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        Map<String, Object> sourceFieldsMap = BeanUtil.beanToMap(source, new String[0]);
        Map<String, Object> targetFieldsMap = BeanUtil.beanToMap(target, new String[0]);
        Set<String> sourceFields = sourceFieldsMap.keySet();
        sourceFields.removeAll(Arrays.asList(iterator));
        for (String field : sourceFields) {
            void var3_3;
            if (!sourceFieldsMap.containsKey(field) || !targetFieldsMap.containsKey(field) || !ObjectUtil.notEqual(sourceFieldsMap.get(field), targetFieldsMap.get(var3_3))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Field lambda$trimStrFields$7(String[] ignoreFields, Object bean, Field field) {
        void var2_2;
        String trimVal;
        Object object;
        Object val;
        if (ignoreFields != null && ArrayUtil.containsIgnoreCase(ignoreFields, field.getName())) {
            return field;
        }
        if (String.class.equals(field.getType()) && (val = (String)ReflectUtil.getFieldValue(bean, field)) != null && !((String)object).equals(trimVal = StrUtil.trim((CharSequence)val))) {
            void var3_3;
            void var1_1;
            ReflectUtil.setFieldValue((Object)var1_1, field, (Object)var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$copyToList$6(Class targetType, CopyOptions copyOptions, Object source) {
        Class clazz;
        void var1_1;
        void var2_2;
        Class target = ReflectUtil.newInstanceIfPossible(targetType);
        BeanUtil.copyProperties((Object)var2_2, (Object)target, (CopyOptions)var1_1);
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ String lambda$beanToMap$5(boolean isToUnderlineCase, String key) {
        void var1_1;
        if (isToUnderlineCase) {
            return StrUtil.toUnderlineCase(key);
        }
        return var1_1;
    }

    private static /* synthetic */ Object lambda$toBean$3(Class clazz) {
        return ReflectUtil.newInstanceIfPossible(clazz);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Map lambda$getPropertyDescriptorMap$58f3b7cb$1(Class clazz, boolean ignoreCase) throws Exception {
        void var1_1;
        return BeanUtil.internalGetPropertyDescriptorMap(clazz, (boolean)var1_1);
    }
}

