/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] EXP_CHARS = new char[]{'.', '[', ']'};
    private boolean isStartWith = false;
    protected List<String> patternParts;

    public static BeanPath create(String expression) {
        String string;
        return new BeanPath(string);
    }

    /*
     * WARNING - void declaration
     */
    public BeanPath(String expression) {
        void var1_1;
        this.init((String)var1_1);
    }

    public List<String> getPatternParts() {
        return this.patternParts;
    }

    /*
     * WARNING - void declaration
     */
    public Object get(Object bean) {
        void var1_1;
        BeanPath beanPath = this;
        return beanPath.get(beanPath.patternParts, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public void set(Object bean, Object value) {
        void var2_2;
        void var1_1;
        this.set(var1_1, this.patternParts, BeanPath.lastIsNumber(this.patternParts), var2_2);
    }

    public String toString() {
        return this.patternParts.toString();
    }

    private void set(Object bean, List<String> patternParts, boolean nextNumberPart, Object value) {
        while (true) {
            Object subBean;
            if ((subBean = this.get(patternParts, bean, true)) == null) {
                List<String> parentParts;
                List<String> list = parentParts = BeanPath.getParentParts(patternParts);
                this.set(bean, list, BeanPath.lastIsNumber(list), nextNumberPart ? new ArrayList() : new HashMap());
                subBean = this.get(patternParts, bean, true);
            }
            List<String> list = patternParts;
            Object newSubBean = BeanUtil.setFieldValue(subBean, list.get(list.size() - 1), value);
            if (newSubBean == subBean) break;
            value = newSubBean;
            patternParts = BeanPath.getParentParts(patternParts);
        }
    }

    private static boolean lastIsNumber(List<String> patternParts) {
        List<String> list = patternParts;
        return NumberUtil.isInteger(list.get(list.size() - 1));
    }

    private static List<String> getParentParts(List<String> patternParts) {
        List<String> list;
        return patternParts.subList(0, list.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private Object get(List<String> patternParts, Object bean, boolean ignoreLast) {
        void var3_4;
        int length = patternParts.size();
        if (ignoreLast) {
            --length;
        }
        Object subBean = bean;
        boolean isFirst = true;
        for (int i = 0; i < length; ++i) {
            String patternPart = patternParts.get(i);
            if ((subBean = BeanPath.getFieldValue(subBean, patternPart)) != null) continue;
            if (isFirst && !this.isStartWith && BeanUtil.isMatchName(bean, patternPart, true)) {
                subBean = bean;
                isFirst = false;
                continue;
            }
            return null;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static Object getFieldValue(Object bean, String expression) {
        List<String> parts;
        if (StrUtil.isBlank(expression)) {
            return null;
        }
        if (StrUtil.contains((CharSequence)expression, ':')) {
            parts = StrUtil.splitTrim((CharSequence)expression, ':');
            int start = Integer.parseInt(parts.get(0));
            int end = Integer.parseInt(parts.get(1));
            int step = 1;
            if (3 == parts.size()) {
                step = Integer.parseInt(parts.get(2));
            }
            if (bean instanceof Collection) {
                return CollUtil.sub((Collection)bean, start, end, step);
            }
            if (ArrayUtil.isArray(bean)) {
                return ArrayUtil.sub(bean, start, end, step);
            }
        } else {
            void var1_1;
            Object object;
            if (StrUtil.contains((CharSequence)((Object)parts), ',')) {
                void var2_3;
                List<String> keys = StrUtil.splitTrim(parts, ',');
                if (bean instanceof Collection) {
                    return CollUtil.getAny((Collection)bean, Convert.convert(int[].class, keys));
                }
                if (ArrayUtil.isArray(bean)) {
                    return ArrayUtil.getAny(bean, Convert.convert(int[].class, keys));
                }
                String[] unWrappedKeys = new String[keys.size()];
                for (int i = 0; i < unWrappedKeys.length; ++i) {
                    unWrappedKeys[i] = StrUtil.unWrap(keys.get(i), '\'');
                }
                if (bean instanceof Map) {
                    return MapUtil.getAny((Map)bean, unWrappedKeys);
                }
                Map<String, Object> map = BeanUtil.beanToMap(bean, new String[0]);
                return MapUtil.getAny(map, var2_3);
            }
            return BeanUtil.getFieldValue(object, (String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void init(String expression) {
        void var2_2;
        ArrayList<String> localPatternParts = new ArrayList<String>();
        int length = expression.length();
        StringBuilder builder = new StringBuilder();
        boolean isNumStart = false;
        boolean isInWrap = false;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if (i == 0 && '$' == c) {
                this.isStartWith = true;
                continue;
            }
            if ('\'' == c) {
                isInWrap = !isInWrap;
                continue;
            }
            if (!isInWrap && ArrayUtil.contains(EXP_CHARS, c)) {
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find ']' but no '[' !", expression, i));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, i));
                    }
                    if ('[' == c) {
                        isNumStart = true;
                    }
                }
                if (builder.length() > 0) {
                    localPatternParts.add(builder.toString());
                }
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (isNumStart) {
            void var3_3;
            void var1_1;
            throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", var1_1, (int)(var3_3 - true)));
        }
        if (builder.length() > 0) {
            localPatternParts.add(builder.toString());
        }
        this.patternParts = ListUtil.unmodifiable(var2_2);
    }
}

