/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    /*
     * WARNING - void declaration
     */
    public BeanDesc(Class<?> beanClass) {
        void var1_1;
        Assert.notNull(beanClass);
        this.beanClass = var1_1;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        if (ignoreCase) {
            return new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap);
        }
        return this.propMap;
    }

    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    /*
     * WARNING - void declaration
     */
    public PropDesc getProp(String fieldName) {
        void var1_1;
        return this.propMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Field getField(String fieldName) {
        void var1_1;
        PropDesc desc = this.propMap.get(fieldName);
        if (desc == null) {
            return null;
        }
        return var1_1.getField();
    }

    /*
     * WARNING - void declaration
     */
    public Method getGetter(String fieldName) {
        void var1_1;
        PropDesc desc = this.propMap.get(fieldName);
        if (desc == null) {
            return null;
        }
        return var1_1.getGetter();
    }

    /*
     * WARNING - void declaration
     */
    public Method getSetter(String fieldName) {
        void var1_1;
        PropDesc desc = this.propMap.get(fieldName);
        if (desc == null) {
            return null;
        }
        return var1_1.getSetter();
    }

    /*
     * WARNING - void declaration
     */
    private BeanDesc init() {
        Method[] gettersAndSetters = ReflectUtil.getMethods(this.beanClass, ReflectUtil::isGetterOrSetterIgnoreCase);
        for (Field field : ReflectUtil.getFields(this.beanClass)) {
            void var2_5;
            if (ModifierUtil.isStatic(field) || ReflectUtil.isOuterClassField(field)) continue;
            PropDesc prop = this.createProp(field, gettersAndSetters);
            this.propMap.putIfAbsent(prop.getFieldName(), (PropDesc)var2_5);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private PropDesc createProp(Field field, Method[] methods) {
        void var3_3;
        PropDesc prop = this.findProp(field, methods, false);
        if (prop.getter == null || prop.setter == null) {
            void var2_2;
            PropDesc propIgnoreCase = this.findProp(field, (Method[])var2_2, true);
            if (prop.getter == null) {
                prop.getter = propIgnoreCase.getter;
            }
            if (prop.setter == null) {
                void var1_1;
                prop.setter = var1_1.setter;
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private PropDesc findProp(Field field, Method[] gettersOrSetters, boolean ignoreCase) {
        void var1_1;
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = BooleanUtil.isBoolean(fieldType);
        Method getter = null;
        Method setter = null;
        Method[] methodArray = gettersOrSetters;
        int n = gettersOrSetters.length;
        for (int i = 0; i < n; ++i) {
            void var2_2;
            Method method = methodArray[i];
            String methodName = method.getName();
            if (method.getParameterCount() == 0) {
                if (this.isMatchGetter(methodName, fieldName, isBooleanField, ignoreCase)) {
                    getter = method;
                }
            } else if (this.isMatchSetter((String)var2_2, fieldName, isBooleanField, ignoreCase) && fieldType.isAssignableFrom(method.getParameterTypes()[0])) {
                setter = method;
            }
            if (getter != null && setter != null) break;
        }
        return new PropDesc((Field)var1_1, getter, setter);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMatchGetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        void var1_1;
        void var2_2;
        void var3_3;
        String handledFieldName;
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = handledFieldName = fieldName.toLowerCase();
        } else {
            handledFieldName = StrUtil.upperFirst(fieldName);
        }
        if (var3_3 != false && (fieldName.startsWith("is") ? methodName.equals(var2_2) || ("get" + handledFieldName).equals(methodName) || ("is" + handledFieldName).equals(methodName) : ("is" + handledFieldName).equals(methodName))) {
            return true;
        }
        return ("get" + handledFieldName).equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMatchSetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        void var1_1;
        void var2_2;
        void var3_3;
        String handledFieldName;
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = handledFieldName = fieldName.toLowerCase();
        } else {
            handledFieldName = StrUtil.upperFirst(fieldName);
        }
        if (!methodName.startsWith("set")) {
            return false;
        }
        if (var3_3 != false && fieldName.startsWith("is") && (("set" + StrUtil.removePrefix((CharSequence)var2_2, "is")).equals(methodName) || ("set" + handledFieldName).equals(methodName))) {
            return true;
        }
        return ("set" + handledFieldName).equals(var1_1);
    }
}

