/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation.scanner;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.scanner.EmptyAnnotationScanner;
import cn.hutool.core.annotation.scanner.GenericAnnotationScanner;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface AnnotationScanner {
    public static final AnnotationScanner NOTHING = new EmptyAnnotationScanner();
    public static final AnnotationScanner DIRECTLY = new GenericAnnotationScanner(false, false, false);
    public static final AnnotationScanner DIRECTLY_AND_META_ANNOTATION = new GenericAnnotationScanner(true, false, false);
    public static final AnnotationScanner SUPERCLASS = new GenericAnnotationScanner(false, true, false);
    public static final AnnotationScanner SUPERCLASS_AND_META_ANNOTATION = new GenericAnnotationScanner(true, true, false);
    public static final AnnotationScanner INTERFACE = new GenericAnnotationScanner(false, false, true);
    public static final AnnotationScanner INTERFACE_AND_META_ANNOTATION = new GenericAnnotationScanner(true, false, true);
    public static final AnnotationScanner TYPE_HIERARCHY = new GenericAnnotationScanner(false, true, true);
    public static final AnnotationScanner TYPE_HIERARCHY_AND_META_ANNOTATION = new GenericAnnotationScanner(true, true, true);

    /*
     * WARNING - void declaration
     */
    public static List<Annotation> scanByAnySupported(AnnotatedElement annotatedEle, AnnotationScanner ... scanners) {
        AnnotatedElement annotatedElement;
        void var1_1;
        if (ObjectUtil.isNull(annotatedEle) && ArrayUtil.isNotEmpty(scanners)) {
            return Collections.emptyList();
        }
        return Stream.of(var1_1).filter(scanner -> {
            AnnotatedElement annotatedElement;
            return scanner.support(annotatedElement);
        }).findFirst().map(scanner -> {
            AnnotatedElement annotatedElement;
            return scanner.getAnnotations(annotatedElement);
        }).orElseGet(Collections::emptyList);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Annotation> scanByAllSupported(AnnotatedElement annotatedEle, AnnotationScanner ... scanners) {
        AnnotatedElement annotatedElement;
        void var1_1;
        if (ObjectUtil.isNull(annotatedEle) && ArrayUtil.isNotEmpty(scanners)) {
            return Collections.emptyList();
        }
        return Stream.of(var1_1).map(scanner -> {
            AnnotatedElement annotatedElement;
            return scanner.getAnnotationsIfSupport(annotatedElement);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public boolean support(AnnotatedElement annotatedEle) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    default public List<Annotation> getAnnotations(AnnotatedElement annotatedEle) {
        void var2_2;
        void var1_1;
        ArrayList annotations = new ArrayList();
        this.scan((index, annotation) -> {
            void var2_2;
            annotations.add(var2_2);
        }, (AnnotatedElement)var1_1, null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    default public List<Annotation> getAnnotationsIfSupport(AnnotatedElement annotatedEle) {
        if (this.support(annotatedEle)) {
            void var1_1;
            return this.getAnnotations((AnnotatedElement)var1_1);
        }
        return Collections.emptyList();
    }

    default public void scan(BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter) {
        Annotation[] annotationArray;
        filter = ObjectUtil.defaultIfNull(filter, a -> annotation -> true);
        for (Annotation annotation : annotationArray.getAnnotations()) {
            if (!AnnotationUtil.isNotJdkMateAnnotation(annotation.annotationType()) || !filter.test(annotation)) continue;
            consumer.accept(0, annotation);
        }
    }

    /*
     * WARNING - void declaration
     */
    default public void scanIfSupport(BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter) {
        if (this.support(annotatedEle)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.scan((BiConsumer<Integer, Annotation>)var1_1, (AnnotatedElement)var2_2, (Predicate<Annotation>)var3_3);
        }
    }
}

