/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation.scanner;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.scanner.AnnotationScanner;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public abstract class AbstractTypeAnnotationScanner<T extends AbstractTypeAnnotationScanner<T>>
implements AnnotationScanner {
    private boolean includeSuperClass;
    private boolean includeInterfaces;
    private Predicate<Class<?>> filter;
    private final Set<Class<?>> excludeTypes;
    private final List<UnaryOperator<Class<?>>> converters;
    private boolean hasConverters;
    private final T typedThis;

    /*
     * WARNING - void declaration
     */
    protected AbstractTypeAnnotationScanner(boolean includeSuperClass, boolean includeInterfaces, Predicate<Class<?>> filter, Set<Class<?>> excludeTypes) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(filter, "filter must not null", new Object[0]);
        Assert.notNull(excludeTypes, "excludeTypes must not null", new Object[0]);
        this.includeSuperClass = var1_1;
        this.includeInterfaces = var2_2;
        this.filter = var3_3;
        this.excludeTypes = excludeTypes;
        this.converters = new ArrayList();
        this.typedThis = this;
    }

    public boolean isIncludeSuperClass() {
        return this.includeSuperClass;
    }

    public boolean isIncludeInterfaces() {
        return this.includeInterfaces;
    }

    /*
     * WARNING - void declaration
     */
    public T setFilter(Predicate<Class<?>> filter) {
        void var1_1;
        Assert.notNull(filter, "filter must not null", new Object[0]);
        this.filter = var1_1;
        return this.typedThis;
    }

    /*
     * WARNING - void declaration
     */
    public T addExcludeTypes(Class<?> ... excludeTypes) {
        void var1_1;
        CollUtil.addAll(this.excludeTypes, var1_1);
        return this.typedThis;
    }

    /*
     * WARNING - void declaration
     */
    public T addConverters(UnaryOperator<Class<?>> converter) {
        void var1_1;
        Assert.notNull(converter, "converter must not null", new Object[0]);
        this.converters.add((UnaryOperator<Class<?>>)var1_1);
        if (!this.hasConverters) {
            this.hasConverters = CollUtil.isNotEmpty(this.converters);
        }
        return this.typedThis;
    }

    /*
     * WARNING - void declaration
     */
    protected T setIncludeSuperClass(boolean includeSuperClass) {
        void var1_1;
        this.includeSuperClass = var1_1;
        return this.typedThis;
    }

    /*
     * WARNING - void declaration
     */
    protected T setIncludeInterfaces(boolean includeInterfaces) {
        void var1_1;
        this.includeInterfaces = var1_1;
        return this.typedThis;
    }

    @Override
    public void scan(BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter) {
        filter = ObjectUtil.defaultIfNull(filter, a -> annotation -> true);
        Class<?> sourceClass = this.getClassFormAnnotatedElement(annotatedEle);
        LinkedList<List> classDeque = CollUtil.newLinkedList(CollUtil.newArrayList(sourceClass));
        LinkedHashSet accessedTypes = new LinkedHashSet();
        int index = 0;
        while (!classDeque.isEmpty()) {
            List currClassQueue = (List)classDeque.removeFirst();
            ArrayList nextClassQueue = new ArrayList();
            for (Class<?> targetClass : currClassQueue) {
                if (this.isNotNeedProcess(accessedTypes, targetClass = this.convert(targetClass))) continue;
                accessedTypes.add(targetClass);
                this.scanSuperClassIfNecessary(nextClassQueue, targetClass);
                this.scanInterfaceIfNecessary(nextClassQueue, targetClass);
                Annotation[] annotationArray = this.getAnnotationsFromTargetClass(annotatedEle, index, targetClass);
                Annotation[] annotationArray2 = annotationArray;
                annotationArray2 = annotationArray;
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation annotation = annotationArray2[i];
                    if (!AnnotationUtil.isNotJdkMateAnnotation(annotation.annotationType()) || !filter.test(annotation)) continue;
                    consumer.accept(index, annotation);
                }
                ++index;
            }
            if (!CollUtil.isNotEmpty(nextClassQueue)) continue;
            classDeque.addLast(nextClassQueue);
        }
    }

    protected abstract Class<?> getClassFormAnnotatedElement(AnnotatedElement var1);

    protected abstract Annotation[] getAnnotationsFromTargetClass(AnnotatedElement var1, int var2, Class<?> var3);

    /*
     * WARNING - void declaration
     */
    protected boolean isNotNeedProcess(Set<Class<?>> accessedTypes, Class<?> targetClass) {
        void var2_2;
        void var1_1;
        return ObjectUtil.isNull(targetClass) || var1_1.contains(targetClass) || this.excludeTypes.contains(targetClass) || this.filter.negate().test((Class<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void scanInterfaceIfNecessary(List<Class<?>> nextClasses, Class<?> targetClass) {
        Class<?>[] interfaces;
        if (this.includeInterfaces && ArrayUtil.isNotEmpty(interfaces = targetClass.getInterfaces())) {
            void var2_2;
            void var1_1;
            CollUtil.addAll(var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void scanSuperClassIfNecessary(List<Class<?>> nextClassQueue, Class<?> targetClass) {
        Class<?> superClass;
        if (this.includeSuperClass && !ObjectUtil.equals(superClass = targetClass.getSuperclass(), Object.class) && ObjectUtil.isNotNull(superClass)) {
            void var2_2;
            void var1_1;
            var1_1.add(var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Class<?> convert(Class<?> target) {
        void var1_1;
        if (this.hasConverters) {
            for (UnaryOperator<Class<?>> unaryOperator : this.converters) {
                target = (Class)unaryOperator.apply(target);
            }
        }
        return var1_1;
    }

    public static class JdkProxyClassConverter
    implements UnaryOperator<Class<?>> {
        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> apply(Class<?> sourceClass) {
            void var1_1;
            if (Proxy.isProxyClass(sourceClass)) {
                return this.apply(sourceClass.getSuperclass());
            }
            return var1_1;
        }
    }
}

