/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.AnnotationAttributeValueProvider;
import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.SynthesizedAnnotation;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SynthesizedAnnotationProxy
implements InvocationHandler {
    private final AnnotationAttributeValueProvider annotationAttributeValueProvider;
    private final SynthesizedAnnotation annotation;
    private final Map<String, BiFunction<Method, Object[], Object>> methods;

    /*
     * WARNING - void declaration
     */
    public static <T extends Annotation> T create(Class<T> annotationType, AnnotationAttributeValueProvider annotationAttributeValueProvider, SynthesizedAnnotation annotation) {
        void var1_1;
        Class<T> clazz;
        void var2_2;
        if (ObjectUtil.isNull(annotation)) {
            return null;
        }
        SynthesizedAnnotationProxy proxyHandler = new SynthesizedAnnotationProxy(annotationAttributeValueProvider, annotation);
        if (ObjectUtil.isNull(var2_2)) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{clazz, SyntheticProxyAnnotation.class}, (InvocationHandler)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Annotation> T create(Class<T> annotationType, SynthesizedAnnotation annotation) {
        void var1_1;
        void v0 = var1_1;
        return SynthesizedAnnotationProxy.create(annotationType, (AnnotationAttributeValueProvider)v0, (SynthesizedAnnotation)v0);
    }

    public static boolean isProxyAnnotation(Class<?> annotationType) {
        Class<?> clazz;
        return ClassUtil.isAssignable(SyntheticProxyAnnotation.class, clazz);
    }

    /*
     * WARNING - void declaration
     */
    SynthesizedAnnotationProxy(AnnotationAttributeValueProvider annotationAttributeValueProvider, SynthesizedAnnotation annotation) {
        void var2_2;
        void var1_1;
        Assert.notNull(annotationAttributeValueProvider, "annotationAttributeValueProvider must not null", new Object[0]);
        Assert.notNull(annotation, "annotation must not null", new Object[0]);
        this.annotationAttributeValueProvider = var1_1;
        this.annotation = var2_2;
        this.methods = new HashMap<String, BiFunction<Method, Object[], Object>>(9);
        this.loadMethods();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        void var3_3;
        void var2_2;
        return Opt.ofNullable(this.methods.get(method.getName())).map(m -> {
            void var1_1;
            Method method2;
            return m.apply(method2, var1_1);
        }).orElseGet(() -> this.lambda$invoke$1((Method)var2_2, (Object[])var3_3));
    }

    void loadMethods() {
        this.methods.put("toString", (method, args) -> this.proxyToString());
        this.methods.put("hashCode", (method, args) -> this.proxyHashCode());
        this.methods.put("getSynthesizedAnnotation", (method, args) -> this.proxyGetSynthesizedAnnotation());
        this.methods.put("getRoot", (method, args) -> this.annotation.getRoot());
        this.methods.put("getVerticalDistance", (method, args) -> this.annotation.getVerticalDistance());
        this.methods.put("getHorizontalDistance", (method, args) -> this.annotation.getHorizontalDistance());
        this.methods.put("hasAttribute", (method, args) -> {
            void var2_2;
            return this.annotation.hasAttribute((String)args[0], (Class)var2_2[1]);
        });
        this.methods.put("getAttributes", (method, args) -> this.annotation.getAttributes());
        this.methods.put("setAttribute", (method, args) -> {
            throw new UnsupportedOperationException("proxied annotation can not reset attributes");
        });
        this.methods.put("getAttributeValue", (method, args) -> {
            void var2_2;
            return this.annotation.getAttributeValue((String)var2_2[0]);
        });
        this.methods.put("annotationType", (method, args) -> this.annotation.annotationType());
        Stream.of(ClassUtil.getDeclaredMethods(this.annotation.getAnnotation().annotationType())).filter(m -> {
            void var1_1;
            return !this.methods.containsKey(var1_1.getName());
        }).forEach(m -> {
            void var1_1;
            this.methods.put(var1_1.getName(), (method, args) -> {
                void var1_1;
                return this.proxyAttributeValue((Method)var1_1);
            });
        });
    }

    /*
     * WARNING - void declaration
     */
    private String proxyToString() {
        void var1_1;
        String attributes = Stream.of(ClassUtil.getDeclaredMethods(this.annotation.getAnnotation().annotationType())).filter(AnnotationUtil::isAttributeMethod).map(method -> {
            void var1_1;
            return CharSequenceUtil.format("{}={}", method.getName(), this.proxyAttributeValue((Method)var1_1));
        }).collect(Collectors.joining(", "));
        return CharSequenceUtil.format("@{}({})", this.annotation.annotationType().getName(), var1_1);
    }

    private int proxyHashCode() {
        return Objects.hash(this.annotationAttributeValueProvider, this.annotation);
    }

    private Object proxyGetSynthesizedAnnotation() {
        return this.annotation;
    }

    /*
     * WARNING - void declaration
     */
    private Object proxyAttributeValue(Method attributeMethod) {
        void var1_1;
        return this.annotationAttributeValueProvider.getAttributeValue(attributeMethod.getName(), var1_1.getReturnType());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Object lambda$invoke$1(Method method, Object[] args) {
        void var2_2;
        void var1_1;
        return ReflectUtil.invoke((Object)this.annotation.getAnnotation(), (Method)var1_1, (Object[])var2_2);
    }

    static interface SyntheticProxyAnnotation
    extends SynthesizedAnnotation {
        public SynthesizedAnnotation getSynthesizedAnnotation();
    }
}

