/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.AbstractLinkAnnotationPostProcessor;
import cn.hutool.core.annotation.AnnotationAttribute;
import cn.hutool.core.annotation.AnnotationSynthesizer;
import cn.hutool.core.annotation.Link;
import cn.hutool.core.annotation.MirroredAnnotationAttribute;
import cn.hutool.core.annotation.RelationType;
import cn.hutool.core.annotation.SynthesizedAnnotation;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;

public class MirrorLinkAnnotationPostProcessor
extends AbstractLinkAnnotationPostProcessor {
    private static final RelationType[] PROCESSED_RELATION_TYPES = new RelationType[]{RelationType.MIRROR_FOR};

    @Override
    public int order() {
        return -2147483647;
    }

    @Override
    protected RelationType[] processTypes() {
        return PROCESSED_RELATION_TYPES;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processLinkedAttribute(AnnotationSynthesizer synthesizer, Link annotation, SynthesizedAnnotation originalAnnotation, AnnotationAttribute originalAttribute, SynthesizedAnnotation linkedAnnotation, AnnotationAttribute linkedAttribute) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (originalAttribute instanceof MirroredAnnotationAttribute || linkedAttribute instanceof MirroredAnnotationAttribute) {
            this.checkMirrored(originalAttribute, linkedAttribute);
            return;
        }
        this.checkMirrorRelation(annotation, originalAttribute, linkedAttribute);
        MirroredAnnotationAttribute mirroredOriginalAttribute = new MirroredAnnotationAttribute(originalAttribute, linkedAttribute);
        var3_3.setAttribute(originalAttribute.getAttributeName(), mirroredOriginalAttribute);
        MirroredAnnotationAttribute mirroredTargetAttribute = new MirroredAnnotationAttribute(linkedAttribute, originalAttribute);
        linkedAnnotation.setAttribute(var2_2.attribute(), (AnnotationAttribute)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkMirrored(AnnotationAttribute original, AnnotationAttribute mirror) {
        void var1_1;
        void var2_2;
        String errorMsg;
        void var3_3;
        boolean originalAttributeMirrored = original instanceof MirroredAnnotationAttribute;
        boolean mirrorAttributeMirrored = mirror instanceof MirroredAnnotationAttribute;
        boolean bl = originalAttributeMirrored && mirrorAttributeMirrored && ObjectUtil.equals(((MirroredAnnotationAttribute)original).getLinked(), ((MirroredAnnotationAttribute)mirror).getOriginal());
        if (bl) {
            return;
        }
        errorMsg = originalAttributeMirrored && !mirrorAttributeMirrored ? CharSequenceUtil.format("attribute [{}] cannot mirror for [{}], because it's already mirrored for [{}]", original.getAttribute(), mirror.getAttribute(), ((MirroredAnnotationAttribute)original).getLinked()) : (var3_3 == false && mirrorAttributeMirrored ? CharSequenceUtil.format("attribute [{}] cannot mirror for [{}], because it's already mirrored for [{}]", mirror.getAttribute(), errorMsg.getAttribute(), ((MirroredAnnotationAttribute)mirror).getLinked()) : CharSequenceUtil.format("attribute [{}] cannot mirror for [{}], because [{}] already mirrored for [{}] and  [{}] already mirrored for [{}]", mirror.getAttribute(), errorMsg.getAttribute(), mirror.getAttribute(), ((MirroredAnnotationAttribute)var2_2).getLinked(), errorMsg.getAttribute(), ((MirroredAnnotationAttribute)((Object)errorMsg)).getLinked()));
        throw new IllegalArgumentException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkMirrorRelation(Link annotation, AnnotationAttribute original, AnnotationAttribute mirror) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkLinkedAttributeNotNull(original, mirror, annotation);
        this.checkAttributeType(original, mirror);
        Link mirrorAttributeAnnotation = this.getLinkAnnotation(mirror, RelationType.MIRROR_FOR);
        Assert.isTrue(ObjectUtil.isNotNull(mirrorAttributeAnnotation) && RelationType.MIRROR_FOR.equals((Object)var1_1.type()), "mirror attribute [{}] of original attribute [{}] must marked by @Link, and also @LinkType.type() must is [{}]", new Object[]{mirror.getAttribute(), original.getAttribute(), RelationType.MIRROR_FOR});
        this.checkLinkedSelf((AnnotationAttribute)var2_2, (AnnotationAttribute)var3_3);
    }
}

