/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import java.util.Comparator;

public interface Hierarchical
extends Comparable<Hierarchical> {
    public static final Comparator<Hierarchical> DEFAULT_HIERARCHICAL_COMPARATOR = Comparator.comparing(Hierarchical::getVerticalDistance).thenComparing(Hierarchical::getHorizontalDistance);

    /*
     * WARNING - void declaration
     */
    @Override
    default public int compareTo(Hierarchical o) {
        void var1_1;
        return DEFAULT_HIERARCHICAL_COMPARATOR.compare(this, (Hierarchical)var1_1);
    }

    public Object getRoot();

    public int getVerticalDistance();

    public int getHorizontalDistance();

    @FunctionalInterface
    public static interface Selector {
        public static final Selector NEAREST_AND_OLDEST_PRIORITY = new NearestAndOldestPrioritySelector();
        public static final Selector NEAREST_AND_NEWEST_PRIORITY = new NearestAndNewestPrioritySelector();
        public static final Selector FARTHEST_AND_OLDEST_PRIORITY = new FarthestAndOldestPrioritySelector();
        public static final Selector FARTHEST_AND_NEWEST_PRIORITY = new FarthestAndNewestPrioritySelector();

        public <T extends Hierarchical> T choose(T var1, T var2);

        public static class FarthestAndNewestPrioritySelector
        implements Selector {
            /*
             * WARNING - void declaration
             */
            @Override
            public <T extends Hierarchical> T choose(T oldAnnotation, T newAnnotation) {
                void var1_1;
                if (newAnnotation.getVerticalDistance() >= oldAnnotation.getVerticalDistance()) {
                    void var2_2;
                    return var2_2;
                }
                return var1_1;
            }
        }

        public static class FarthestAndOldestPrioritySelector
        implements Selector {
            /*
             * WARNING - void declaration
             */
            @Override
            public <T extends Hierarchical> T choose(T oldAnnotation, T newAnnotation) {
                void var1_1;
                if (newAnnotation.getVerticalDistance() > oldAnnotation.getVerticalDistance()) {
                    void var2_2;
                    return var2_2;
                }
                return var1_1;
            }
        }

        public static class NearestAndNewestPrioritySelector
        implements Selector {
            /*
             * WARNING - void declaration
             */
            @Override
            public <T extends Hierarchical> T choose(T oldAnnotation, T newAnnotation) {
                void var1_1;
                if (newAnnotation.getVerticalDistance() <= oldAnnotation.getVerticalDistance()) {
                    void var2_2;
                    return var2_2;
                }
                return var1_1;
            }
        }

        public static class NearestAndOldestPrioritySelector
        implements Selector {
            /*
             * WARNING - void declaration
             */
            @Override
            public <T extends Hierarchical> T choose(T oldAnnotation, T newAnnotation) {
                void var1_1;
                if (newAnnotation.getVerticalDistance() < oldAnnotation.getVerticalDistance()) {
                    void var2_2;
                    return var2_2;
                }
                return var1_1;
            }
        }
    }
}

