/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.AnnotationAttribute;
import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.CacheableAnnotationAttribute;
import cn.hutool.core.annotation.SynthesizedAnnotation;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenericSynthesizedAnnotation<R, T extends Annotation>
implements SynthesizedAnnotation {
    private final R root;
    private final T annotation;
    private final Map<String, AnnotationAttribute> attributeMethodCaches;
    private final int verticalDistance;
    private final int horizontalDistance;

    /*
     * WARNING - void declaration
     */
    protected GenericSynthesizedAnnotation(R root, T annotation, int verticalDistance, int horizontalDistance) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.root = var1_1;
        this.annotation = var2_2;
        this.verticalDistance = var3_3;
        this.horizontalDistance = horizontalDistance;
        this.attributeMethodCaches = new HashMap<String, AnnotationAttribute>();
        this.attributeMethodCaches.putAll(this.loadAttributeMethods());
    }

    protected Map<String, AnnotationAttribute> loadAttributeMethods() {
        return Stream.of(ClassUtil.getDeclaredMethods(this.annotation.annotationType())).filter(AnnotationUtil::isAttributeMethod).collect(Collectors.toMap(Method::getName, method -> {
            void var1_1;
            return new CacheableAnnotationAttribute((Annotation)this.annotation, (Method)var1_1);
        }));
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasAttribute(String attributeName) {
        void var1_1;
        return this.attributeMethodCaches.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasAttribute(String attributeName, Class<?> returnType) {
        void var2_2;
        void var1_1;
        return Opt.ofNullable(this.attributeMethodCaches.get(var1_1)).filter(arg_0 -> GenericSynthesizedAnnotation.lambda$hasAttribute$1((Class)var2_2, arg_0)).isPresent();
    }

    @Override
    public Map<String, AnnotationAttribute> getAttributes() {
        return this.attributeMethodCaches;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttribute(String attributeName, AnnotationAttribute attribute) {
        void var2_2;
        void var1_1;
        this.attributeMethodCaches.put((String)var1_1, (AnnotationAttribute)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceAttribute(String attributeName, UnaryOperator<AnnotationAttribute> operator) {
        AnnotationAttribute old = this.attributeMethodCaches.get(attributeName);
        if (ObjectUtil.isNotNull(old)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.attributeMethodCaches.put((String)var1_1, (AnnotationAttribute)var2_2.apply(var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getAttributeValue(String attributeName) {
        void var1_1;
        return Opt.ofNullable(this.attributeMethodCaches.get(var1_1)).map(AnnotationAttribute::getValue).get();
    }

    public R getRoot() {
        return this.root;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public int getVerticalDistance() {
        return this.verticalDistance;
    }

    @Override
    public int getHorizontalDistance() {
        return this.horizontalDistance;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotation.annotationType();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getAttributeValue(String attributeName, Class<?> attributeType) {
        void var2_2;
        void var1_1;
        return Opt.ofNullable(this.attributeMethodCaches.get(var1_1)).filter(arg_0 -> GenericSynthesizedAnnotation.lambda$getAttributeValue$2((Class)var2_2, arg_0)).map(AnnotationAttribute::getValue).get();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getAttributeValue$2(Class attributeType, AnnotationAttribute method) {
        void var1_1;
        return ClassUtil.isAssignable(attributeType, var1_1.getAttributeType());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$hasAttribute$1(Class returnType, AnnotationAttribute method) {
        void var1_1;
        return ClassUtil.isAssignable(returnType, var1_1.getAttributeType());
    }
}

