/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.AbstractAnnotationSynthesizer;
import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.CacheableSynthesizedAnnotationAttributeProcessor;
import cn.hutool.core.annotation.GenericSynthesizedAnnotation;
import cn.hutool.core.annotation.SynthesizedAggregateAnnotation;
import cn.hutool.core.annotation.SynthesizedAnnotation;
import cn.hutool.core.annotation.SynthesizedAnnotationAttributeProcessor;
import cn.hutool.core.annotation.SynthesizedAnnotationPostProcessor;
import cn.hutool.core.annotation.SynthesizedAnnotationProxy;
import cn.hutool.core.annotation.SynthesizedAnnotationSelector;
import cn.hutool.core.annotation.scanner.AnnotationScanner;
import cn.hutool.core.annotation.scanner.MetaAnnotationScanner;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GenericSynthesizedAggregateAnnotation
extends AbstractAnnotationSynthesizer<List<Annotation>>
implements SynthesizedAggregateAnnotation {
    private final Object root;
    private final int verticalDistance;
    private final int horizontalDistance;
    private final SynthesizedAnnotationAttributeProcessor attributeProcessor;

    /*
     * WARNING - void declaration
     */
    public GenericSynthesizedAggregateAnnotation(Annotation ... source) {
        this(Arrays.asList(var1_1), new MetaAnnotationScanner());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GenericSynthesizedAggregateAnnotation(List<Annotation> source, AnnotationScanner annotationScanner) {
        this((List<Annotation>)var1_1, SynthesizedAnnotationSelector.NEAREST_AND_OLDEST_PRIORITY, new CacheableSynthesizedAnnotationAttributeProcessor(), Arrays.asList(SynthesizedAnnotationPostProcessor.ALIAS_ANNOTATION_POST_PROCESSOR, SynthesizedAnnotationPostProcessor.MIRROR_LINK_ANNOTATION_POST_PROCESSOR, SynthesizedAnnotationPostProcessor.ALIAS_LINK_ANNOTATION_POST_PROCESSOR), (AnnotationScanner)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GenericSynthesizedAggregateAnnotation(List<Annotation> source, SynthesizedAnnotationSelector annotationSelector, SynthesizedAnnotationAttributeProcessor attributeProcessor, Collection<SynthesizedAnnotationPostProcessor> annotationPostProcessors, AnnotationScanner annotationScanner) {
        this(null, 0, 0, (List<Annotation>)var1_1, (SynthesizedAnnotationSelector)var2_2, (SynthesizedAnnotationAttributeProcessor)var3_3, annotationPostProcessors, annotationScanner);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    GenericSynthesizedAggregateAnnotation(Object root, int verticalDistance, int horizontalDistance, List<Annotation> source, SynthesizedAnnotationSelector annotationSelector, SynthesizedAnnotationAttributeProcessor attributeProcessor, Collection<SynthesizedAnnotationPostProcessor> annotationPostProcessors, AnnotationScanner annotationScanner) {
        super(source, annotationSelector, annotationPostProcessors, annotationScanner);
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(attributeProcessor, "attributeProcessor must not null", new Object[0]);
        this.root = ObjectUtil.defaultIfNull(var1_1, this);
        this.verticalDistance = var2_2;
        this.horizontalDistance = var3_3;
        this.attributeProcessor = attributeProcessor;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getVerticalDistance() {
        return this.verticalDistance;
    }

    @Override
    public int getHorizontalDistance() {
        return this.horizontalDistance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Map<Class<? extends Annotation>, SynthesizedAnnotation> loadAnnotations() {
        void var1_1;
        LinkedHashMap<Class<? extends Annotation>, MetaAnnotation> annotationMap = new LinkedHashMap<Class<? extends Annotation>, MetaAnnotation>();
        for (int i = 0; i < ((List)this.source).size(); ++i) {
            void var3_3;
            Annotation sourceAnnotation = (Annotation)((List)this.source).get(i);
            Assert.isFalse(AnnotationUtil.isSynthesizedAnnotation(sourceAnnotation), "source [{}] has been synthesized", new Object[0]);
            Annotation annotation2 = sourceAnnotation;
            annotationMap.put(sourceAnnotation.annotationType(), new MetaAnnotation(annotation2, annotation2, 0, i));
            Assert.isTrue(this.annotationScanner.support(sourceAnnotation.annotationType()), "annotation scanner [{}] cannot support scan [{}]", this.annotationScanner, sourceAnnotation.annotationType());
            this.annotationScanner.scan((index, annotation) -> {
                void var2_2;
                void var1_1;
                void var3_3;
                SynthesizedAnnotation oldAnnotation = (SynthesizedAnnotation)annotationMap.get(annotation.annotationType());
                MetaAnnotation newAnnotation = new MetaAnnotation(sourceAnnotation, (Annotation)annotation, var3_3.intValue() + 1, annotationMap.size());
                if (ObjectUtil.isNull(oldAnnotation)) {
                    annotationMap.put(annotation.annotationType(), newAnnotation);
                    return;
                }
                var1_1.put(annotation.annotationType(), this.annotationSelector.choose(oldAnnotation, var2_2));
            }, var3_3.annotationType(), null);
        }
        return var1_1;
    }

    @Override
    public SynthesizedAnnotationAttributeProcessor getAnnotationAttributeProcessor() {
        return this.attributeProcessor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getAttributeValue(String attributeName, Class<?> attributeType) {
        void var2_2;
        void var1_1;
        return this.attributeProcessor.getAttributeValue((String)var1_1, var2_2, (Collection<? extends SynthesizedAnnotation>)this.synthesizedAnnotationMap.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        void var1_1;
        return (T)((Annotation)Opt.ofNullable(annotationType).map(this.synthesizedAnnotationMap::get).map(SynthesizedAnnotation::getAnnotation).map(((Class)var1_1)::cast).orElse(null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        void var1_1;
        return this.synthesizedAnnotationMap.containsKey(var1_1);
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.synthesizedAnnotationMap.values().stream().map(SynthesizedAnnotation::getAnnotation).toArray(Annotation[]::new);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Annotation> T synthesize(Class<T> annotationType, SynthesizedAnnotation annotation) {
        void var2_2;
        return SynthesizedAnnotationProxy.create(annotationType, this, (SynthesizedAnnotation)var2_2);
    }

    public static class MetaAnnotation
    extends GenericSynthesizedAnnotation<Annotation, Annotation> {
        /*
         * WARNING - void declaration
         */
        protected MetaAnnotation(Annotation root, Annotation annotation, int verticalDistance, int horizontalDistance) {
            super(var1_1, var2_2, (int)var3_3, horizontalDistance);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

