/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.AnnotationAttribute;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class CacheableAnnotationAttribute
implements AnnotationAttribute {
    private volatile boolean valueInvoked;
    private Object value;
    private boolean defaultValueInvoked;
    private Object defaultValue;
    private final Annotation annotation;
    private final Method attribute;

    /*
     * WARNING - void declaration
     */
    public CacheableAnnotationAttribute(Annotation annotation, Method attribute) {
        void var2_2;
        void var1_1;
        Assert.notNull(annotation, "annotation must not null", new Object[0]);
        Assert.notNull(attribute, "attribute must not null", new Object[0]);
        this.annotation = var1_1;
        this.attribute = var2_2;
        this.valueInvoked = false;
        this.defaultValueInvoked = false;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Method getAttribute() {
        return this.attribute;
    }

    @Override
    public Object getValue() {
        if (!this.valueInvoked) {
            CacheableAnnotationAttribute cacheableAnnotationAttribute = this;
            synchronized (cacheableAnnotationAttribute) {
                if (!this.valueInvoked) {
                    this.valueInvoked = true;
                    this.value = ReflectUtil.invoke((Object)this.annotation, this.attribute, new Object[0]);
                }
            }
        }
        return this.value;
    }

    @Override
    public boolean isValueEquivalentToDefaultValue() {
        if (!this.defaultValueInvoked) {
            this.defaultValue = this.attribute.getDefaultValue();
            this.defaultValueInvoked = true;
        }
        return ObjectUtil.equals(this.getValue(), this.defaultValue);
    }
}

